# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .create_autonomous_container_database_base import CreateAutonomousContainerDatabaseBase
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateAutonomousContainerDatabaseFromBackupDetails(CreateAutonomousContainerDatabaseBase):
    """
    Details to create an Autonomous Container Database (ACD) by cloning a backup of an existing ACD.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateAutonomousContainerDatabaseFromBackupDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.CreateAutonomousContainerDatabaseFromBackupDetails.source` attribute
        of this class is ``BACKUP_FROM_ID`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param customer_contacts:
            The value to assign to the customer_contacts property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type customer_contacts: list[oci.database.models.CustomerContact]

        :param okv_end_point_group_name:
            The value to assign to the okv_end_point_group_name property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type okv_end_point_group_name: str

        :param source:
            The value to assign to the source property of this CreateAutonomousContainerDatabaseFromBackupDetails.
            Allowed values for this property are: "NONE", "BACKUP_FROM_ID"
        :type source: str

        :param display_name:
            The value to assign to the display_name property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type display_name: str

        :param db_unique_name:
            The value to assign to the db_unique_name property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type db_unique_name: str

        :param db_name:
            The value to assign to the db_name property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type db_name: str

        :param service_level_agreement_type:
            The value to assign to the service_level_agreement_type property of this CreateAutonomousContainerDatabaseFromBackupDetails.
            Allowed values for this property are: "STANDARD", "AUTONOMOUS_DATAGUARD"
        :type service_level_agreement_type: str

        :param autonomous_exadata_infrastructure_id:
            The value to assign to the autonomous_exadata_infrastructure_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type autonomous_exadata_infrastructure_id: str

        :param db_version:
            The value to assign to the db_version property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type db_version: str

        :param database_software_image_id:
            The value to assign to the database_software_image_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type database_software_image_id: str

        :param peer_autonomous_exadata_infrastructure_id:
            The value to assign to the peer_autonomous_exadata_infrastructure_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type peer_autonomous_exadata_infrastructure_id: str

        :param peer_autonomous_container_database_display_name:
            The value to assign to the peer_autonomous_container_database_display_name property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type peer_autonomous_container_database_display_name: str

        :param protection_mode:
            The value to assign to the protection_mode property of this CreateAutonomousContainerDatabaseFromBackupDetails.
            Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE"
        :type protection_mode: str

        :param fast_start_fail_over_lag_limit_in_seconds:
            The value to assign to the fast_start_fail_over_lag_limit_in_seconds property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type fast_start_fail_over_lag_limit_in_seconds: int

        :param is_automatic_failover_enabled:
            The value to assign to the is_automatic_failover_enabled property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type is_automatic_failover_enabled: bool

        :param peer_cloud_autonomous_vm_cluster_id:
            The value to assign to the peer_cloud_autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type peer_cloud_autonomous_vm_cluster_id: str

        :param peer_autonomous_vm_cluster_id:
            The value to assign to the peer_autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type peer_autonomous_vm_cluster_id: str

        :param peer_autonomous_container_database_compartment_id:
            The value to assign to the peer_autonomous_container_database_compartment_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type peer_autonomous_container_database_compartment_id: str

        :param peer_autonomous_container_database_backup_config:
            The value to assign to the peer_autonomous_container_database_backup_config property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type peer_autonomous_container_database_backup_config: oci.database.models.PeerAutonomousContainerDatabaseBackupConfig

        :param peer_db_unique_name:
            The value to assign to the peer_db_unique_name property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type peer_db_unique_name: str

        :param autonomous_vm_cluster_id:
            The value to assign to the autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type autonomous_vm_cluster_id: str

        :param cloud_autonomous_vm_cluster_id:
            The value to assign to the cloud_autonomous_vm_cluster_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type cloud_autonomous_vm_cluster_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type compartment_id: str

        :param patch_model:
            The value to assign to the patch_model property of this CreateAutonomousContainerDatabaseFromBackupDetails.
            Allowed values for this property are: "RELEASE_UPDATES", "RELEASE_UPDATE_REVISIONS"
        :type patch_model: str

        :param maintenance_window_details:
            The value to assign to the maintenance_window_details property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type maintenance_window_details: oci.database.models.MaintenanceWindow

        :param standby_maintenance_buffer_in_days:
            The value to assign to the standby_maintenance_buffer_in_days property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type standby_maintenance_buffer_in_days: int

        :param version_preference:
            The value to assign to the version_preference property of this CreateAutonomousContainerDatabaseFromBackupDetails.
            Allowed values for this property are: "NEXT_RELEASE_UPDATE", "LATEST_RELEASE_UPDATE"
        :type version_preference: str

        :param is_dst_file_update_enabled:
            The value to assign to the is_dst_file_update_enabled property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type is_dst_file_update_enabled: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param backup_config:
            The value to assign to the backup_config property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type backup_config: oci.database.models.AutonomousContainerDatabaseBackupConfig

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type kms_key_version_id: str

        :param vault_id:
            The value to assign to the vault_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type vault_id: str

        :param key_store_id:
            The value to assign to the key_store_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type key_store_id: str

        :param db_split_threshold:
            The value to assign to the db_split_threshold property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type db_split_threshold: int

        :param vm_failover_reservation:
            The value to assign to the vm_failover_reservation property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type vm_failover_reservation: int

        :param distribution_affinity:
            The value to assign to the distribution_affinity property of this CreateAutonomousContainerDatabaseFromBackupDetails.
            Allowed values for this property are: "MINIMUM_DISTRIBUTION", "MAXIMUM_DISTRIBUTION"
        :type distribution_affinity: str

        :param net_services_architecture:
            The value to assign to the net_services_architecture property of this CreateAutonomousContainerDatabaseFromBackupDetails.
            Allowed values for this property are: "DEDICATED", "SHARED"
        :type net_services_architecture: str

        :param autonomous_container_database_backup_id:
            The value to assign to the autonomous_container_database_backup_id property of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type autonomous_container_database_backup_id: str

        """
        self.swagger_types = {
            'customer_contacts': 'list[CustomerContact]',
            'okv_end_point_group_name': 'str',
            'source': 'str',
            'display_name': 'str',
            'db_unique_name': 'str',
            'db_name': 'str',
            'service_level_agreement_type': 'str',
            'autonomous_exadata_infrastructure_id': 'str',
            'db_version': 'str',
            'database_software_image_id': 'str',
            'peer_autonomous_exadata_infrastructure_id': 'str',
            'peer_autonomous_container_database_display_name': 'str',
            'protection_mode': 'str',
            'fast_start_fail_over_lag_limit_in_seconds': 'int',
            'is_automatic_failover_enabled': 'bool',
            'peer_cloud_autonomous_vm_cluster_id': 'str',
            'peer_autonomous_vm_cluster_id': 'str',
            'peer_autonomous_container_database_compartment_id': 'str',
            'peer_autonomous_container_database_backup_config': 'PeerAutonomousContainerDatabaseBackupConfig',
            'peer_db_unique_name': 'str',
            'autonomous_vm_cluster_id': 'str',
            'cloud_autonomous_vm_cluster_id': 'str',
            'compartment_id': 'str',
            'patch_model': 'str',
            'maintenance_window_details': 'MaintenanceWindow',
            'standby_maintenance_buffer_in_days': 'int',
            'version_preference': 'str',
            'is_dst_file_update_enabled': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'backup_config': 'AutonomousContainerDatabaseBackupConfig',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str',
            'vault_id': 'str',
            'key_store_id': 'str',
            'db_split_threshold': 'int',
            'vm_failover_reservation': 'int',
            'distribution_affinity': 'str',
            'net_services_architecture': 'str',
            'autonomous_container_database_backup_id': 'str'
        }
        self.attribute_map = {
            'customer_contacts': 'customerContacts',
            'okv_end_point_group_name': 'okvEndPointGroupName',
            'source': 'source',
            'display_name': 'displayName',
            'db_unique_name': 'dbUniqueName',
            'db_name': 'dbName',
            'service_level_agreement_type': 'serviceLevelAgreementType',
            'autonomous_exadata_infrastructure_id': 'autonomousExadataInfrastructureId',
            'db_version': 'dbVersion',
            'database_software_image_id': 'databaseSoftwareImageId',
            'peer_autonomous_exadata_infrastructure_id': 'peerAutonomousExadataInfrastructureId',
            'peer_autonomous_container_database_display_name': 'peerAutonomousContainerDatabaseDisplayName',
            'protection_mode': 'protectionMode',
            'fast_start_fail_over_lag_limit_in_seconds': 'fastStartFailOverLagLimitInSeconds',
            'is_automatic_failover_enabled': 'isAutomaticFailoverEnabled',
            'peer_cloud_autonomous_vm_cluster_id': 'peerCloudAutonomousVmClusterId',
            'peer_autonomous_vm_cluster_id': 'peerAutonomousVmClusterId',
            'peer_autonomous_container_database_compartment_id': 'peerAutonomousContainerDatabaseCompartmentId',
            'peer_autonomous_container_database_backup_config': 'peerAutonomousContainerDatabaseBackupConfig',
            'peer_db_unique_name': 'peerDbUniqueName',
            'autonomous_vm_cluster_id': 'autonomousVmClusterId',
            'cloud_autonomous_vm_cluster_id': 'cloudAutonomousVmClusterId',
            'compartment_id': 'compartmentId',
            'patch_model': 'patchModel',
            'maintenance_window_details': 'maintenanceWindowDetails',
            'standby_maintenance_buffer_in_days': 'standbyMaintenanceBufferInDays',
            'version_preference': 'versionPreference',
            'is_dst_file_update_enabled': 'isDstFileUpdateEnabled',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'backup_config': 'backupConfig',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId',
            'vault_id': 'vaultId',
            'key_store_id': 'keyStoreId',
            'db_split_threshold': 'dbSplitThreshold',
            'vm_failover_reservation': 'vmFailoverReservation',
            'distribution_affinity': 'distributionAffinity',
            'net_services_architecture': 'netServicesArchitecture',
            'autonomous_container_database_backup_id': 'autonomousContainerDatabaseBackupId'
        }
        self._customer_contacts = None
        self._okv_end_point_group_name = None
        self._source = None
        self._display_name = None
        self._db_unique_name = None
        self._db_name = None
        self._service_level_agreement_type = None
        self._autonomous_exadata_infrastructure_id = None
        self._db_version = None
        self._database_software_image_id = None
        self._peer_autonomous_exadata_infrastructure_id = None
        self._peer_autonomous_container_database_display_name = None
        self._protection_mode = None
        self._fast_start_fail_over_lag_limit_in_seconds = None
        self._is_automatic_failover_enabled = None
        self._peer_cloud_autonomous_vm_cluster_id = None
        self._peer_autonomous_vm_cluster_id = None
        self._peer_autonomous_container_database_compartment_id = None
        self._peer_autonomous_container_database_backup_config = None
        self._peer_db_unique_name = None
        self._autonomous_vm_cluster_id = None
        self._cloud_autonomous_vm_cluster_id = None
        self._compartment_id = None
        self._patch_model = None
        self._maintenance_window_details = None
        self._standby_maintenance_buffer_in_days = None
        self._version_preference = None
        self._is_dst_file_update_enabled = None
        self._freeform_tags = None
        self._defined_tags = None
        self._backup_config = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._vault_id = None
        self._key_store_id = None
        self._db_split_threshold = None
        self._vm_failover_reservation = None
        self._distribution_affinity = None
        self._net_services_architecture = None
        self._autonomous_container_database_backup_id = None
        self._source = 'BACKUP_FROM_ID'

    @property
    def autonomous_container_database_backup_id(self):
        """
        **[Required]** Gets the autonomous_container_database_backup_id of this CreateAutonomousContainerDatabaseFromBackupDetails.
        The `OCID`__ of the source ACD backup that you will clone to create a new ACD.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The autonomous_container_database_backup_id of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :rtype: str
        """
        return self._autonomous_container_database_backup_id

    @autonomous_container_database_backup_id.setter
    def autonomous_container_database_backup_id(self, autonomous_container_database_backup_id):
        """
        Sets the autonomous_container_database_backup_id of this CreateAutonomousContainerDatabaseFromBackupDetails.
        The `OCID`__ of the source ACD backup that you will clone to create a new ACD.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param autonomous_container_database_backup_id: The autonomous_container_database_backup_id of this CreateAutonomousContainerDatabaseFromBackupDetails.
        :type: str
        """
        self._autonomous_container_database_backup_id = autonomous_container_database_backup_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
