# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSchedulingPolicyDetails(object):
    """
    Request to create Scheduling Policy resource with Maintenance windows per cadence.
    """

    #: A constant which can be used with the cadence property of a CreateSchedulingPolicyDetails.
    #: This constant has a value of "HALFYEARLY"
    CADENCE_HALFYEARLY = "HALFYEARLY"

    #: A constant which can be used with the cadence property of a CreateSchedulingPolicyDetails.
    #: This constant has a value of "QUARTERLY"
    CADENCE_QUARTERLY = "QUARTERLY"

    #: A constant which can be used with the cadence property of a CreateSchedulingPolicyDetails.
    #: This constant has a value of "MONTHLY"
    CADENCE_MONTHLY = "MONTHLY"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSchedulingPolicyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateSchedulingPolicyDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateSchedulingPolicyDetails.
        :type display_name: str

        :param cadence:
            The value to assign to the cadence property of this CreateSchedulingPolicyDetails.
            Allowed values for this property are: "HALFYEARLY", "QUARTERLY", "MONTHLY"
        :type cadence: str

        :param cadence_start_month:
            The value to assign to the cadence_start_month property of this CreateSchedulingPolicyDetails.
        :type cadence_start_month: oci.database.models.Month

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateSchedulingPolicyDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateSchedulingPolicyDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'cadence': 'str',
            'cadence_start_month': 'Month',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'cadence': 'cadence',
            'cadence_start_month': 'cadenceStartMonth',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._cadence = None
        self._cadence_start_month = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateSchedulingPolicyDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateSchedulingPolicyDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateSchedulingPolicyDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateSchedulingPolicyDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateSchedulingPolicyDetails.
        The user-friendly name for the Scheduling Policy. The name does not need to be unique.


        :return: The display_name of this CreateSchedulingPolicyDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateSchedulingPolicyDetails.
        The user-friendly name for the Scheduling Policy. The name does not need to be unique.


        :param display_name: The display_name of this CreateSchedulingPolicyDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def cadence(self):
        """
        **[Required]** Gets the cadence of this CreateSchedulingPolicyDetails.
        The cadence period.

        Allowed values for this property are: "HALFYEARLY", "QUARTERLY", "MONTHLY"


        :return: The cadence of this CreateSchedulingPolicyDetails.
        :rtype: str
        """
        return self._cadence

    @cadence.setter
    def cadence(self, cadence):
        """
        Sets the cadence of this CreateSchedulingPolicyDetails.
        The cadence period.


        :param cadence: The cadence of this CreateSchedulingPolicyDetails.
        :type: str
        """
        allowed_values = ["HALFYEARLY", "QUARTERLY", "MONTHLY"]
        if not value_allowed_none_or_none_sentinel(cadence, allowed_values):
            raise ValueError(
                f"Invalid value for `cadence`, must be None or one of {allowed_values}"
            )
        self._cadence = cadence

    @property
    def cadence_start_month(self):
        """
        Gets the cadence_start_month of this CreateSchedulingPolicyDetails.
        Start of the month to be followed during the cadence period.


        :return: The cadence_start_month of this CreateSchedulingPolicyDetails.
        :rtype: oci.database.models.Month
        """
        return self._cadence_start_month

    @cadence_start_month.setter
    def cadence_start_month(self, cadence_start_month):
        """
        Sets the cadence_start_month of this CreateSchedulingPolicyDetails.
        Start of the month to be followed during the cadence period.


        :param cadence_start_month: The cadence_start_month of this CreateSchedulingPolicyDetails.
        :type: oci.database.models.Month
        """
        self._cadence_start_month = cadence_start_month

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateSchedulingPolicyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateSchedulingPolicyDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateSchedulingPolicyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateSchedulingPolicyDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateSchedulingPolicyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateSchedulingPolicyDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateSchedulingPolicyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateSchedulingPolicyDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
