# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateStandbyDetails(object):
    """
    Standby Creation Details.
    """

    #: A constant which can be used with the protection_mode property of a CreateStandbyDetails.
    #: This constant has a value of "MAXIMUM_AVAILABILITY"
    PROTECTION_MODE_MAXIMUM_AVAILABILITY = "MAXIMUM_AVAILABILITY"

    #: A constant which can be used with the protection_mode property of a CreateStandbyDetails.
    #: This constant has a value of "MAXIMUM_PERFORMANCE"
    PROTECTION_MODE_MAXIMUM_PERFORMANCE = "MAXIMUM_PERFORMANCE"

    #: A constant which can be used with the protection_mode property of a CreateStandbyDetails.
    #: This constant has a value of "MAXIMUM_PROTECTION"
    PROTECTION_MODE_MAXIMUM_PROTECTION = "MAXIMUM_PROTECTION"

    #: A constant which can be used with the transport_type property of a CreateStandbyDetails.
    #: This constant has a value of "SYNC"
    TRANSPORT_TYPE_SYNC = "SYNC"

    #: A constant which can be used with the transport_type property of a CreateStandbyDetails.
    #: This constant has a value of "ASYNC"
    TRANSPORT_TYPE_ASYNC = "ASYNC"

    #: A constant which can be used with the transport_type property of a CreateStandbyDetails.
    #: This constant has a value of "FASTSYNC"
    TRANSPORT_TYPE_FASTSYNC = "FASTSYNC"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateStandbyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_database_id:
            The value to assign to the source_database_id property of this CreateStandbyDetails.
        :type source_database_id: str

        :param database_admin_password:
            The value to assign to the database_admin_password property of this CreateStandbyDetails.
        :type database_admin_password: str

        :param source_tde_wallet_password:
            The value to assign to the source_tde_wallet_password property of this CreateStandbyDetails.
        :type source_tde_wallet_password: str

        :param source_encryption_key_location_details:
            The value to assign to the source_encryption_key_location_details property of this CreateStandbyDetails.
        :type source_encryption_key_location_details: oci.database.models.EncryptionKeyLocationDetails

        :param is_active_data_guard_enabled:
            The value to assign to the is_active_data_guard_enabled property of this CreateStandbyDetails.
        :type is_active_data_guard_enabled: bool

        :param db_unique_name:
            The value to assign to the db_unique_name property of this CreateStandbyDetails.
        :type db_unique_name: str

        :param sid_prefix:
            The value to assign to the sid_prefix property of this CreateStandbyDetails.
        :type sid_prefix: str

        :param protection_mode:
            The value to assign to the protection_mode property of this CreateStandbyDetails.
            Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"
        :type protection_mode: str

        :param transport_type:
            The value to assign to the transport_type property of this CreateStandbyDetails.
            Allowed values for this property are: "SYNC", "ASYNC", "FASTSYNC"
        :type transport_type: str

        :param storage_size_details:
            The value to assign to the storage_size_details property of this CreateStandbyDetails.
        :type storage_size_details: oci.database.models.DatabaseStorageSizeDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateStandbyDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateStandbyDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'source_database_id': 'str',
            'database_admin_password': 'str',
            'source_tde_wallet_password': 'str',
            'source_encryption_key_location_details': 'EncryptionKeyLocationDetails',
            'is_active_data_guard_enabled': 'bool',
            'db_unique_name': 'str',
            'sid_prefix': 'str',
            'protection_mode': 'str',
            'transport_type': 'str',
            'storage_size_details': 'DatabaseStorageSizeDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'source_database_id': 'sourceDatabaseId',
            'database_admin_password': 'databaseAdminPassword',
            'source_tde_wallet_password': 'sourceTdeWalletPassword',
            'source_encryption_key_location_details': 'sourceEncryptionKeyLocationDetails',
            'is_active_data_guard_enabled': 'isActiveDataGuardEnabled',
            'db_unique_name': 'dbUniqueName',
            'sid_prefix': 'sidPrefix',
            'protection_mode': 'protectionMode',
            'transport_type': 'transportType',
            'storage_size_details': 'storageSizeDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._source_database_id = None
        self._database_admin_password = None
        self._source_tde_wallet_password = None
        self._source_encryption_key_location_details = None
        self._is_active_data_guard_enabled = None
        self._db_unique_name = None
        self._sid_prefix = None
        self._protection_mode = None
        self._transport_type = None
        self._storage_size_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def source_database_id(self):
        """
        **[Required]** Gets the source_database_id of this CreateStandbyDetails.
        The `OCID`__ of the source database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The source_database_id of this CreateStandbyDetails.
        :rtype: str
        """
        return self._source_database_id

    @source_database_id.setter
    def source_database_id(self, source_database_id):
        """
        Sets the source_database_id of this CreateStandbyDetails.
        The `OCID`__ of the source database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param source_database_id: The source_database_id of this CreateStandbyDetails.
        :type: str
        """
        self._source_database_id = source_database_id

    @property
    def database_admin_password(self):
        """
        **[Required]** Gets the database_admin_password of this CreateStandbyDetails.
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**


        :return: The database_admin_password of this CreateStandbyDetails.
        :rtype: str
        """
        return self._database_admin_password

    @database_admin_password.setter
    def database_admin_password(self, database_admin_password):
        """
        Sets the database_admin_password of this CreateStandbyDetails.
        The administrator password of the primary database in this Data Guard association.

        **The password MUST be the same as the primary admin password.**


        :param database_admin_password: The database_admin_password of this CreateStandbyDetails.
        :type: str
        """
        self._database_admin_password = database_admin_password

    @property
    def source_tde_wallet_password(self):
        """
        **[Required]** Gets the source_tde_wallet_password of this CreateStandbyDetails.
        The TDE wallet password of the source database specified by 'sourceDatabaseId'.


        :return: The source_tde_wallet_password of this CreateStandbyDetails.
        :rtype: str
        """
        return self._source_tde_wallet_password

    @source_tde_wallet_password.setter
    def source_tde_wallet_password(self, source_tde_wallet_password):
        """
        Sets the source_tde_wallet_password of this CreateStandbyDetails.
        The TDE wallet password of the source database specified by 'sourceDatabaseId'.


        :param source_tde_wallet_password: The source_tde_wallet_password of this CreateStandbyDetails.
        :type: str
        """
        self._source_tde_wallet_password = source_tde_wallet_password

    @property
    def source_encryption_key_location_details(self):
        """
        Gets the source_encryption_key_location_details of this CreateStandbyDetails.

        :return: The source_encryption_key_location_details of this CreateStandbyDetails.
        :rtype: oci.database.models.EncryptionKeyLocationDetails
        """
        return self._source_encryption_key_location_details

    @source_encryption_key_location_details.setter
    def source_encryption_key_location_details(self, source_encryption_key_location_details):
        """
        Sets the source_encryption_key_location_details of this CreateStandbyDetails.

        :param source_encryption_key_location_details: The source_encryption_key_location_details of this CreateStandbyDetails.
        :type: oci.database.models.EncryptionKeyLocationDetails
        """
        self._source_encryption_key_location_details = source_encryption_key_location_details

    @property
    def is_active_data_guard_enabled(self):
        """
        Gets the is_active_data_guard_enabled of this CreateStandbyDetails.
        True if active Data Guard is enabled.


        :return: The is_active_data_guard_enabled of this CreateStandbyDetails.
        :rtype: bool
        """
        return self._is_active_data_guard_enabled

    @is_active_data_guard_enabled.setter
    def is_active_data_guard_enabled(self, is_active_data_guard_enabled):
        """
        Sets the is_active_data_guard_enabled of this CreateStandbyDetails.
        True if active Data Guard is enabled.


        :param is_active_data_guard_enabled: The is_active_data_guard_enabled of this CreateStandbyDetails.
        :type: bool
        """
        self._is_active_data_guard_enabled = is_active_data_guard_enabled

    @property
    def db_unique_name(self):
        """
        Gets the db_unique_name of this CreateStandbyDetails.
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.


        :return: The db_unique_name of this CreateStandbyDetails.
        :rtype: str
        """
        return self._db_unique_name

    @db_unique_name.setter
    def db_unique_name(self, db_unique_name):
        """
        Sets the db_unique_name of this CreateStandbyDetails.
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.


        :param db_unique_name: The db_unique_name of this CreateStandbyDetails.
        :type: str
        """
        self._db_unique_name = db_unique_name

    @property
    def sid_prefix(self):
        """
        Gets the sid_prefix of this CreateStandbyDetails.
        Specifies a prefix for the `Oracle SID` of the database to be created.


        :return: The sid_prefix of this CreateStandbyDetails.
        :rtype: str
        """
        return self._sid_prefix

    @sid_prefix.setter
    def sid_prefix(self, sid_prefix):
        """
        Sets the sid_prefix of this CreateStandbyDetails.
        Specifies a prefix for the `Oracle SID` of the database to be created.


        :param sid_prefix: The sid_prefix of this CreateStandbyDetails.
        :type: str
        """
        self._sid_prefix = sid_prefix

    @property
    def protection_mode(self):
        """
        **[Required]** Gets the protection_mode of this CreateStandbyDetails.
        The protection mode of this Data Guard. For more information, see
        `Oracle Data Guard Protection Modes`__
        in the Oracle Data Guard documentation.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000

        Allowed values for this property are: "MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"


        :return: The protection_mode of this CreateStandbyDetails.
        :rtype: str
        """
        return self._protection_mode

    @protection_mode.setter
    def protection_mode(self, protection_mode):
        """
        Sets the protection_mode of this CreateStandbyDetails.
        The protection mode of this Data Guard. For more information, see
        `Oracle Data Guard Protection Modes`__
        in the Oracle Data Guard documentation.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000


        :param protection_mode: The protection_mode of this CreateStandbyDetails.
        :type: str
        """
        allowed_values = ["MAXIMUM_AVAILABILITY", "MAXIMUM_PERFORMANCE", "MAXIMUM_PROTECTION"]
        if not value_allowed_none_or_none_sentinel(protection_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `protection_mode`, must be None or one of {allowed_values}"
            )
        self._protection_mode = protection_mode

    @property
    def transport_type(self):
        """
        **[Required]** Gets the transport_type of this CreateStandbyDetails.
        The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:

        * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
        * MAXIMUM_PERFORMANCE - ASYNC
        * MAXIMUM_PROTECTION - SYNC

        For more information, see
        `Redo Transport Services`__
        in the Oracle Data Guard documentation.

        **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400

        Allowed values for this property are: "SYNC", "ASYNC", "FASTSYNC"


        :return: The transport_type of this CreateStandbyDetails.
        :rtype: str
        """
        return self._transport_type

    @transport_type.setter
    def transport_type(self, transport_type):
        """
        Sets the transport_type of this CreateStandbyDetails.
        The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:

        * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
        * MAXIMUM_PERFORMANCE - ASYNC
        * MAXIMUM_PROTECTION - SYNC

        For more information, see
        `Redo Transport Services`__
        in the Oracle Data Guard documentation.

        **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.

        __ http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400


        :param transport_type: The transport_type of this CreateStandbyDetails.
        :type: str
        """
        allowed_values = ["SYNC", "ASYNC", "FASTSYNC"]
        if not value_allowed_none_or_none_sentinel(transport_type, allowed_values):
            raise ValueError(
                f"Invalid value for `transport_type`, must be None or one of {allowed_values}"
            )
        self._transport_type = transport_type

    @property
    def storage_size_details(self):
        """
        Gets the storage_size_details of this CreateStandbyDetails.

        :return: The storage_size_details of this CreateStandbyDetails.
        :rtype: oci.database.models.DatabaseStorageSizeDetails
        """
        return self._storage_size_details

    @storage_size_details.setter
    def storage_size_details(self, storage_size_details):
        """
        Sets the storage_size_details of this CreateStandbyDetails.

        :param storage_size_details: The storage_size_details of this CreateStandbyDetails.
        :type: oci.database.models.DatabaseStorageSizeDetails
        """
        self._storage_size_details = storage_size_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateStandbyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateStandbyDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateStandbyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateStandbyDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateStandbyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateStandbyDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateStandbyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateStandbyDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
