# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbNodeDetails(object):
    """
    Details of the ExaCS Db node. Applies to Exadata Database Service on Exascale Infrastructure only.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbNodeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_node_id:
            The value to assign to the db_node_id property of this DbNodeDetails.
        :type db_node_id: str

        """
        self.swagger_types = {
            'db_node_id': 'str'
        }
        self.attribute_map = {
            'db_node_id': 'dbNodeId'
        }
        self._db_node_id = None

    @property
    def db_node_id(self):
        """
        **[Required]** Gets the db_node_id of this DbNodeDetails.
        The `OCID`__ of ExaCS Db node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The db_node_id of this DbNodeDetails.
        :rtype: str
        """
        return self._db_node_id

    @db_node_id.setter
    def db_node_id(self, db_node_id):
        """
        Sets the db_node_id of this DbNodeDetails.
        The `OCID`__ of ExaCS Db node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param db_node_id: The db_node_id of this DbNodeDetails.
        :type: str
        """
        self._db_node_id = db_node_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
