# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FileSystemConfigurationDetail(object):
    """
    Details of the file system configuration of the VM cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FileSystemConfigurationDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mount_point:
            The value to assign to the mount_point property of this FileSystemConfigurationDetail.
        :type mount_point: str

        :param file_system_size_gb:
            The value to assign to the file_system_size_gb property of this FileSystemConfigurationDetail.
        :type file_system_size_gb: int

        """
        self.swagger_types = {
            'mount_point': 'str',
            'file_system_size_gb': 'int'
        }
        self.attribute_map = {
            'mount_point': 'mountPoint',
            'file_system_size_gb': 'fileSystemSizeGb'
        }
        self._mount_point = None
        self._file_system_size_gb = None

    @property
    def mount_point(self):
        """
        Gets the mount_point of this FileSystemConfigurationDetail.
        The mount point of file system.


        :return: The mount_point of this FileSystemConfigurationDetail.
        :rtype: str
        """
        return self._mount_point

    @mount_point.setter
    def mount_point(self, mount_point):
        """
        Sets the mount_point of this FileSystemConfigurationDetail.
        The mount point of file system.


        :param mount_point: The mount_point of this FileSystemConfigurationDetail.
        :type: str
        """
        self._mount_point = mount_point

    @property
    def file_system_size_gb(self):
        """
        Gets the file_system_size_gb of this FileSystemConfigurationDetail.
        The file system size to be allocated in GBs.


        :return: The file_system_size_gb of this FileSystemConfigurationDetail.
        :rtype: int
        """
        return self._file_system_size_gb

    @file_system_size_gb.setter
    def file_system_size_gb(self, file_system_size_gb):
        """
        Sets the file_system_size_gb of this FileSystemConfigurationDetail.
        The file system size to be allocated in GBs.


        :param file_system_size_gb: The file_system_size_gb of this FileSystemConfigurationDetail.
        :type: int
        """
        self._file_system_size_gb = file_system_size_gb

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
