# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateAutonomousDatabaseDetails(object):
    """
    Details to update an Oracle Autonomous AI Database.

    **Notes**
    - To specify OCPU core count, you must use either `ocpuCount` or `cpuCoreCount`. You cannot use both parameters at the same time. For Autonomous AI Database Serverless instances, `ocpuCount` is not used.
    - To specify a storage allocation, you must use  either `dataStorageSizeInGBs` or `dataStorageSizeInTBs`.
    - See the individual parameter discriptions for more information on the OCPU and storage value parameters.
    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
    """

    #: A constant which can be used with the compute_model property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "ECPU"
    COMPUTE_MODEL_ECPU = "ECPU"

    #: A constant which can be used with the compute_model property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "OCPU"
    COMPUTE_MODEL_OCPU = "OCPU"

    #: A constant which can be used with the db_workload property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "OLTP"
    DB_WORKLOAD_OLTP = "OLTP"

    #: A constant which can be used with the db_workload property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "DW"
    DB_WORKLOAD_DW = "DW"

    #: A constant which can be used with the db_workload property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "AJD"
    DB_WORKLOAD_AJD = "AJD"

    #: A constant which can be used with the db_workload property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "APEX"
    DB_WORKLOAD_APEX = "APEX"

    #: A constant which can be used with the db_workload property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "LH"
    DB_WORKLOAD_LH = "LH"

    #: A constant which can be used with the license_model property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    #: A constant which can be used with the refreshable_mode property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "AUTOMATIC"
    REFRESHABLE_MODE_AUTOMATIC = "AUTOMATIC"

    #: A constant which can be used with the refreshable_mode property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "MANUAL"
    REFRESHABLE_MODE_MANUAL = "MANUAL"

    #: A constant which can be used with the open_mode property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "READ_ONLY"
    OPEN_MODE_READ_ONLY = "READ_ONLY"

    #: A constant which can be used with the open_mode property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "READ_WRITE"
    OPEN_MODE_READ_WRITE = "READ_WRITE"

    #: A constant which can be used with the permission_level property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "RESTRICTED"
    PERMISSION_LEVEL_RESTRICTED = "RESTRICTED"

    #: A constant which can be used with the permission_level property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "UNRESTRICTED"
    PERMISSION_LEVEL_UNRESTRICTED = "UNRESTRICTED"

    #: A constant which can be used with the autonomous_maintenance_schedule_type property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "EARLY"
    AUTONOMOUS_MAINTENANCE_SCHEDULE_TYPE_EARLY = "EARLY"

    #: A constant which can be used with the autonomous_maintenance_schedule_type property of a UpdateAutonomousDatabaseDetails.
    #: This constant has a value of "REGULAR"
    AUTONOMOUS_MAINTENANCE_SCHEDULE_TYPE_REGULAR = "REGULAR"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateAutonomousDatabaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param backup_retention_period_in_days:
            The value to assign to the backup_retention_period_in_days property of this UpdateAutonomousDatabaseDetails.
        :type backup_retention_period_in_days: int

        :param compute_model:
            The value to assign to the compute_model property of this UpdateAutonomousDatabaseDetails.
            Allowed values for this property are: "ECPU", "OCPU"
        :type compute_model: str

        :param in_memory_percentage:
            The value to assign to the in_memory_percentage property of this UpdateAutonomousDatabaseDetails.
        :type in_memory_percentage: int

        :param local_adg_auto_failover_max_data_loss_limit:
            The value to assign to the local_adg_auto_failover_max_data_loss_limit property of this UpdateAutonomousDatabaseDetails.
        :type local_adg_auto_failover_max_data_loss_limit: int

        :param cpu_core_count:
            The value to assign to the cpu_core_count property of this UpdateAutonomousDatabaseDetails.
        :type cpu_core_count: int

        :param long_term_backup_schedule:
            The value to assign to the long_term_backup_schedule property of this UpdateAutonomousDatabaseDetails.
        :type long_term_backup_schedule: oci.database.models.LongTermBackUpScheduleDetails

        :param is_dev_tier:
            The value to assign to the is_dev_tier property of this UpdateAutonomousDatabaseDetails.
        :type is_dev_tier: bool

        :param compute_count:
            The value to assign to the compute_count property of this UpdateAutonomousDatabaseDetails.
        :type compute_count: float

        :param ocpu_count:
            The value to assign to the ocpu_count property of this UpdateAutonomousDatabaseDetails.
        :type ocpu_count: float

        :param data_storage_size_in_tbs:
            The value to assign to the data_storage_size_in_tbs property of this UpdateAutonomousDatabaseDetails.
        :type data_storage_size_in_tbs: int

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this UpdateAutonomousDatabaseDetails.
        :type data_storage_size_in_gbs: int

        :param display_name:
            The value to assign to the display_name property of this UpdateAutonomousDatabaseDetails.
        :type display_name: str

        :param is_free_tier:
            The value to assign to the is_free_tier property of this UpdateAutonomousDatabaseDetails.
        :type is_free_tier: bool

        :param admin_password:
            The value to assign to the admin_password property of this UpdateAutonomousDatabaseDetails.
        :type admin_password: str

        :param db_name:
            The value to assign to the db_name property of this UpdateAutonomousDatabaseDetails.
        :type db_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateAutonomousDatabaseDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateAutonomousDatabaseDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param security_attributes:
            The value to assign to the security_attributes property of this UpdateAutonomousDatabaseDetails.
        :type security_attributes: dict(str, dict(str, object))

        :param db_workload:
            The value to assign to the db_workload property of this UpdateAutonomousDatabaseDetails.
            Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", "LH"
        :type db_workload: str

        :param license_model:
            The value to assign to the license_model property of this UpdateAutonomousDatabaseDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        :param byol_compute_count_limit:
            The value to assign to the byol_compute_count_limit property of this UpdateAutonomousDatabaseDetails.
        :type byol_compute_count_limit: float

        :param is_access_control_enabled:
            The value to assign to the is_access_control_enabled property of this UpdateAutonomousDatabaseDetails.
        :type is_access_control_enabled: bool

        :param whitelisted_ips:
            The value to assign to the whitelisted_ips property of this UpdateAutonomousDatabaseDetails.
        :type whitelisted_ips: list[str]

        :param are_primary_whitelisted_ips_used:
            The value to assign to the are_primary_whitelisted_ips_used property of this UpdateAutonomousDatabaseDetails.
        :type are_primary_whitelisted_ips_used: bool

        :param standby_whitelisted_ips:
            The value to assign to the standby_whitelisted_ips property of this UpdateAutonomousDatabaseDetails.
        :type standby_whitelisted_ips: list[str]

        :param is_auto_scaling_enabled:
            The value to assign to the is_auto_scaling_enabled property of this UpdateAutonomousDatabaseDetails.
        :type is_auto_scaling_enabled: bool

        :param is_refreshable_clone:
            The value to assign to the is_refreshable_clone property of this UpdateAutonomousDatabaseDetails.
        :type is_refreshable_clone: bool

        :param refreshable_mode:
            The value to assign to the refreshable_mode property of this UpdateAutonomousDatabaseDetails.
            Allowed values for this property are: "AUTOMATIC", "MANUAL"
        :type refreshable_mode: str

        :param is_local_data_guard_enabled:
            The value to assign to the is_local_data_guard_enabled property of this UpdateAutonomousDatabaseDetails.
        :type is_local_data_guard_enabled: bool

        :param is_data_guard_enabled:
            The value to assign to the is_data_guard_enabled property of this UpdateAutonomousDatabaseDetails.
        :type is_data_guard_enabled: bool

        :param peer_db_id:
            The value to assign to the peer_db_id property of this UpdateAutonomousDatabaseDetails.
        :type peer_db_id: str

        :param db_version:
            The value to assign to the db_version property of this UpdateAutonomousDatabaseDetails.
        :type db_version: str

        :param open_mode:
            The value to assign to the open_mode property of this UpdateAutonomousDatabaseDetails.
            Allowed values for this property are: "READ_ONLY", "READ_WRITE"
        :type open_mode: str

        :param permission_level:
            The value to assign to the permission_level property of this UpdateAutonomousDatabaseDetails.
            Allowed values for this property are: "RESTRICTED", "UNRESTRICTED"
        :type permission_level: str

        :param subnet_id:
            The value to assign to the subnet_id property of this UpdateAutonomousDatabaseDetails.
        :type subnet_id: str

        :param private_endpoint_label:
            The value to assign to the private_endpoint_label property of this UpdateAutonomousDatabaseDetails.
        :type private_endpoint_label: str

        :param private_endpoint_ip:
            The value to assign to the private_endpoint_ip property of this UpdateAutonomousDatabaseDetails.
        :type private_endpoint_ip: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this UpdateAutonomousDatabaseDetails.
        :type nsg_ids: list[str]

        :param auto_refresh_frequency_in_seconds:
            The value to assign to the auto_refresh_frequency_in_seconds property of this UpdateAutonomousDatabaseDetails.
        :type auto_refresh_frequency_in_seconds: int

        :param auto_refresh_point_lag_in_seconds:
            The value to assign to the auto_refresh_point_lag_in_seconds property of this UpdateAutonomousDatabaseDetails.
        :type auto_refresh_point_lag_in_seconds: int

        :param time_of_auto_refresh_start:
            The value to assign to the time_of_auto_refresh_start property of this UpdateAutonomousDatabaseDetails.
        :type time_of_auto_refresh_start: datetime

        :param customer_contacts:
            The value to assign to the customer_contacts property of this UpdateAutonomousDatabaseDetails.
        :type customer_contacts: list[oci.database.models.CustomerContact]

        :param is_mtls_connection_required:
            The value to assign to the is_mtls_connection_required property of this UpdateAutonomousDatabaseDetails.
        :type is_mtls_connection_required: bool

        :param resource_pool_leader_id:
            The value to assign to the resource_pool_leader_id property of this UpdateAutonomousDatabaseDetails.
        :type resource_pool_leader_id: str

        :param resource_pool_summary:
            The value to assign to the resource_pool_summary property of this UpdateAutonomousDatabaseDetails.
        :type resource_pool_summary: oci.database.models.ResourcePoolSummary

        :param autonomous_maintenance_schedule_type:
            The value to assign to the autonomous_maintenance_schedule_type property of this UpdateAutonomousDatabaseDetails.
            Allowed values for this property are: "EARLY", "REGULAR"
        :type autonomous_maintenance_schedule_type: str

        :param autonomous_database_maintenance_window:
            The value to assign to the autonomous_database_maintenance_window property of this UpdateAutonomousDatabaseDetails.
        :type autonomous_database_maintenance_window: oci.database.models.AutonomousDatabaseMaintenanceWindowSummary

        :param time_maintenance_pause_until:
            The value to assign to the time_maintenance_pause_until property of this UpdateAutonomousDatabaseDetails.
        :type time_maintenance_pause_until: datetime

        :param is_backup_retention_locked:
            The value to assign to the is_backup_retention_locked property of this UpdateAutonomousDatabaseDetails.
        :type is_backup_retention_locked: bool

        :param time_scheduled_db_version_upgrade:
            The value to assign to the time_scheduled_db_version_upgrade property of this UpdateAutonomousDatabaseDetails.
        :type time_scheduled_db_version_upgrade: datetime

        :param is_disable_db_version_upgrade_schedule:
            The value to assign to the is_disable_db_version_upgrade_schedule property of this UpdateAutonomousDatabaseDetails.
        :type is_disable_db_version_upgrade_schedule: bool

        :param is_schedule_db_version_upgrade_to_earliest:
            The value to assign to the is_schedule_db_version_upgrade_to_earliest property of this UpdateAutonomousDatabaseDetails.
        :type is_schedule_db_version_upgrade_to_earliest: bool

        :param scheduled_operations:
            The value to assign to the scheduled_operations property of this UpdateAutonomousDatabaseDetails.
        :type scheduled_operations: list[oci.database.models.ScheduledOperationDetails]

        :param is_auto_scaling_for_storage_enabled:
            The value to assign to the is_auto_scaling_for_storage_enabled property of this UpdateAutonomousDatabaseDetails.
        :type is_auto_scaling_for_storage_enabled: bool

        :param database_edition:
            The value to assign to the database_edition property of this UpdateAutonomousDatabaseDetails.
        :type database_edition: str

        :param db_tools_details:
            The value to assign to the db_tools_details property of this UpdateAutonomousDatabaseDetails.
        :type db_tools_details: list[oci.database.models.DatabaseTool]

        :param vanity_url_details:
            The value to assign to the vanity_url_details property of this UpdateAutonomousDatabaseDetails.
        :type vanity_url_details: oci.database.models.VanityUrlDetails

        :param secret_id:
            The value to assign to the secret_id property of this UpdateAutonomousDatabaseDetails.
        :type secret_id: str

        :param secret_version_number:
            The value to assign to the secret_version_number property of this UpdateAutonomousDatabaseDetails.
        :type secret_version_number: int

        :param encryption_key:
            The value to assign to the encryption_key property of this UpdateAutonomousDatabaseDetails.
        :type encryption_key: oci.database.models.AutonomousDatabaseEncryptionKeyDetails

        :param is_disconnect_peer:
            The value to assign to the is_disconnect_peer property of this UpdateAutonomousDatabaseDetails.
        :type is_disconnect_peer: bool

        :param local_adg_resource_pool_leader_id:
            The value to assign to the local_adg_resource_pool_leader_id property of this UpdateAutonomousDatabaseDetails.
        :type local_adg_resource_pool_leader_id: str

        """
        self.swagger_types = {
            'backup_retention_period_in_days': 'int',
            'compute_model': 'str',
            'in_memory_percentage': 'int',
            'local_adg_auto_failover_max_data_loss_limit': 'int',
            'cpu_core_count': 'int',
            'long_term_backup_schedule': 'LongTermBackUpScheduleDetails',
            'is_dev_tier': 'bool',
            'compute_count': 'float',
            'ocpu_count': 'float',
            'data_storage_size_in_tbs': 'int',
            'data_storage_size_in_gbs': 'int',
            'display_name': 'str',
            'is_free_tier': 'bool',
            'admin_password': 'str',
            'db_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'security_attributes': 'dict(str, dict(str, object))',
            'db_workload': 'str',
            'license_model': 'str',
            'byol_compute_count_limit': 'float',
            'is_access_control_enabled': 'bool',
            'whitelisted_ips': 'list[str]',
            'are_primary_whitelisted_ips_used': 'bool',
            'standby_whitelisted_ips': 'list[str]',
            'is_auto_scaling_enabled': 'bool',
            'is_refreshable_clone': 'bool',
            'refreshable_mode': 'str',
            'is_local_data_guard_enabled': 'bool',
            'is_data_guard_enabled': 'bool',
            'peer_db_id': 'str',
            'db_version': 'str',
            'open_mode': 'str',
            'permission_level': 'str',
            'subnet_id': 'str',
            'private_endpoint_label': 'str',
            'private_endpoint_ip': 'str',
            'nsg_ids': 'list[str]',
            'auto_refresh_frequency_in_seconds': 'int',
            'auto_refresh_point_lag_in_seconds': 'int',
            'time_of_auto_refresh_start': 'datetime',
            'customer_contacts': 'list[CustomerContact]',
            'is_mtls_connection_required': 'bool',
            'resource_pool_leader_id': 'str',
            'resource_pool_summary': 'ResourcePoolSummary',
            'autonomous_maintenance_schedule_type': 'str',
            'autonomous_database_maintenance_window': 'AutonomousDatabaseMaintenanceWindowSummary',
            'time_maintenance_pause_until': 'datetime',
            'is_backup_retention_locked': 'bool',
            'time_scheduled_db_version_upgrade': 'datetime',
            'is_disable_db_version_upgrade_schedule': 'bool',
            'is_schedule_db_version_upgrade_to_earliest': 'bool',
            'scheduled_operations': 'list[ScheduledOperationDetails]',
            'is_auto_scaling_for_storage_enabled': 'bool',
            'database_edition': 'str',
            'db_tools_details': 'list[DatabaseTool]',
            'vanity_url_details': 'VanityUrlDetails',
            'secret_id': 'str',
            'secret_version_number': 'int',
            'encryption_key': 'AutonomousDatabaseEncryptionKeyDetails',
            'is_disconnect_peer': 'bool',
            'local_adg_resource_pool_leader_id': 'str'
        }
        self.attribute_map = {
            'backup_retention_period_in_days': 'backupRetentionPeriodInDays',
            'compute_model': 'computeModel',
            'in_memory_percentage': 'inMemoryPercentage',
            'local_adg_auto_failover_max_data_loss_limit': 'localAdgAutoFailoverMaxDataLossLimit',
            'cpu_core_count': 'cpuCoreCount',
            'long_term_backup_schedule': 'longTermBackupSchedule',
            'is_dev_tier': 'isDevTier',
            'compute_count': 'computeCount',
            'ocpu_count': 'ocpuCount',
            'data_storage_size_in_tbs': 'dataStorageSizeInTBs',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'display_name': 'displayName',
            'is_free_tier': 'isFreeTier',
            'admin_password': 'adminPassword',
            'db_name': 'dbName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'security_attributes': 'securityAttributes',
            'db_workload': 'dbWorkload',
            'license_model': 'licenseModel',
            'byol_compute_count_limit': 'byolComputeCountLimit',
            'is_access_control_enabled': 'isAccessControlEnabled',
            'whitelisted_ips': 'whitelistedIps',
            'are_primary_whitelisted_ips_used': 'arePrimaryWhitelistedIpsUsed',
            'standby_whitelisted_ips': 'standbyWhitelistedIps',
            'is_auto_scaling_enabled': 'isAutoScalingEnabled',
            'is_refreshable_clone': 'isRefreshableClone',
            'refreshable_mode': 'refreshableMode',
            'is_local_data_guard_enabled': 'isLocalDataGuardEnabled',
            'is_data_guard_enabled': 'isDataGuardEnabled',
            'peer_db_id': 'peerDbId',
            'db_version': 'dbVersion',
            'open_mode': 'openMode',
            'permission_level': 'permissionLevel',
            'subnet_id': 'subnetId',
            'private_endpoint_label': 'privateEndpointLabel',
            'private_endpoint_ip': 'privateEndpointIp',
            'nsg_ids': 'nsgIds',
            'auto_refresh_frequency_in_seconds': 'autoRefreshFrequencyInSeconds',
            'auto_refresh_point_lag_in_seconds': 'autoRefreshPointLagInSeconds',
            'time_of_auto_refresh_start': 'timeOfAutoRefreshStart',
            'customer_contacts': 'customerContacts',
            'is_mtls_connection_required': 'isMtlsConnectionRequired',
            'resource_pool_leader_id': 'resourcePoolLeaderId',
            'resource_pool_summary': 'resourcePoolSummary',
            'autonomous_maintenance_schedule_type': 'autonomousMaintenanceScheduleType',
            'autonomous_database_maintenance_window': 'autonomousDatabaseMaintenanceWindow',
            'time_maintenance_pause_until': 'timeMaintenancePauseUntil',
            'is_backup_retention_locked': 'isBackupRetentionLocked',
            'time_scheduled_db_version_upgrade': 'timeScheduledDbVersionUpgrade',
            'is_disable_db_version_upgrade_schedule': 'isDisableDbVersionUpgradeSchedule',
            'is_schedule_db_version_upgrade_to_earliest': 'isScheduleDbVersionUpgradeToEarliest',
            'scheduled_operations': 'scheduledOperations',
            'is_auto_scaling_for_storage_enabled': 'isAutoScalingForStorageEnabled',
            'database_edition': 'databaseEdition',
            'db_tools_details': 'dbToolsDetails',
            'vanity_url_details': 'vanityUrlDetails',
            'secret_id': 'secretId',
            'secret_version_number': 'secretVersionNumber',
            'encryption_key': 'encryptionKey',
            'is_disconnect_peer': 'isDisconnectPeer',
            'local_adg_resource_pool_leader_id': 'localAdgResourcePoolLeaderId'
        }
        self._backup_retention_period_in_days = None
        self._compute_model = None
        self._in_memory_percentage = None
        self._local_adg_auto_failover_max_data_loss_limit = None
        self._cpu_core_count = None
        self._long_term_backup_schedule = None
        self._is_dev_tier = None
        self._compute_count = None
        self._ocpu_count = None
        self._data_storage_size_in_tbs = None
        self._data_storage_size_in_gbs = None
        self._display_name = None
        self._is_free_tier = None
        self._admin_password = None
        self._db_name = None
        self._freeform_tags = None
        self._defined_tags = None
        self._security_attributes = None
        self._db_workload = None
        self._license_model = None
        self._byol_compute_count_limit = None
        self._is_access_control_enabled = None
        self._whitelisted_ips = None
        self._are_primary_whitelisted_ips_used = None
        self._standby_whitelisted_ips = None
        self._is_auto_scaling_enabled = None
        self._is_refreshable_clone = None
        self._refreshable_mode = None
        self._is_local_data_guard_enabled = None
        self._is_data_guard_enabled = None
        self._peer_db_id = None
        self._db_version = None
        self._open_mode = None
        self._permission_level = None
        self._subnet_id = None
        self._private_endpoint_label = None
        self._private_endpoint_ip = None
        self._nsg_ids = None
        self._auto_refresh_frequency_in_seconds = None
        self._auto_refresh_point_lag_in_seconds = None
        self._time_of_auto_refresh_start = None
        self._customer_contacts = None
        self._is_mtls_connection_required = None
        self._resource_pool_leader_id = None
        self._resource_pool_summary = None
        self._autonomous_maintenance_schedule_type = None
        self._autonomous_database_maintenance_window = None
        self._time_maintenance_pause_until = None
        self._is_backup_retention_locked = None
        self._time_scheduled_db_version_upgrade = None
        self._is_disable_db_version_upgrade_schedule = None
        self._is_schedule_db_version_upgrade_to_earliest = None
        self._scheduled_operations = None
        self._is_auto_scaling_for_storage_enabled = None
        self._database_edition = None
        self._db_tools_details = None
        self._vanity_url_details = None
        self._secret_id = None
        self._secret_version_number = None
        self._encryption_key = None
        self._is_disconnect_peer = None
        self._local_adg_resource_pool_leader_id = None

    @property
    def backup_retention_period_in_days(self):
        """
        Gets the backup_retention_period_in_days of this UpdateAutonomousDatabaseDetails.
        Retention period, in days, for long-term backups


        :return: The backup_retention_period_in_days of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._backup_retention_period_in_days

    @backup_retention_period_in_days.setter
    def backup_retention_period_in_days(self, backup_retention_period_in_days):
        """
        Sets the backup_retention_period_in_days of this UpdateAutonomousDatabaseDetails.
        Retention period, in days, for long-term backups


        :param backup_retention_period_in_days: The backup_retention_period_in_days of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._backup_retention_period_in_days = backup_retention_period_in_days

    @property
    def compute_model(self):
        """
        Gets the compute_model of this UpdateAutonomousDatabaseDetails.
        The compute model of the Autonomous AI Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.

        Allowed values for this property are: "ECPU", "OCPU"


        :return: The compute_model of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._compute_model

    @compute_model.setter
    def compute_model(self, compute_model):
        """
        Sets the compute_model of this UpdateAutonomousDatabaseDetails.
        The compute model of the Autonomous AI Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.


        :param compute_model: The compute_model of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["ECPU", "OCPU"]
        if not value_allowed_none_or_none_sentinel(compute_model, allowed_values):
            raise ValueError(
                f"Invalid value for `compute_model`, must be None or one of {allowed_values}"
            )
        self._compute_model = compute_model

    @property
    def in_memory_percentage(self):
        """
        Gets the in_memory_percentage of this UpdateAutonomousDatabaseDetails.
        The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous AI Database. This property is applicable only to Autonomous AI Databases on the Exadata Cloud@Customer platform.


        :return: The in_memory_percentage of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._in_memory_percentage

    @in_memory_percentage.setter
    def in_memory_percentage(self, in_memory_percentage):
        """
        Sets the in_memory_percentage of this UpdateAutonomousDatabaseDetails.
        The percentage of the System Global Area(SGA) assigned to In-Memory tables in Autonomous AI Database. This property is applicable only to Autonomous AI Databases on the Exadata Cloud@Customer platform.


        :param in_memory_percentage: The in_memory_percentage of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._in_memory_percentage = in_memory_percentage

    @property
    def local_adg_auto_failover_max_data_loss_limit(self):
        """
        Gets the local_adg_auto_failover_max_data_loss_limit of this UpdateAutonomousDatabaseDetails.
        Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard


        :return: The local_adg_auto_failover_max_data_loss_limit of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._local_adg_auto_failover_max_data_loss_limit

    @local_adg_auto_failover_max_data_loss_limit.setter
    def local_adg_auto_failover_max_data_loss_limit(self, local_adg_auto_failover_max_data_loss_limit):
        """
        Sets the local_adg_auto_failover_max_data_loss_limit of this UpdateAutonomousDatabaseDetails.
        Parameter that allows users to select an acceptable maximum data loss limit in seconds, up to which Automatic Failover will be triggered when necessary for a Local Autonomous Data Guard


        :param local_adg_auto_failover_max_data_loss_limit: The local_adg_auto_failover_max_data_loss_limit of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._local_adg_auto_failover_max_data_loss_limit = local_adg_auto_failover_max_data_loss_limit

    @property
    def cpu_core_count(self):
        """
        Gets the cpu_core_count of this UpdateAutonomousDatabaseDetails.
        The number of CPUs to be made available to the Autonomous AI Database.<br>
        For Autonomous AI Databases on Dedicated Exadata Infrastructure:
        - The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        - It is suggested to use 'computeCount' parameter if you want to use fractional value to provision less than 1 core.

        **Note:** This parameter cannot be used with the `ocpuCount` or `computeCount` parameter.

        This cannot be updated in parallel with any of the following: licenseModel, databaseEdition, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :return: The cpu_core_count of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._cpu_core_count

    @cpu_core_count.setter
    def cpu_core_count(self, cpu_core_count):
        """
        Sets the cpu_core_count of this UpdateAutonomousDatabaseDetails.
        The number of CPUs to be made available to the Autonomous AI Database.<br>
        For Autonomous AI Databases on Dedicated Exadata Infrastructure:
        - The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        - It is suggested to use 'computeCount' parameter if you want to use fractional value to provision less than 1 core.

        **Note:** This parameter cannot be used with the `ocpuCount` or `computeCount` parameter.

        This cannot be updated in parallel with any of the following: licenseModel, databaseEdition, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :param cpu_core_count: The cpu_core_count of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._cpu_core_count = cpu_core_count

    @property
    def long_term_backup_schedule(self):
        """
        Gets the long_term_backup_schedule of this UpdateAutonomousDatabaseDetails.

        :return: The long_term_backup_schedule of this UpdateAutonomousDatabaseDetails.
        :rtype: oci.database.models.LongTermBackUpScheduleDetails
        """
        return self._long_term_backup_schedule

    @long_term_backup_schedule.setter
    def long_term_backup_schedule(self, long_term_backup_schedule):
        """
        Sets the long_term_backup_schedule of this UpdateAutonomousDatabaseDetails.

        :param long_term_backup_schedule: The long_term_backup_schedule of this UpdateAutonomousDatabaseDetails.
        :type: oci.database.models.LongTermBackUpScheduleDetails
        """
        self._long_term_backup_schedule = long_term_backup_schedule

    @property
    def is_dev_tier(self):
        """
        Gets the is_dev_tier of this UpdateAutonomousDatabaseDetails.
        Autonomous AI Database for Developers are fixed-shape Autonomous AI Databases that developers can use to build and test new applications. On Serverless, these are low-cost and billed per instance, on Dedicated and Cloud@Customer there is no additional cost to create Developer databases. Developer databases come with limited resources and is not intended for large-scale testing and production deployments. When you need more compute or storage resources, you may upgrade to a full paid production database.


        :return: The is_dev_tier of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_dev_tier

    @is_dev_tier.setter
    def is_dev_tier(self, is_dev_tier):
        """
        Sets the is_dev_tier of this UpdateAutonomousDatabaseDetails.
        Autonomous AI Database for Developers are fixed-shape Autonomous AI Databases that developers can use to build and test new applications. On Serverless, these are low-cost and billed per instance, on Dedicated and Cloud@Customer there is no additional cost to create Developer databases. Developer databases come with limited resources and is not intended for large-scale testing and production deployments. When you need more compute or storage resources, you may upgrade to a full paid production database.


        :param is_dev_tier: The is_dev_tier of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_dev_tier = is_dev_tier

    @property
    def compute_count(self):
        """
        Gets the compute_count of this UpdateAutonomousDatabaseDetails.
        The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous AI Database Serverless instance or an Autonomous AI Database on Dedicated Exadata Infrastructure.
        The 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.

        This cannot be updated in parallel with any of the following: licenseModel, databaseEdition, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :return: The compute_count of this UpdateAutonomousDatabaseDetails.
        :rtype: float
        """
        return self._compute_count

    @compute_count.setter
    def compute_count(self, compute_count):
        """
        Sets the compute_count of this UpdateAutonomousDatabaseDetails.
        The compute amount (CPUs) available to the database. Minimum and maximum values depend on the compute model and whether the database is an Autonomous AI Database Serverless instance or an Autonomous AI Database on Dedicated Exadata Infrastructure.
        The 'ECPU' compute model requires a minimum value of one, for databases in the elastic resource pool and minimum value of two, otherwise. Required when using the `computeModel` parameter. When using `cpuCoreCount` parameter, it is an error to specify computeCount to a non-null value. Providing `computeModel` and `computeCount` is the preferred method for both OCPU and ECPU.

        This cannot be updated in parallel with any of the following: licenseModel, databaseEdition, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :param compute_count: The compute_count of this UpdateAutonomousDatabaseDetails.
        :type: float
        """
        self._compute_count = compute_count

    @property
    def ocpu_count(self):
        """
        Gets the ocpu_count of this UpdateAutonomousDatabaseDetails.
        The number of OCPU cores to be made available to the Autonomous AI Database.

        For Autonomous AI Databases on Dedicated Exadata Infrastructure, you can specify a fractional value for this parameter. Fractional values are not supported for Autonomous AI Database Serverless instances.
        For Autonomous AI Database Serverless instances, this parameter is not used.

        To provision less than 1 core, enter a fractional value in an increment of 0.1. To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available to the infrastructure shape. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. Likewise, you can provision 2 cores or 3 cores, but not 2.5 cores. The maximum number of cores is determined by the infrastructure shape. See `Characteristics of Infrastructure Shapes`__ for shape details.

        **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbde/index.html


        :return: The ocpu_count of this UpdateAutonomousDatabaseDetails.
        :rtype: float
        """
        return self._ocpu_count

    @ocpu_count.setter
    def ocpu_count(self, ocpu_count):
        """
        Sets the ocpu_count of this UpdateAutonomousDatabaseDetails.
        The number of OCPU cores to be made available to the Autonomous AI Database.

        For Autonomous AI Databases on Dedicated Exadata Infrastructure, you can specify a fractional value for this parameter. Fractional values are not supported for Autonomous AI Database Serverless instances.
        For Autonomous AI Database Serverless instances, this parameter is not used.

        To provision less than 1 core, enter a fractional value in an increment of 0.1. To provision 1 or more cores, you must enter an integer between 1 and the maximum number of cores available to the infrastructure shape. For example, you can provision 0.3 or 0.4 cores, but not 0.35 cores. Likewise, you can provision 2 cores or 3 cores, but not 2.5 cores. The maximum number of cores is determined by the infrastructure shape. See `Characteristics of Infrastructure Shapes`__ for shape details.

        **Note:** This parameter cannot be used with the `cpuCoreCount` parameter.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbde/index.html


        :param ocpu_count: The ocpu_count of this UpdateAutonomousDatabaseDetails.
        :type: float
        """
        self._ocpu_count = ocpu_count

    @property
    def data_storage_size_in_tbs(self):
        """
        Gets the data_storage_size_in_tbs of this UpdateAutonomousDatabaseDetails.
        The size, in terabytes, of the data volume that will be created and attached to the database. For Autonomous AI Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See `Characteristics of Infrastructure Shapes`__ for shape details.
        A full Exadata service is allocated when the Autonomous AI Database size is set to the upper limit (384 TB).

        **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter.

        This cannot be updated in parallel with any of the following: licenseModel, databaseEdition, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbde/


        :return: The data_storage_size_in_tbs of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._data_storage_size_in_tbs

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, data_storage_size_in_tbs):
        """
        Sets the data_storage_size_in_tbs of this UpdateAutonomousDatabaseDetails.
        The size, in terabytes, of the data volume that will be created and attached to the database. For Autonomous AI Databases on dedicated Exadata infrastructure, the maximum storage value is determined by the infrastructure shape. See `Characteristics of Infrastructure Shapes`__ for shape details.
        A full Exadata service is allocated when the Autonomous AI Database size is set to the upper limit (384 TB).

        **Note:** This parameter cannot be used with the `dataStorageSizeInGBs` parameter.

        This cannot be updated in parallel with any of the following: licenseModel, databaseEdition, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbde/


        :param data_storage_size_in_tbs: The data_storage_size_in_tbs of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._data_storage_size_in_tbs = data_storage_size_in_tbs

    @property
    def data_storage_size_in_gbs(self):
        """
        Gets the data_storage_size_in_gbs of this UpdateAutonomousDatabaseDetails.
        Applies to dedicated Exadata infrastructure only.

        The size, in gigabytes, of the data volume that will be created and attached to the database. The maximum storage value depends on the system shape. See `Characteristics of Infrastructure Shapes`__ for shape details.

        **Note:** This parameter cannot be used with the `dataStorageSizeInTBs` parameter.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbde/


        :return: The data_storage_size_in_gbs of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this UpdateAutonomousDatabaseDetails.
        Applies to dedicated Exadata infrastructure only.

        The size, in gigabytes, of the data volume that will be created and attached to the database. The maximum storage value depends on the system shape. See `Characteristics of Infrastructure Shapes`__ for shape details.

        **Note:** This parameter cannot be used with the `dataStorageSizeInTBs` parameter.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/adbde/


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateAutonomousDatabaseDetails.
        The user-friendly name for the Autonomous AI Database. The name does not have to be unique. The display name can only be updated for Autonomous AI Databases using dedicated Exadata Infrastructure. This parameter may not be updated in parallel with dbVersion.


        :return: The display_name of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateAutonomousDatabaseDetails.
        The user-friendly name for the Autonomous AI Database. The name does not have to be unique. The display name can only be updated for Autonomous AI Databases using dedicated Exadata Infrastructure. This parameter may not be updated in parallel with dbVersion.


        :param display_name: The display_name of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def is_free_tier(self):
        """
        Gets the is_free_tier of this UpdateAutonomousDatabaseDetails.
        Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous AI Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isLocalDataGuardEnabled


        :return: The is_free_tier of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_free_tier

    @is_free_tier.setter
    def is_free_tier(self, is_free_tier):
        """
        Sets the is_free_tier of this UpdateAutonomousDatabaseDetails.
        Indicates if this is an Always Free resource. The default value is false. Note that Always Free Autonomous AI Databases have 1 CPU and 20GB of memory. For Always Free databases, memory and CPU cannot be scaled.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isLocalDataGuardEnabled


        :param is_free_tier: The is_free_tier of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_free_tier = is_free_tier

    @property
    def admin_password(self):
        """
        Gets the admin_password of this UpdateAutonomousDatabaseDetails.
        The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (\") or the username \"admin\", regardless of casing. It must be different from the last four passwords and it must not be a password used within the last 24 hours.

        This cannot be used in conjunction with with OCI vault secrets (secretId).

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, whitelistedIps, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, or isFreeTier.


        :return: The admin_password of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._admin_password

    @admin_password.setter
    def admin_password(self, admin_password):
        """
        Sets the admin_password of this UpdateAutonomousDatabaseDetails.
        The password must be between 12 and 30 characters long, and must contain at least 1 uppercase, 1 lowercase, and 1 numeric character. It cannot contain the double quote symbol (\") or the username \"admin\", regardless of casing. It must be different from the last four passwords and it must not be a password used within the last 24 hours.

        This cannot be used in conjunction with with OCI vault secrets (secretId).

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, whitelistedIps, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, or isFreeTier.


        :param admin_password: The admin_password of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._admin_password = admin_password

    @property
    def db_name(self):
        """
        Gets the db_name of this UpdateAutonomousDatabaseDetails.
        New name for this Autonomous AI Database.
        For Autonomous AI Databases on Dedicated Exadata Infrastructure, the name must begin with an alphabetic character, and can contain a maximum of eight alphanumeric characters. Special characters are not permitted.
        For Autonomous AI Database Serverless instances, the name must begin with an alphabetic character, and can contain a maximum of 30 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails.


        :return: The db_name of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._db_name

    @db_name.setter
    def db_name(self, db_name):
        """
        Sets the db_name of this UpdateAutonomousDatabaseDetails.
        New name for this Autonomous AI Database.
        For Autonomous AI Databases on Dedicated Exadata Infrastructure, the name must begin with an alphabetic character, and can contain a maximum of eight alphanumeric characters. Special characters are not permitted.
        For Autonomous AI Database Serverless instances, the name must begin with an alphabetic character, and can contain a maximum of 30 alphanumeric characters. Special characters are not permitted. The database name must be unique in the tenancy.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails.


        :param db_name: The db_name of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._db_name = db_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateAutonomousDatabaseDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateAutonomousDatabaseDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateAutonomousDatabaseDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateAutonomousDatabaseDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateAutonomousDatabaseDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateAutonomousDatabaseDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateAutonomousDatabaseDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateAutonomousDatabaseDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this UpdateAutonomousDatabaseDetails.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The security_attributes of this UpdateAutonomousDatabaseDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this UpdateAutonomousDatabaseDetails.
        Security Attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"audit\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param security_attributes: The security_attributes of this UpdateAutonomousDatabaseDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def db_workload(self):
        """
        Gets the db_workload of this UpdateAutonomousDatabaseDetails.
        The Autonomous AI Database workload type. The following values are valid:
        - OLTP - indicates an Autonomous AI Transaction Processing database
        - DW - indicates an Autonomous AI Lakehouse database
        - AJD - indicates an Autonomous AI JSON Database
        - APEX - indicates an Autonomous AI Database with the Oracle APEX AI Application Development workload type.
        - LH - indicates an Oracle Autonomous AI Lakehouse database


        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        Allowed values for this property are: "OLTP", "DW", "AJD", "APEX", "LH"


        :return: The db_workload of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._db_workload

    @db_workload.setter
    def db_workload(self, db_workload):
        """
        Sets the db_workload of this UpdateAutonomousDatabaseDetails.
        The Autonomous AI Database workload type. The following values are valid:
        - OLTP - indicates an Autonomous AI Transaction Processing database
        - DW - indicates an Autonomous AI Lakehouse database
        - AJD - indicates an Autonomous AI JSON Database
        - APEX - indicates an Autonomous AI Database with the Oracle APEX AI Application Development workload type.
        - LH - indicates an Oracle Autonomous AI Lakehouse database


        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.


        :param db_workload: The db_workload of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["OLTP", "DW", "AJD", "APEX", "LH"]
        if not value_allowed_none_or_none_sentinel(db_workload, allowed_values):
            raise ValueError(
                f"Invalid value for `db_workload`, must be None or one of {allowed_values}"
            )
        self._db_workload = db_workload

    @property
    def license_model(self):
        """
        Gets the license_model of this UpdateAutonomousDatabaseDetails.
        The Oracle license model that applies to the Oracle Autonomous AI Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud.
        License Included allows you to subscribe to new Oracle AI Database software licenses and the Oracle AI Database service.
        Note that when provisioning an `Autonomous AI Database on dedicated Exadata infrastructure`__, this attribute must be null. It is already set at the
        Autonomous Exadata Infrastructure level. When provisioning an `Autonomous AI Database Serverless]`__ database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html
        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"


        :return: The license_model of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this UpdateAutonomousDatabaseDetails.
        The Oracle license model that applies to the Oracle Autonomous AI Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud.
        License Included allows you to subscribe to new Oracle AI Database software licenses and the Oracle AI Database service.
        Note that when provisioning an `Autonomous AI Database on dedicated Exadata infrastructure`__, this attribute must be null. It is already set at the
        Autonomous Exadata Infrastructure level. When provisioning an `Autonomous AI Database Serverless]`__ database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html
        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html


        :param license_model: The license_model of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            raise ValueError(
                f"Invalid value for `license_model`, must be None or one of {allowed_values}"
            )
        self._license_model = license_model

    @property
    def byol_compute_count_limit(self):
        """
        Gets the byol_compute_count_limit of this UpdateAutonomousDatabaseDetails.
        The maximum number of CPUs allowed with a Bring Your Own License (BYOL), including those used for auto-scaling, disaster recovery, tools, etc. Any CPU usage above this limit is considered as License Included and billed.


        :return: The byol_compute_count_limit of this UpdateAutonomousDatabaseDetails.
        :rtype: float
        """
        return self._byol_compute_count_limit

    @byol_compute_count_limit.setter
    def byol_compute_count_limit(self, byol_compute_count_limit):
        """
        Sets the byol_compute_count_limit of this UpdateAutonomousDatabaseDetails.
        The maximum number of CPUs allowed with a Bring Your Own License (BYOL), including those used for auto-scaling, disaster recovery, tools, etc. Any CPU usage above this limit is considered as License Included and billed.


        :param byol_compute_count_limit: The byol_compute_count_limit of this UpdateAutonomousDatabaseDetails.
        :type: float
        """
        self._byol_compute_count_limit = byol_compute_count_limit

    @property
    def is_access_control_enabled(self):
        """
        Gets the is_access_control_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates if the database-level access control is enabled.
        If disabled, database access is defined by the network security rules.
        If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional,
         if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console.
        When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.

        This property is applicable only to Autonomous AI Databases on the Exadata Cloud@Customer platform. For Autonomous AI Database Serverless instances, `whitelistedIps` is used.


        :return: The is_access_control_enabled of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_access_control_enabled

    @is_access_control_enabled.setter
    def is_access_control_enabled(self, is_access_control_enabled):
        """
        Sets the is_access_control_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates if the database-level access control is enabled.
        If disabled, database access is defined by the network security rules.
        If enabled, database access is restricted to the IP addresses defined by the rules specified with the `whitelistedIps` property. While specifying `whitelistedIps` rules is optional,
         if database-level access control is enabled and no rules are specified, the database will become inaccessible. The rules can be added later using the `UpdateAutonomousDatabase` API operation or edit option in console.
        When creating a database clone, the desired access control setting should be specified. By default, database-level access control will be disabled for the clone.

        This property is applicable only to Autonomous AI Databases on the Exadata Cloud@Customer platform. For Autonomous AI Database Serverless instances, `whitelistedIps` is used.


        :param is_access_control_enabled: The is_access_control_enabled of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_access_control_enabled = is_access_control_enabled

    @property
    def whitelisted_ips(self):
        """
        Gets the whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        The client IP access control list (ACL). This feature is available for `Autonomous AI Database Serverless]`__ and on Exadata Cloud@Customer.
        Only clients connecting from an IP address included in the ACL may access the Autonomous AI Database instance.
        If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous AI Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.

        For Autonomous AI Database Serverless, this is an array of CIDR (classless inter-domain routing) notations for a subnet or VCN OCID (virtual cloud network Oracle Cloud ID).
        Multiple IPs and VCN OCIDs should be separate strings separated by commas, but if it\u2019s other configurations that need multiple pieces of information then its each piece is connected with semicolon (;) as a delimiter.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"ocid1.vcn.oc1.sea.<unique_id>\",\"ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1\",\"ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16\"]`
        For Exadata Cloud@Customer, this is an array of IP addresses or CIDR notations.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"1.1.2.25\"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html


        :return: The whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        :rtype: list[str]
        """
        return self._whitelisted_ips

    @whitelisted_ips.setter
    def whitelisted_ips(self, whitelisted_ips):
        """
        Sets the whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        The client IP access control list (ACL). This feature is available for `Autonomous AI Database Serverless]`__ and on Exadata Cloud@Customer.
        Only clients connecting from an IP address included in the ACL may access the Autonomous AI Database instance.
        If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous AI Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.

        For Autonomous AI Database Serverless, this is an array of CIDR (classless inter-domain routing) notations for a subnet or VCN OCID (virtual cloud network Oracle Cloud ID).
        Multiple IPs and VCN OCIDs should be separate strings separated by commas, but if it\u2019s other configurations that need multiple pieces of information then its each piece is connected with semicolon (;) as a delimiter.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"ocid1.vcn.oc1.sea.<unique_id>\",\"ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1\",\"ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16\"]`
        For Exadata Cloud@Customer, this is an array of IP addresses or CIDR notations.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"1.1.2.25\"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html


        :param whitelisted_ips: The whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        :type: list[str]
        """
        self._whitelisted_ips = whitelisted_ips

    @property
    def are_primary_whitelisted_ips_used(self):
        """
        Gets the are_primary_whitelisted_ips_used of this UpdateAutonomousDatabaseDetails.
        This field will be null if the Autonomous AI Database is not Data Guard enabled or Access Control is disabled.
        `TRUE` if the Autonomous AI Database has Data Guard and Access Control enabled, and the Autonomous AI Database uses the primary's IP access control list (ACL) for standby.
        `FALSE` if the Autonomous AI Database has Data Guard and Access Control enabled, and the Autonomous AI Database uses a different IP access control list (ACL) for standby compared to primary.


        :return: The are_primary_whitelisted_ips_used of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._are_primary_whitelisted_ips_used

    @are_primary_whitelisted_ips_used.setter
    def are_primary_whitelisted_ips_used(self, are_primary_whitelisted_ips_used):
        """
        Sets the are_primary_whitelisted_ips_used of this UpdateAutonomousDatabaseDetails.
        This field will be null if the Autonomous AI Database is not Data Guard enabled or Access Control is disabled.
        `TRUE` if the Autonomous AI Database has Data Guard and Access Control enabled, and the Autonomous AI Database uses the primary's IP access control list (ACL) for standby.
        `FALSE` if the Autonomous AI Database has Data Guard and Access Control enabled, and the Autonomous AI Database uses a different IP access control list (ACL) for standby compared to primary.


        :param are_primary_whitelisted_ips_used: The are_primary_whitelisted_ips_used of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._are_primary_whitelisted_ips_used = are_primary_whitelisted_ips_used

    @property
    def standby_whitelisted_ips(self):
        """
        Gets the standby_whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        The client IP access control list (ACL). This feature is available for `Autonomous AI Database Serverless]`__ and on Exadata Cloud@Customer.
        Only clients connecting from an IP address included in the ACL may access the Autonomous AI Database instance.
        If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous AI Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.

        For Autonomous AI Database Serverless, this is an array of CIDR (classless inter-domain routing) notations for a subnet or VCN OCID (virtual cloud network Oracle Cloud ID).
        Multiple IPs and VCN OCIDs should be separate strings separated by commas, but if it\u2019s other configurations that need multiple pieces of information then its each piece is connected with semicolon (;) as a delimiter.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"ocid1.vcn.oc1.sea.<unique_id>\",\"ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1\",\"ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16\"]`
        For Exadata Cloud@Customer, this is an array of IP addresses or CIDR notations.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"1.1.2.25\"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html


        :return: The standby_whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        :rtype: list[str]
        """
        return self._standby_whitelisted_ips

    @standby_whitelisted_ips.setter
    def standby_whitelisted_ips(self, standby_whitelisted_ips):
        """
        Sets the standby_whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        The client IP access control list (ACL). This feature is available for `Autonomous AI Database Serverless]`__ and on Exadata Cloud@Customer.
        Only clients connecting from an IP address included in the ACL may access the Autonomous AI Database instance.
        If `arePrimaryWhitelistedIpsUsed` is 'TRUE' then Autonomous AI Database uses this primary's IP access control list (ACL) for the disaster recovery peer called `standbywhitelistedips`.

        For Autonomous AI Database Serverless, this is an array of CIDR (classless inter-domain routing) notations for a subnet or VCN OCID (virtual cloud network Oracle Cloud ID).
        Multiple IPs and VCN OCIDs should be separate strings separated by commas, but if it\u2019s other configurations that need multiple pieces of information then its each piece is connected with semicolon (;) as a delimiter.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"ocid1.vcn.oc1.sea.<unique_id>\",\"ocid1.vcn.oc1.sea.<unique_id1>;1.1.1.1\",\"ocid1.vcn.oc1.sea.<unique_id2>;1.1.0.0/16\"]`
        For Exadata Cloud@Customer, this is an array of IP addresses or CIDR notations.
        Example: `[\"1.1.1.1\",\"1.1.1.0/24\",\"1.1.2.25\"]`

        For an update operation, if you want to delete all the IPs in the ACL, use an array with a single empty string entry.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html


        :param standby_whitelisted_ips: The standby_whitelisted_ips of this UpdateAutonomousDatabaseDetails.
        :type: list[str]
        """
        self._standby_whitelisted_ips = standby_whitelisted_ips

    @property
    def is_auto_scaling_enabled(self):
        """
        Gets the is_auto_scaling_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates whether auto scaling is enabled for the Autonomous AI Database CPU core count. Setting to `TRUE` enables auto scaling. Setting to `FALSE` disables auto scaling. The default value is `TRUE`. Auto scaling is only available for `Autonomous AI Database Serverless instances`__.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/serverless/


        :return: The is_auto_scaling_enabled of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_auto_scaling_enabled

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, is_auto_scaling_enabled):
        """
        Sets the is_auto_scaling_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates whether auto scaling is enabled for the Autonomous AI Database CPU core count. Setting to `TRUE` enables auto scaling. Setting to `FALSE` disables auto scaling. The default value is `TRUE`. Auto scaling is only available for `Autonomous AI Database Serverless instances`__.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/serverless/


        :param is_auto_scaling_enabled: The is_auto_scaling_enabled of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_auto_scaling_enabled = is_auto_scaling_enabled

    @property
    def is_refreshable_clone(self):
        """
        Gets the is_refreshable_clone of this UpdateAutonomousDatabaseDetails.
        Indicates if the Autonomous AI Database is a refreshable clone.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.


        :return: The is_refreshable_clone of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_refreshable_clone

    @is_refreshable_clone.setter
    def is_refreshable_clone(self, is_refreshable_clone):
        """
        Sets the is_refreshable_clone of this UpdateAutonomousDatabaseDetails.
        Indicates if the Autonomous AI Database is a refreshable clone.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.


        :param is_refreshable_clone: The is_refreshable_clone of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_refreshable_clone = is_refreshable_clone

    @property
    def refreshable_mode(self):
        """
        Gets the refreshable_mode of this UpdateAutonomousDatabaseDetails.
        The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous AI Database.

        Allowed values for this property are: "AUTOMATIC", "MANUAL"


        :return: The refreshable_mode of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._refreshable_mode

    @refreshable_mode.setter
    def refreshable_mode(self, refreshable_mode):
        """
        Sets the refreshable_mode of this UpdateAutonomousDatabaseDetails.
        The refresh mode of the clone. AUTOMATIC indicates that the clone is automatically being refreshed with data from the source Autonomous AI Database.


        :param refreshable_mode: The refreshable_mode of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["AUTOMATIC", "MANUAL"]
        if not value_allowed_none_or_none_sentinel(refreshable_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `refreshable_mode`, must be None or one of {allowed_values}"
            )
        self._refreshable_mode = refreshable_mode

    @property
    def is_local_data_guard_enabled(self):
        """
        Gets the is_local_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates whether the Autonomous AI Database has a local (in-region) standby database. Not applicable when creating a cross-region Autonomous Data Guard associations, or to
        Autonomous AI Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.

        To create a local standby, set to `TRUE`. To delete a local standby, set to `FALSE`. For more information on using Autonomous Data Guard on an Autonomous AI Database Serverless instance (local and cross-region) , see `About Standby Databases`__

        To enable cross-region Autonomous Data Guard on an Autonomous AI Database Serverless instance, see `Enable Autonomous Data Guard`__.

        This cannot be updated in parallel with any of the following: isMTLSRequired, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-about.html#GUID-045AD017-8120-4BDC-AF58-7430FFE28D2B
        __ https://docs-uat.us.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-update-type.html#GUID-967ED737-4A05-4D6E-A7CA-C3F21ACF9BF0


        :return: The is_local_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_local_data_guard_enabled

    @is_local_data_guard_enabled.setter
    def is_local_data_guard_enabled(self, is_local_data_guard_enabled):
        """
        Sets the is_local_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates whether the Autonomous AI Database has a local (in-region) standby database. Not applicable when creating a cross-region Autonomous Data Guard associations, or to
        Autonomous AI Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.

        To create a local standby, set to `TRUE`. To delete a local standby, set to `FALSE`. For more information on using Autonomous Data Guard on an Autonomous AI Database Serverless instance (local and cross-region) , see `About Standby Databases`__

        To enable cross-region Autonomous Data Guard on an Autonomous AI Database Serverless instance, see `Enable Autonomous Data Guard`__.

        This cannot be updated in parallel with any of the following: isMTLSRequired, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-about.html#GUID-045AD017-8120-4BDC-AF58-7430FFE28D2B
        __ https://docs-uat.us.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-update-type.html#GUID-967ED737-4A05-4D6E-A7CA-C3F21ACF9BF0


        :param is_local_data_guard_enabled: The is_local_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_local_data_guard_enabled = is_local_data_guard_enabled

    @property
    def is_data_guard_enabled(self):
        """
        Gets the is_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        ** Deprecated. ** Indicates whether the Autonomous AI Database has a local (in-region) standby database. Not applicable when creating a cross-region Autonomous Data Guard associations, or to
        Autonomous AI Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.

        To create a local standby, set to `TRUE`. To delete a local standby, set to `FALSE`. For more information on using Autonomous Data Guard on an Autonomous AI Database Serverless instance (local and cross-region) , see `About Standby Databases`__

        To enable cross-region Autonomous Data Guard on an Autonomous AI Database Serverless instance, see `Enable Autonomous Data Guard`__.

        To delete a cross-region standby database, provide the `peerDbId` for the standby database in a remote region, and set `isDataGuardEnabled` to `FALSE`.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-about.html#GUID-045AD017-8120-4BDC-AF58-7430FFE28D2B
        __ https://docs-uat.us.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-update-type.html#GUID-967ED737-4A05-4D6E-A7CA-C3F21ACF9BF0


        :return: The is_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_data_guard_enabled

    @is_data_guard_enabled.setter
    def is_data_guard_enabled(self, is_data_guard_enabled):
        """
        Sets the is_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        ** Deprecated. ** Indicates whether the Autonomous AI Database has a local (in-region) standby database. Not applicable when creating a cross-region Autonomous Data Guard associations, or to
        Autonomous AI Databases using dedicated Exadata infrastructure or Exadata Cloud@Customer infrastructure.

        To create a local standby, set to `TRUE`. To delete a local standby, set to `FALSE`. For more information on using Autonomous Data Guard on an Autonomous AI Database Serverless instance (local and cross-region) , see `About Standby Databases`__

        To enable cross-region Autonomous Data Guard on an Autonomous AI Database Serverless instance, see `Enable Autonomous Data Guard`__.

        To delete a cross-region standby database, provide the `peerDbId` for the standby database in a remote region, and set `isDataGuardEnabled` to `FALSE`.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-about.html#GUID-045AD017-8120-4BDC-AF58-7430FFE28D2B
        __ https://docs-uat.us.oracle.com/en/cloud/paas/autonomous-database/adbsa/autonomous-data-guard-update-type.html#GUID-967ED737-4A05-4D6E-A7CA-C3F21ACF9BF0


        :param is_data_guard_enabled: The is_data_guard_enabled of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_data_guard_enabled = is_data_guard_enabled

    @property
    def peer_db_id(self):
        """
        Gets the peer_db_id of this UpdateAutonomousDatabaseDetails.
        The database OCID(/Content/General/Concepts/identifiers.htm) of the Disaster Recovery peer (source Primary) database, which is located in a different (remote) region from the current peer database.

        To create or delete a local (in-region) standby, see the `isDataGuardEnabled` parameter.


        :return: The peer_db_id of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._peer_db_id

    @peer_db_id.setter
    def peer_db_id(self, peer_db_id):
        """
        Sets the peer_db_id of this UpdateAutonomousDatabaseDetails.
        The database OCID(/Content/General/Concepts/identifiers.htm) of the Disaster Recovery peer (source Primary) database, which is located in a different (remote) region from the current peer database.

        To create or delete a local (in-region) standby, see the `isDataGuardEnabled` parameter.


        :param peer_db_id: The peer_db_id of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._peer_db_id = peer_db_id

    @property
    def db_version(self):
        """
        Gets the db_version of this UpdateAutonomousDatabaseDetails.
        A valid Oracle AI Database version for Autonomous AI Database.


        :return: The db_version of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this UpdateAutonomousDatabaseDetails.
        A valid Oracle AI Database version for Autonomous AI Database.


        :param db_version: The db_version of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._db_version = db_version

    @property
    def open_mode(self):
        """
        Gets the open_mode of this UpdateAutonomousDatabaseDetails.
        Indicates the Autonomous AI Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        Allowed values for this property are: "READ_ONLY", "READ_WRITE"


        :return: The open_mode of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._open_mode

    @open_mode.setter
    def open_mode(self, open_mode):
        """
        Sets the open_mode of this UpdateAutonomousDatabaseDetails.
        Indicates the Autonomous AI Database mode. The database can be opened in `READ_ONLY` or `READ_WRITE` mode.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :param open_mode: The open_mode of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["READ_ONLY", "READ_WRITE"]
        if not value_allowed_none_or_none_sentinel(open_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `open_mode`, must be None or one of {allowed_values}"
            )
        self._open_mode = open_mode

    @property
    def permission_level(self):
        """
        Gets the permission_level of this UpdateAutonomousDatabaseDetails.
        The Autonomous AI Database permission level. Restricted mode allows access only by admin users.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.

        Allowed values for this property are: "RESTRICTED", "UNRESTRICTED"


        :return: The permission_level of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._permission_level

    @permission_level.setter
    def permission_level(self, permission_level):
        """
        Sets the permission_level of this UpdateAutonomousDatabaseDetails.
        The Autonomous AI Database permission level. Restricted mode allows access only by admin users.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :param permission_level: The permission_level of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["RESTRICTED", "UNRESTRICTED"]
        if not value_allowed_none_or_none_sentinel(permission_level, allowed_values):
            raise ValueError(
                f"Invalid value for `permission_level`, must be None or one of {allowed_values}"
            )
        self._permission_level = permission_level

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this UpdateAutonomousDatabaseDetails.
        The `OCID`__ of the subnet the resource is associated with.

        **Subnet Restrictions:**
        - For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        - For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
        - For Autonomous AI Database, setting this will disable public secure access to the database.

        These subnets are used by the Oracle Clusterware private interconnect on the database instance.
        Specifying an overlapping subnet will cause the private interconnect to malfunction.
        This restriction applies to both the client subnet and the backup subnet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this UpdateAutonomousDatabaseDetails.
        The `OCID`__ of the subnet the resource is associated with.

        **Subnet Restrictions:**
        - For bare metal DB systems and for single node virtual machine DB systems, do not use a subnet that overlaps with 192.168.16.16/28.
        - For Exadata and virtual machine 2-node RAC systems, do not use a subnet that overlaps with 192.168.128.0/20.
        - For Autonomous AI Database, setting this will disable public secure access to the database.

        These subnets are used by the Oracle Clusterware private interconnect on the database instance.
        Specifying an overlapping subnet will cause the private interconnect to malfunction.
        This restriction applies to both the client subnet and the backup subnet.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def private_endpoint_label(self):
        """
        Gets the private_endpoint_label of this UpdateAutonomousDatabaseDetails.
        The resource's private endpoint label.
        - Setting the endpoint label to a non-empty string creates a private endpoint database.
        - Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
        - Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.

        This setting cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :return: The private_endpoint_label of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._private_endpoint_label

    @private_endpoint_label.setter
    def private_endpoint_label(self, private_endpoint_label):
        """
        Sets the private_endpoint_label of this UpdateAutonomousDatabaseDetails.
        The resource's private endpoint label.
        - Setting the endpoint label to a non-empty string creates a private endpoint database.
        - Resetting the endpoint label to an empty string, after the creation of the private endpoint database, changes the private endpoint database to a public endpoint database.
        - Setting the endpoint label to a non-empty string value, updates to a new private endpoint database, when the database is disabled and re-enabled.

        This setting cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, dbWorkload, dbVersion, isRefreshable, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :param private_endpoint_label: The private_endpoint_label of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._private_endpoint_label = private_endpoint_label

    @property
    def private_endpoint_ip(self):
        """
        Gets the private_endpoint_ip of this UpdateAutonomousDatabaseDetails.
        The private endpoint Ip address for the resource.


        :return: The private_endpoint_ip of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._private_endpoint_ip

    @private_endpoint_ip.setter
    def private_endpoint_ip(self, private_endpoint_ip):
        """
        Sets the private_endpoint_ip of this UpdateAutonomousDatabaseDetails.
        The private endpoint Ip address for the resource.


        :param private_endpoint_ip: The private_endpoint_ip of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._private_endpoint_ip = private_endpoint_ip

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this UpdateAutonomousDatabaseDetails.
        The list of `OCIDs`__ for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see `Security Rules`__.
        **NsgIds restrictions:**
        - A network security group (NSG) is optional for Autonomous AI Databases with private access. The nsgIds list can be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The nsg_ids of this UpdateAutonomousDatabaseDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this UpdateAutonomousDatabaseDetails.
        The list of `OCIDs`__ for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see `Security Rules`__.
        **NsgIds restrictions:**
        - A network security group (NSG) is optional for Autonomous AI Databases with private access. The nsgIds list can be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param nsg_ids: The nsg_ids of this UpdateAutonomousDatabaseDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def auto_refresh_frequency_in_seconds(self):
        """
        Gets the auto_refresh_frequency_in_seconds of this UpdateAutonomousDatabaseDetails.
        The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.


        :return: The auto_refresh_frequency_in_seconds of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._auto_refresh_frequency_in_seconds

    @auto_refresh_frequency_in_seconds.setter
    def auto_refresh_frequency_in_seconds(self, auto_refresh_frequency_in_seconds):
        """
        Sets the auto_refresh_frequency_in_seconds of this UpdateAutonomousDatabaseDetails.
        The frequency a refreshable clone is refreshed after auto-refresh is enabled. The minimum is 1 hour. The maximum is 7 days. The date and time that auto-refresh is enabled is controlled by the `timeOfAutoRefreshStart` parameter.


        :param auto_refresh_frequency_in_seconds: The auto_refresh_frequency_in_seconds of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._auto_refresh_frequency_in_seconds = auto_refresh_frequency_in_seconds

    @property
    def auto_refresh_point_lag_in_seconds(self):
        """
        Gets the auto_refresh_point_lag_in_seconds of this UpdateAutonomousDatabaseDetails.
        The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.


        :return: The auto_refresh_point_lag_in_seconds of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._auto_refresh_point_lag_in_seconds

    @auto_refresh_point_lag_in_seconds.setter
    def auto_refresh_point_lag_in_seconds(self, auto_refresh_point_lag_in_seconds):
        """
        Sets the auto_refresh_point_lag_in_seconds of this UpdateAutonomousDatabaseDetails.
        The time, in seconds, the data of the refreshable clone lags the primary database at the point of refresh. The minimum is 0 minutes (0 mins means refresh to the latest available timestamp). The maximum is 7 days. The lag time increases after refreshing until the next data refresh happens.


        :param auto_refresh_point_lag_in_seconds: The auto_refresh_point_lag_in_seconds of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._auto_refresh_point_lag_in_seconds = auto_refresh_point_lag_in_seconds

    @property
    def time_of_auto_refresh_start(self):
        """
        Gets the time_of_auto_refresh_start of this UpdateAutonomousDatabaseDetails.
        The the date and time that auto-refreshing will begin for an Autonomous AI Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.


        :return: The time_of_auto_refresh_start of this UpdateAutonomousDatabaseDetails.
        :rtype: datetime
        """
        return self._time_of_auto_refresh_start

    @time_of_auto_refresh_start.setter
    def time_of_auto_refresh_start(self, time_of_auto_refresh_start):
        """
        Sets the time_of_auto_refresh_start of this UpdateAutonomousDatabaseDetails.
        The the date and time that auto-refreshing will begin for an Autonomous AI Database refreshable clone. This value controls only the start time for the first refresh operation. Subsequent (ongoing) refresh operations have start times controlled by the value of the `autoRefreshFrequencyInSeconds` parameter.


        :param time_of_auto_refresh_start: The time_of_auto_refresh_start of this UpdateAutonomousDatabaseDetails.
        :type: datetime
        """
        self._time_of_auto_refresh_start = time_of_auto_refresh_start

    @property
    def customer_contacts(self):
        """
        Gets the customer_contacts of this UpdateAutonomousDatabaseDetails.
        Customer Contacts. Setting this to an empty list removes all customer contacts of an Oracle

        This cannot be updated in parallel with any of the following: isMTLSConnectionRequired, scheduledOperations, or dbToolsDetails.


        :return: The customer_contacts of this UpdateAutonomousDatabaseDetails.
        :rtype: list[oci.database.models.CustomerContact]
        """
        return self._customer_contacts

    @customer_contacts.setter
    def customer_contacts(self, customer_contacts):
        """
        Sets the customer_contacts of this UpdateAutonomousDatabaseDetails.
        Customer Contacts. Setting this to an empty list removes all customer contacts of an Oracle

        This cannot be updated in parallel with any of the following: isMTLSConnectionRequired, scheduledOperations, or dbToolsDetails.


        :param customer_contacts: The customer_contacts of this UpdateAutonomousDatabaseDetails.
        :type: list[oci.database.models.CustomerContact]
        """
        self._customer_contacts = customer_contacts

    @property
    def is_mtls_connection_required(self):
        """
        Gets the is_mtls_connection_required of this UpdateAutonomousDatabaseDetails.
        Specifies if the Autonomous AI Database requires mTLS connections.

        This may not be updated in parallel with any of the following: licenseModel, databaseEdition, cpuCoreCount, computeCount, dataStorageSizeInTBs, whitelistedIps, openMode, permissionLevel, db-workload, privateEndpointLabel, nsgIds, customerContacts, dbVersion, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        Service Change: The default value of the isMTLSConnectionRequired attribute will change from true to false on July 1, 2023 in the following APIs:
        - CreateAutonomousDatabase
        - GetAutonomousDatabase
        - UpdateAutonomousDatabase
        Details: Prior to the July 1, 2023 change, the isMTLSConnectionRequired attribute default value was true. This applies to Autonomous AI Database Serverless.
        Does this impact me? If you use or maintain custom scripts or Terraform scripts referencing the CreateAutonomousDatabase, GetAutonomousDatabase, or UpdateAutonomousDatabase APIs, you want to check, and possibly modify, the scripts for the changed default value of the attribute. Should you choose not to leave your scripts unchanged, the API calls containing this attribute will continue to work, but the default value will switch from true to false.
        How do I make this change? Using either OCI SDKs or command line tools, update your custom scripts to explicitly set the isMTLSConnectionRequired attribute to true.


        :return: The is_mtls_connection_required of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_mtls_connection_required

    @is_mtls_connection_required.setter
    def is_mtls_connection_required(self, is_mtls_connection_required):
        """
        Sets the is_mtls_connection_required of this UpdateAutonomousDatabaseDetails.
        Specifies if the Autonomous AI Database requires mTLS connections.

        This may not be updated in parallel with any of the following: licenseModel, databaseEdition, cpuCoreCount, computeCount, dataStorageSizeInTBs, whitelistedIps, openMode, permissionLevel, db-workload, privateEndpointLabel, nsgIds, customerContacts, dbVersion, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.

        Service Change: The default value of the isMTLSConnectionRequired attribute will change from true to false on July 1, 2023 in the following APIs:
        - CreateAutonomousDatabase
        - GetAutonomousDatabase
        - UpdateAutonomousDatabase
        Details: Prior to the July 1, 2023 change, the isMTLSConnectionRequired attribute default value was true. This applies to Autonomous AI Database Serverless.
        Does this impact me? If you use or maintain custom scripts or Terraform scripts referencing the CreateAutonomousDatabase, GetAutonomousDatabase, or UpdateAutonomousDatabase APIs, you want to check, and possibly modify, the scripts for the changed default value of the attribute. Should you choose not to leave your scripts unchanged, the API calls containing this attribute will continue to work, but the default value will switch from true to false.
        How do I make this change? Using either OCI SDKs or command line tools, update your custom scripts to explicitly set the isMTLSConnectionRequired attribute to true.


        :param is_mtls_connection_required: The is_mtls_connection_required of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_mtls_connection_required = is_mtls_connection_required

    @property
    def resource_pool_leader_id(self):
        """
        Gets the resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        The unique identifier for leader Autonomous AI Database OCID `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._resource_pool_leader_id

    @resource_pool_leader_id.setter
    def resource_pool_leader_id(self, resource_pool_leader_id):
        """
        Sets the resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        The unique identifier for leader Autonomous AI Database OCID `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_pool_leader_id: The resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._resource_pool_leader_id = resource_pool_leader_id

    @property
    def resource_pool_summary(self):
        """
        Gets the resource_pool_summary of this UpdateAutonomousDatabaseDetails.

        :return: The resource_pool_summary of this UpdateAutonomousDatabaseDetails.
        :rtype: oci.database.models.ResourcePoolSummary
        """
        return self._resource_pool_summary

    @resource_pool_summary.setter
    def resource_pool_summary(self, resource_pool_summary):
        """
        Sets the resource_pool_summary of this UpdateAutonomousDatabaseDetails.

        :param resource_pool_summary: The resource_pool_summary of this UpdateAutonomousDatabaseDetails.
        :type: oci.database.models.ResourcePoolSummary
        """
        self._resource_pool_summary = resource_pool_summary

    @property
    def autonomous_maintenance_schedule_type(self):
        """
        Gets the autonomous_maintenance_schedule_type of this UpdateAutonomousDatabaseDetails.
        The maintenance schedule type of the Autonomous AI Database Serverless. An EARLY maintenance schedule
        follows a schedule applying patches prior to the REGULAR schedule. A REGULAR maintenance schedule follows the normal cycle

        Allowed values for this property are: "EARLY", "REGULAR"


        :return: The autonomous_maintenance_schedule_type of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._autonomous_maintenance_schedule_type

    @autonomous_maintenance_schedule_type.setter
    def autonomous_maintenance_schedule_type(self, autonomous_maintenance_schedule_type):
        """
        Sets the autonomous_maintenance_schedule_type of this UpdateAutonomousDatabaseDetails.
        The maintenance schedule type of the Autonomous AI Database Serverless. An EARLY maintenance schedule
        follows a schedule applying patches prior to the REGULAR schedule. A REGULAR maintenance schedule follows the normal cycle


        :param autonomous_maintenance_schedule_type: The autonomous_maintenance_schedule_type of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        allowed_values = ["EARLY", "REGULAR"]
        if not value_allowed_none_or_none_sentinel(autonomous_maintenance_schedule_type, allowed_values):
            raise ValueError(
                f"Invalid value for `autonomous_maintenance_schedule_type`, must be None or one of {allowed_values}"
            )
        self._autonomous_maintenance_schedule_type = autonomous_maintenance_schedule_type

    @property
    def autonomous_database_maintenance_window(self):
        """
        Gets the autonomous_database_maintenance_window of this UpdateAutonomousDatabaseDetails.

        :return: The autonomous_database_maintenance_window of this UpdateAutonomousDatabaseDetails.
        :rtype: oci.database.models.AutonomousDatabaseMaintenanceWindowSummary
        """
        return self._autonomous_database_maintenance_window

    @autonomous_database_maintenance_window.setter
    def autonomous_database_maintenance_window(self, autonomous_database_maintenance_window):
        """
        Sets the autonomous_database_maintenance_window of this UpdateAutonomousDatabaseDetails.

        :param autonomous_database_maintenance_window: The autonomous_database_maintenance_window of this UpdateAutonomousDatabaseDetails.
        :type: oci.database.models.AutonomousDatabaseMaintenanceWindowSummary
        """
        self._autonomous_database_maintenance_window = autonomous_database_maintenance_window

    @property
    def time_maintenance_pause_until(self):
        """
        Gets the time_maintenance_pause_until of this UpdateAutonomousDatabaseDetails.
        The date until which maintenance of Autonomous AI Database is temporarily paused.


        :return: The time_maintenance_pause_until of this UpdateAutonomousDatabaseDetails.
        :rtype: datetime
        """
        return self._time_maintenance_pause_until

    @time_maintenance_pause_until.setter
    def time_maintenance_pause_until(self, time_maintenance_pause_until):
        """
        Sets the time_maintenance_pause_until of this UpdateAutonomousDatabaseDetails.
        The date until which maintenance of Autonomous AI Database is temporarily paused.


        :param time_maintenance_pause_until: The time_maintenance_pause_until of this UpdateAutonomousDatabaseDetails.
        :type: datetime
        """
        self._time_maintenance_pause_until = time_maintenance_pause_until

    @property
    def is_backup_retention_locked(self):
        """
        Gets the is_backup_retention_locked of this UpdateAutonomousDatabaseDetails.
        True if the Autonomous AI Database is backup retention locked.


        :return: The is_backup_retention_locked of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_backup_retention_locked

    @is_backup_retention_locked.setter
    def is_backup_retention_locked(self, is_backup_retention_locked):
        """
        Sets the is_backup_retention_locked of this UpdateAutonomousDatabaseDetails.
        True if the Autonomous AI Database is backup retention locked.


        :param is_backup_retention_locked: The is_backup_retention_locked of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_backup_retention_locked = is_backup_retention_locked

    @property
    def time_scheduled_db_version_upgrade(self):
        """
        Gets the time_scheduled_db_version_upgrade of this UpdateAutonomousDatabaseDetails.
        The date and time the Autonomous AI Database scheduled to upgrade to 26ai.


        :return: The time_scheduled_db_version_upgrade of this UpdateAutonomousDatabaseDetails.
        :rtype: datetime
        """
        return self._time_scheduled_db_version_upgrade

    @time_scheduled_db_version_upgrade.setter
    def time_scheduled_db_version_upgrade(self, time_scheduled_db_version_upgrade):
        """
        Sets the time_scheduled_db_version_upgrade of this UpdateAutonomousDatabaseDetails.
        The date and time the Autonomous AI Database scheduled to upgrade to 26ai.


        :param time_scheduled_db_version_upgrade: The time_scheduled_db_version_upgrade of this UpdateAutonomousDatabaseDetails.
        :type: datetime
        """
        self._time_scheduled_db_version_upgrade = time_scheduled_db_version_upgrade

    @property
    def is_disable_db_version_upgrade_schedule(self):
        """
        Gets the is_disable_db_version_upgrade_schedule of this UpdateAutonomousDatabaseDetails.
        True if user wants to disable Autonomous AI Database scheduled upgrade to 26ai.


        :return: The is_disable_db_version_upgrade_schedule of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_disable_db_version_upgrade_schedule

    @is_disable_db_version_upgrade_schedule.setter
    def is_disable_db_version_upgrade_schedule(self, is_disable_db_version_upgrade_schedule):
        """
        Sets the is_disable_db_version_upgrade_schedule of this UpdateAutonomousDatabaseDetails.
        True if user wants to disable Autonomous AI Database scheduled upgrade to 26ai.


        :param is_disable_db_version_upgrade_schedule: The is_disable_db_version_upgrade_schedule of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_disable_db_version_upgrade_schedule = is_disable_db_version_upgrade_schedule

    @property
    def is_schedule_db_version_upgrade_to_earliest(self):
        """
        Gets the is_schedule_db_version_upgrade_to_earliest of this UpdateAutonomousDatabaseDetails.
        True if user wants to schedule Autonomous AI Database upgrade to the earliest available time.


        :return: The is_schedule_db_version_upgrade_to_earliest of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_schedule_db_version_upgrade_to_earliest

    @is_schedule_db_version_upgrade_to_earliest.setter
    def is_schedule_db_version_upgrade_to_earliest(self, is_schedule_db_version_upgrade_to_earliest):
        """
        Sets the is_schedule_db_version_upgrade_to_earliest of this UpdateAutonomousDatabaseDetails.
        True if user wants to schedule Autonomous AI Database upgrade to the earliest available time.


        :param is_schedule_db_version_upgrade_to_earliest: The is_schedule_db_version_upgrade_to_earliest of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_schedule_db_version_upgrade_to_earliest = is_schedule_db_version_upgrade_to_earliest

    @property
    def scheduled_operations(self):
        """
        Gets the scheduled_operations of this UpdateAutonomousDatabaseDetails.
        The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.


        :return: The scheduled_operations of this UpdateAutonomousDatabaseDetails.
        :rtype: list[oci.database.models.ScheduledOperationDetails]
        """
        return self._scheduled_operations

    @scheduled_operations.setter
    def scheduled_operations(self, scheduled_operations):
        """
        Sets the scheduled_operations of this UpdateAutonomousDatabaseDetails.
        The list of scheduled operations. Consists of values such as dayOfWeek, scheduledStartTime, scheduledStopTime.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.


        :param scheduled_operations: The scheduled_operations of this UpdateAutonomousDatabaseDetails.
        :type: list[oci.database.models.ScheduledOperationDetails]
        """
        self._scheduled_operations = scheduled_operations

    @property
    def is_auto_scaling_for_storage_enabled(self):
        """
        Gets the is_auto_scaling_for_storage_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates if auto scaling is enabled for the Autonomous AI Database storage. The default value is `FALSE`.


        :return: The is_auto_scaling_for_storage_enabled of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_auto_scaling_for_storage_enabled

    @is_auto_scaling_for_storage_enabled.setter
    def is_auto_scaling_for_storage_enabled(self, is_auto_scaling_for_storage_enabled):
        """
        Sets the is_auto_scaling_for_storage_enabled of this UpdateAutonomousDatabaseDetails.
        Indicates if auto scaling is enabled for the Autonomous AI Database storage. The default value is `FALSE`.


        :param is_auto_scaling_for_storage_enabled: The is_auto_scaling_for_storage_enabled of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_auto_scaling_for_storage_enabled = is_auto_scaling_for_storage_enabled

    @property
    def database_edition(self):
        """
        Gets the database_edition of this UpdateAutonomousDatabaseDetails.
        The Oracle AI Database Edition that applies to the Autonomous AI Databases. This parameter accepts options `STANDARD_EDITION` and `ENTERPRISE_EDITION`.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :return: The database_edition of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._database_edition

    @database_edition.setter
    def database_edition(self, database_edition):
        """
        Sets the database_edition of this UpdateAutonomousDatabaseDetails.
        The Oracle AI Database Edition that applies to the Autonomous AI Databases. This parameter accepts options `STANDARD_EDITION` and `ENTERPRISE_EDITION`.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.


        :param database_edition: The database_edition of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._database_edition = database_edition

    @property
    def db_tools_details(self):
        """
        Gets the db_tools_details of this UpdateAutonomousDatabaseDetails.
        The list of database tools details.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.


        :return: The db_tools_details of this UpdateAutonomousDatabaseDetails.
        :rtype: list[oci.database.models.DatabaseTool]
        """
        return self._db_tools_details

    @db_tools_details.setter
    def db_tools_details(self, db_tools_details):
        """
        Sets the db_tools_details of this UpdateAutonomousDatabaseDetails.
        The list of database tools details.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, isRefreshable, dbName, scheduledOperations, isLocalDataGuardEnabled, or isFreeTier.


        :param db_tools_details: The db_tools_details of this UpdateAutonomousDatabaseDetails.
        :type: list[oci.database.models.DatabaseTool]
        """
        self._db_tools_details = db_tools_details

    @property
    def vanity_url_details(self):
        """
        Gets the vanity_url_details of this UpdateAutonomousDatabaseDetails.

        :return: The vanity_url_details of this UpdateAutonomousDatabaseDetails.
        :rtype: oci.database.models.VanityUrlDetails
        """
        return self._vanity_url_details

    @vanity_url_details.setter
    def vanity_url_details(self, vanity_url_details):
        """
        Sets the vanity_url_details of this UpdateAutonomousDatabaseDetails.

        :param vanity_url_details: The vanity_url_details of this UpdateAutonomousDatabaseDetails.
        :type: oci.database.models.VanityUrlDetails
        """
        self._vanity_url_details = vanity_url_details

    @property
    def secret_id(self):
        """
        Gets the secret_id of this UpdateAutonomousDatabaseDetails.
        The OCI vault secret [/Content/General/Concepts/identifiers.htm]OCID. This cannot be used in conjunction with adminPassword.


        :return: The secret_id of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this UpdateAutonomousDatabaseDetails.
        The OCI vault secret [/Content/General/Concepts/identifiers.htm]OCID. This cannot be used in conjunction with adminPassword.


        :param secret_id: The secret_id of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._secret_id = secret_id

    @property
    def secret_version_number(self):
        """
        Gets the secret_version_number of this UpdateAutonomousDatabaseDetails.
        The version of the vault secret. If no version is specified, the latest version will be used.


        :return: The secret_version_number of this UpdateAutonomousDatabaseDetails.
        :rtype: int
        """
        return self._secret_version_number

    @secret_version_number.setter
    def secret_version_number(self, secret_version_number):
        """
        Sets the secret_version_number of this UpdateAutonomousDatabaseDetails.
        The version of the vault secret. If no version is specified, the latest version will be used.


        :param secret_version_number: The secret_version_number of this UpdateAutonomousDatabaseDetails.
        :type: int
        """
        self._secret_version_number = secret_version_number

    @property
    def encryption_key(self):
        """
        Gets the encryption_key of this UpdateAutonomousDatabaseDetails.

        :return: The encryption_key of this UpdateAutonomousDatabaseDetails.
        :rtype: oci.database.models.AutonomousDatabaseEncryptionKeyDetails
        """
        return self._encryption_key

    @encryption_key.setter
    def encryption_key(self, encryption_key):
        """
        Sets the encryption_key of this UpdateAutonomousDatabaseDetails.

        :param encryption_key: The encryption_key of this UpdateAutonomousDatabaseDetails.
        :type: oci.database.models.AutonomousDatabaseEncryptionKeyDetails
        """
        self._encryption_key = encryption_key

    @property
    def is_disconnect_peer(self):
        """
        Gets the is_disconnect_peer of this UpdateAutonomousDatabaseDetails.
        If true, this will disconnect the Autonomous AI Database from its peer and the Autonomous AI Database can work permanently as a standalone database.

        To disconnect a cross region standby, please also provide the OCID of the standby database in the `peerDbId` parameter.


        :return: The is_disconnect_peer of this UpdateAutonomousDatabaseDetails.
        :rtype: bool
        """
        return self._is_disconnect_peer

    @is_disconnect_peer.setter
    def is_disconnect_peer(self, is_disconnect_peer):
        """
        Sets the is_disconnect_peer of this UpdateAutonomousDatabaseDetails.
        If true, this will disconnect the Autonomous AI Database from its peer and the Autonomous AI Database can work permanently as a standalone database.

        To disconnect a cross region standby, please also provide the OCID of the standby database in the `peerDbId` parameter.


        :param is_disconnect_peer: The is_disconnect_peer of this UpdateAutonomousDatabaseDetails.
        :type: bool
        """
        self._is_disconnect_peer = is_disconnect_peer

    @property
    def local_adg_resource_pool_leader_id(self):
        """
        Gets the local_adg_resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        The `OCID`__ of a dedicated resource pool leader Autonomous AI Database in the same region, that is required when local Autonomous Data Guard is enabled for a dedicated resource pool member using the parameter `isLocalDataGuardEnabled`.
        This field applies only to dedicated resource pool members, and the specified leader must be different from the primary\u2019s leader.
        Local Autonomous Data Guard can be enabled only if more than one dedicated resource pool exists in the region.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The local_adg_resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        :rtype: str
        """
        return self._local_adg_resource_pool_leader_id

    @local_adg_resource_pool_leader_id.setter
    def local_adg_resource_pool_leader_id(self, local_adg_resource_pool_leader_id):
        """
        Sets the local_adg_resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        The `OCID`__ of a dedicated resource pool leader Autonomous AI Database in the same region, that is required when local Autonomous Data Guard is enabled for a dedicated resource pool member using the parameter `isLocalDataGuardEnabled`.
        This field applies only to dedicated resource pool members, and the specified leader must be different from the primary\u2019s leader.
        Local Autonomous Data Guard can be enabled only if more than one dedicated resource pool exists in the region.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param local_adg_resource_pool_leader_id: The local_adg_resource_pool_leader_id of this UpdateAutonomousDatabaseDetails.
        :type: str
        """
        self._local_adg_resource_pool_leader_id = local_adg_resource_pool_leader_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
