# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateExascaleDbStorageVaultDetails(object):
    """
    Details for updating the Exadata Database Storage Vault.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateExascaleDbStorageVaultDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateExascaleDbStorageVaultDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateExascaleDbStorageVaultDetails.
        :type description: str

        :param high_capacity_database_storage:
            The value to assign to the high_capacity_database_storage property of this UpdateExascaleDbStorageVaultDetails.
        :type high_capacity_database_storage: oci.database.models.ExascaleDbStorageInputDetails

        :param additional_flash_cache_in_percent:
            The value to assign to the additional_flash_cache_in_percent property of this UpdateExascaleDbStorageVaultDetails.
        :type additional_flash_cache_in_percent: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateExascaleDbStorageVaultDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateExascaleDbStorageVaultDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param is_autoscale_enabled:
            The value to assign to the is_autoscale_enabled property of this UpdateExascaleDbStorageVaultDetails.
        :type is_autoscale_enabled: bool

        :param autoscale_limit_in_gbs:
            The value to assign to the autoscale_limit_in_gbs property of this UpdateExascaleDbStorageVaultDetails.
        :type autoscale_limit_in_gbs: int

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'high_capacity_database_storage': 'ExascaleDbStorageInputDetails',
            'additional_flash_cache_in_percent': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'is_autoscale_enabled': 'bool',
            'autoscale_limit_in_gbs': 'int'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'high_capacity_database_storage': 'highCapacityDatabaseStorage',
            'additional_flash_cache_in_percent': 'additionalFlashCacheInPercent',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'is_autoscale_enabled': 'isAutoscaleEnabled',
            'autoscale_limit_in_gbs': 'autoscaleLimitInGBs'
        }
        self._display_name = None
        self._description = None
        self._high_capacity_database_storage = None
        self._additional_flash_cache_in_percent = None
        self._freeform_tags = None
        self._defined_tags = None
        self._is_autoscale_enabled = None
        self._autoscale_limit_in_gbs = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateExascaleDbStorageVaultDetails.
        The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.


        :return: The display_name of this UpdateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateExascaleDbStorageVaultDetails.
        The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.


        :param display_name: The display_name of this UpdateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateExascaleDbStorageVaultDetails.
        Exadata Database Storage Vault description.


        :return: The description of this UpdateExascaleDbStorageVaultDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateExascaleDbStorageVaultDetails.
        Exadata Database Storage Vault description.


        :param description: The description of this UpdateExascaleDbStorageVaultDetails.
        :type: str
        """
        self._description = description

    @property
    def high_capacity_database_storage(self):
        """
        Gets the high_capacity_database_storage of this UpdateExascaleDbStorageVaultDetails.

        :return: The high_capacity_database_storage of this UpdateExascaleDbStorageVaultDetails.
        :rtype: oci.database.models.ExascaleDbStorageInputDetails
        """
        return self._high_capacity_database_storage

    @high_capacity_database_storage.setter
    def high_capacity_database_storage(self, high_capacity_database_storage):
        """
        Sets the high_capacity_database_storage of this UpdateExascaleDbStorageVaultDetails.

        :param high_capacity_database_storage: The high_capacity_database_storage of this UpdateExascaleDbStorageVaultDetails.
        :type: oci.database.models.ExascaleDbStorageInputDetails
        """
        self._high_capacity_database_storage = high_capacity_database_storage

    @property
    def additional_flash_cache_in_percent(self):
        """
        Gets the additional_flash_cache_in_percent of this UpdateExascaleDbStorageVaultDetails.
        The size of additional Flash Cache in percentage of High Capacity database storage.


        :return: The additional_flash_cache_in_percent of this UpdateExascaleDbStorageVaultDetails.
        :rtype: int
        """
        return self._additional_flash_cache_in_percent

    @additional_flash_cache_in_percent.setter
    def additional_flash_cache_in_percent(self, additional_flash_cache_in_percent):
        """
        Sets the additional_flash_cache_in_percent of this UpdateExascaleDbStorageVaultDetails.
        The size of additional Flash Cache in percentage of High Capacity database storage.


        :param additional_flash_cache_in_percent: The additional_flash_cache_in_percent of this UpdateExascaleDbStorageVaultDetails.
        :type: int
        """
        self._additional_flash_cache_in_percent = additional_flash_cache_in_percent

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateExascaleDbStorageVaultDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateExascaleDbStorageVaultDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateExascaleDbStorageVaultDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateExascaleDbStorageVaultDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateExascaleDbStorageVaultDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateExascaleDbStorageVaultDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateExascaleDbStorageVaultDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateExascaleDbStorageVaultDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def is_autoscale_enabled(self):
        """
        Gets the is_autoscale_enabled of this UpdateExascaleDbStorageVaultDetails.
        Indicates if autoscale feature is enabled for the Database Storage Vault. The default value is `FALSE`.


        :return: The is_autoscale_enabled of this UpdateExascaleDbStorageVaultDetails.
        :rtype: bool
        """
        return self._is_autoscale_enabled

    @is_autoscale_enabled.setter
    def is_autoscale_enabled(self, is_autoscale_enabled):
        """
        Sets the is_autoscale_enabled of this UpdateExascaleDbStorageVaultDetails.
        Indicates if autoscale feature is enabled for the Database Storage Vault. The default value is `FALSE`.


        :param is_autoscale_enabled: The is_autoscale_enabled of this UpdateExascaleDbStorageVaultDetails.
        :type: bool
        """
        self._is_autoscale_enabled = is_autoscale_enabled

    @property
    def autoscale_limit_in_gbs(self):
        """
        Gets the autoscale_limit_in_gbs of this UpdateExascaleDbStorageVaultDetails.
        Maximum limit storage size in gigabytes, that is applicable for the Database Storage Vault.


        :return: The autoscale_limit_in_gbs of this UpdateExascaleDbStorageVaultDetails.
        :rtype: int
        """
        return self._autoscale_limit_in_gbs

    @autoscale_limit_in_gbs.setter
    def autoscale_limit_in_gbs(self, autoscale_limit_in_gbs):
        """
        Sets the autoscale_limit_in_gbs of this UpdateExascaleDbStorageVaultDetails.
        Maximum limit storage size in gigabytes, that is applicable for the Database Storage Vault.


        :param autoscale_limit_in_gbs: The autoscale_limit_in_gbs of this UpdateExascaleDbStorageVaultDetails.
        :type: int
        """
        self._autoscale_limit_in_gbs = autoscale_limit_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
