# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DiscoveredCloudDbSystemComponent(object):
    """
    The details of a cloud DB system component.
    """

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "ASM"
    COMPONENT_TYPE_ASM = "ASM"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "ASM_INSTANCE"
    COMPONENT_TYPE_ASM_INSTANCE = "ASM_INSTANCE"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "CLUSTER"
    COMPONENT_TYPE_CLUSTER = "CLUSTER"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "CLUSTER_INSTANCE"
    COMPONENT_TYPE_CLUSTER_INSTANCE = "CLUSTER_INSTANCE"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "DATABASE"
    COMPONENT_TYPE_DATABASE = "DATABASE"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "DATABASE_INSTANCE"
    COMPONENT_TYPE_DATABASE_INSTANCE = "DATABASE_INSTANCE"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "DATABASE_HOME"
    COMPONENT_TYPE_DATABASE_HOME = "DATABASE_HOME"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "DATABASE_NODE"
    COMPONENT_TYPE_DATABASE_NODE = "DATABASE_NODE"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "DBSYSTEM"
    COMPONENT_TYPE_DBSYSTEM = "DBSYSTEM"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "LISTENER"
    COMPONENT_TYPE_LISTENER = "LISTENER"

    #: A constant which can be used with the component_type property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "PLUGGABLE_DATABASE"
    COMPONENT_TYPE_PLUGGABLE_DATABASE = "PLUGGABLE_DATABASE"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "NEW"
    STATUS_NEW = "NEW"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "EXISTING"
    STATUS_EXISTING = "EXISTING"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "EXISTING_BASIC"
    STATUS_EXISTING_BASIC = "EXISTING_BASIC"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "EXISTING_PE"
    STATUS_EXISTING_PE = "EXISTING_PE"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "EXISTING_BASIC_PE"
    STATUS_EXISTING_BASIC_PE = "EXISTING_BASIC_PE"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "MARKED_FOR_UPGRADE"
    STATUS_MARKED_FOR_UPGRADE = "MARKED_FOR_UPGRADE"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "MARKED_FOR_MIGRATION"
    STATUS_MARKED_FOR_MIGRATION = "MARKED_FOR_MIGRATION"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "MARKED_FOR_UPGRADE_MIGRATION"
    STATUS_MARKED_FOR_UPGRADE_MIGRATION = "MARKED_FOR_UPGRADE_MIGRATION"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "MARKED_FOR_DELETION"
    STATUS_MARKED_FOR_DELETION = "MARKED_FOR_DELETION"

    #: A constant which can be used with the status property of a DiscoveredCloudDbSystemComponent.
    #: This constant has a value of "UNKNOWN"
    STATUS_UNKNOWN = "UNKNOWN"

    def __init__(self, **kwargs):
        """
        Initializes a new DiscoveredCloudDbSystemComponent object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_management.models.DiscoveredCloudClusterInstance`
        * :class:`~oci.database_management.models.DiscoveredCloudPluggableDatabase`
        * :class:`~oci.database_management.models.DiscoveredCloudCluster`
        * :class:`~oci.database_management.models.DiscoveredCloudAsm`
        * :class:`~oci.database_management.models.DiscoveredCloudListener`
        * :class:`~oci.database_management.models.DiscoveredCloudDbInstance`
        * :class:`~oci.database_management.models.DiscoveredCloudDatabase`
        * :class:`~oci.database_management.models.DiscoveredCloudDbHome`
        * :class:`~oci.database_management.models.DiscoveredCloudDbNode`
        * :class:`~oci.database_management.models.DiscoveredCloudAsmInstance`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param component_id:
            The value to assign to the component_id property of this DiscoveredCloudDbSystemComponent.
        :type component_id: str

        :param display_name:
            The value to assign to the display_name property of this DiscoveredCloudDbSystemComponent.
        :type display_name: str

        :param component_name:
            The value to assign to the component_name property of this DiscoveredCloudDbSystemComponent.
        :type component_name: str

        :param component_type:
            The value to assign to the component_type property of this DiscoveredCloudDbSystemComponent.
            Allowed values for this property are: "ASM", "ASM_INSTANCE", "CLUSTER", "CLUSTER_INSTANCE", "DATABASE", "DATABASE_INSTANCE", "DATABASE_HOME", "DATABASE_NODE", "DBSYSTEM", "LISTENER", "PLUGGABLE_DATABASE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type component_type: str

        :param resource_id:
            The value to assign to the resource_id property of this DiscoveredCloudDbSystemComponent.
        :type resource_id: str

        :param dbaas_id:
            The value to assign to the dbaas_id property of this DiscoveredCloudDbSystemComponent.
        :type dbaas_id: str

        :param is_selected_for_monitoring:
            The value to assign to the is_selected_for_monitoring property of this DiscoveredCloudDbSystemComponent.
        :type is_selected_for_monitoring: bool

        :param status:
            The value to assign to the status property of this DiscoveredCloudDbSystemComponent.
            Allowed values for this property are: "NEW", "EXISTING", "EXISTING_BASIC", "EXISTING_PE", "EXISTING_BASIC_PE", "MARKED_FOR_UPGRADE", "MARKED_FOR_MIGRATION", "MARKED_FOR_UPGRADE_MIGRATION", "MARKED_FOR_DELETION", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param associated_components:
            The value to assign to the associated_components property of this DiscoveredCloudDbSystemComponent.
        :type associated_components: list[oci.database_management.models.AssociatedCloudComponent]

        """
        self.swagger_types = {
            'component_id': 'str',
            'display_name': 'str',
            'component_name': 'str',
            'component_type': 'str',
            'resource_id': 'str',
            'dbaas_id': 'str',
            'is_selected_for_monitoring': 'bool',
            'status': 'str',
            'associated_components': 'list[AssociatedCloudComponent]'
        }
        self.attribute_map = {
            'component_id': 'componentId',
            'display_name': 'displayName',
            'component_name': 'componentName',
            'component_type': 'componentType',
            'resource_id': 'resourceId',
            'dbaas_id': 'dbaasId',
            'is_selected_for_monitoring': 'isSelectedForMonitoring',
            'status': 'status',
            'associated_components': 'associatedComponents'
        }
        self._component_id = None
        self._display_name = None
        self._component_name = None
        self._component_type = None
        self._resource_id = None
        self._dbaas_id = None
        self._is_selected_for_monitoring = None
        self._status = None
        self._associated_components = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['componentType']

        if type == 'CLUSTER_INSTANCE':
            return 'DiscoveredCloudClusterInstance'

        if type == 'PLUGGABLE_DATABASE':
            return 'DiscoveredCloudPluggableDatabase'

        if type == 'CLUSTER':
            return 'DiscoveredCloudCluster'

        if type == 'ASM':
            return 'DiscoveredCloudAsm'

        if type == 'LISTENER':
            return 'DiscoveredCloudListener'

        if type == 'DATABASE_INSTANCE':
            return 'DiscoveredCloudDbInstance'

        if type == 'DATABASE':
            return 'DiscoveredCloudDatabase'

        if type == 'DATABASE_HOME':
            return 'DiscoveredCloudDbHome'

        if type == 'DATABASE_NODE':
            return 'DiscoveredCloudDbNode'

        if type == 'ASM_INSTANCE':
            return 'DiscoveredCloudAsmInstance'
        else:
            return 'DiscoveredCloudDbSystemComponent'

    @property
    def component_id(self):
        """
        **[Required]** Gets the component_id of this DiscoveredCloudDbSystemComponent.
        The identifier of the discovered DB system component.


        :return: The component_id of this DiscoveredCloudDbSystemComponent.
        :rtype: str
        """
        return self._component_id

    @component_id.setter
    def component_id(self, component_id):
        """
        Sets the component_id of this DiscoveredCloudDbSystemComponent.
        The identifier of the discovered DB system component.


        :param component_id: The component_id of this DiscoveredCloudDbSystemComponent.
        :type: str
        """
        self._component_id = component_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DiscoveredCloudDbSystemComponent.
        The user-friendly name for the discovered DB system component. The name does not have to be unique.


        :return: The display_name of this DiscoveredCloudDbSystemComponent.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DiscoveredCloudDbSystemComponent.
        The user-friendly name for the discovered DB system component. The name does not have to be unique.


        :param display_name: The display_name of this DiscoveredCloudDbSystemComponent.
        :type: str
        """
        self._display_name = display_name

    @property
    def component_name(self):
        """
        **[Required]** Gets the component_name of this DiscoveredCloudDbSystemComponent.
        The name of the discovered DB system component.


        :return: The component_name of this DiscoveredCloudDbSystemComponent.
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name):
        """
        Sets the component_name of this DiscoveredCloudDbSystemComponent.
        The name of the discovered DB system component.


        :param component_name: The component_name of this DiscoveredCloudDbSystemComponent.
        :type: str
        """
        self._component_name = component_name

    @property
    def component_type(self):
        """
        **[Required]** Gets the component_type of this DiscoveredCloudDbSystemComponent.
        The cloud DB system component type.

        Allowed values for this property are: "ASM", "ASM_INSTANCE", "CLUSTER", "CLUSTER_INSTANCE", "DATABASE", "DATABASE_INSTANCE", "DATABASE_HOME", "DATABASE_NODE", "DBSYSTEM", "LISTENER", "PLUGGABLE_DATABASE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The component_type of this DiscoveredCloudDbSystemComponent.
        :rtype: str
        """
        return self._component_type

    @component_type.setter
    def component_type(self, component_type):
        """
        Sets the component_type of this DiscoveredCloudDbSystemComponent.
        The cloud DB system component type.


        :param component_type: The component_type of this DiscoveredCloudDbSystemComponent.
        :type: str
        """
        allowed_values = ["ASM", "ASM_INSTANCE", "CLUSTER", "CLUSTER_INSTANCE", "DATABASE", "DATABASE_INSTANCE", "DATABASE_HOME", "DATABASE_NODE", "DBSYSTEM", "LISTENER", "PLUGGABLE_DATABASE"]
        if not value_allowed_none_or_none_sentinel(component_type, allowed_values):
            component_type = 'UNKNOWN_ENUM_VALUE'
        self._component_type = component_type

    @property
    def resource_id(self):
        """
        Gets the resource_id of this DiscoveredCloudDbSystemComponent.
        The `OCID`__ of the existing OCI resource matching the discovered DB system component.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this DiscoveredCloudDbSystemComponent.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this DiscoveredCloudDbSystemComponent.
        The `OCID`__ of the existing OCI resource matching the discovered DB system component.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this DiscoveredCloudDbSystemComponent.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def dbaas_id(self):
        """
        Gets the dbaas_id of this DiscoveredCloudDbSystemComponent.
        The `OCID`__ of the existing Dbaas OCI resource matching the discovered DB system component.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The dbaas_id of this DiscoveredCloudDbSystemComponent.
        :rtype: str
        """
        return self._dbaas_id

    @dbaas_id.setter
    def dbaas_id(self, dbaas_id):
        """
        Sets the dbaas_id of this DiscoveredCloudDbSystemComponent.
        The `OCID`__ of the existing Dbaas OCI resource matching the discovered DB system component.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param dbaas_id: The dbaas_id of this DiscoveredCloudDbSystemComponent.
        :type: str
        """
        self._dbaas_id = dbaas_id

    @property
    def is_selected_for_monitoring(self):
        """
        Gets the is_selected_for_monitoring of this DiscoveredCloudDbSystemComponent.
        Indicates whether the DB system component should be provisioned as an OCI resource or not.


        :return: The is_selected_for_monitoring of this DiscoveredCloudDbSystemComponent.
        :rtype: bool
        """
        return self._is_selected_for_monitoring

    @is_selected_for_monitoring.setter
    def is_selected_for_monitoring(self, is_selected_for_monitoring):
        """
        Sets the is_selected_for_monitoring of this DiscoveredCloudDbSystemComponent.
        Indicates whether the DB system component should be provisioned as an OCI resource or not.


        :param is_selected_for_monitoring: The is_selected_for_monitoring of this DiscoveredCloudDbSystemComponent.
        :type: bool
        """
        self._is_selected_for_monitoring = is_selected_for_monitoring

    @property
    def status(self):
        """
        Gets the status of this DiscoveredCloudDbSystemComponent.
        The state of the discovered DB system component.

        Allowed values for this property are: "NEW", "EXISTING", "EXISTING_BASIC", "EXISTING_PE", "EXISTING_BASIC_PE", "MARKED_FOR_UPGRADE", "MARKED_FOR_MIGRATION", "MARKED_FOR_UPGRADE_MIGRATION", "MARKED_FOR_DELETION", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this DiscoveredCloudDbSystemComponent.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this DiscoveredCloudDbSystemComponent.
        The state of the discovered DB system component.


        :param status: The status of this DiscoveredCloudDbSystemComponent.
        :type: str
        """
        allowed_values = ["NEW", "EXISTING", "EXISTING_BASIC", "EXISTING_PE", "EXISTING_BASIC_PE", "MARKED_FOR_UPGRADE", "MARKED_FOR_MIGRATION", "MARKED_FOR_UPGRADE_MIGRATION", "MARKED_FOR_DELETION", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def associated_components(self):
        """
        Gets the associated_components of this DiscoveredCloudDbSystemComponent.
        The list of associated components.


        :return: The associated_components of this DiscoveredCloudDbSystemComponent.
        :rtype: list[oci.database_management.models.AssociatedCloudComponent]
        """
        return self._associated_components

    @associated_components.setter
    def associated_components(self, associated_components):
        """
        Sets the associated_components of this DiscoveredCloudDbSystemComponent.
        The list of associated components.


        :param associated_components: The associated_components of this DiscoveredCloudDbSystemComponent.
        :type: list[oci.database_management.models.AssociatedCloudComponent]
        """
        self._associated_components = associated_components

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
