# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DropSqlsInSqlTuningSetDetails(object):
    """
    Drops the selected list of Sql statements from the current Sql tuning set.
    The basicFilter parameter specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
    If a valid filter criteria is specified, then, Sql statements matching this filter criteria will be deleted from the current Sql tuning set.
    If filter criteria is not specified, then, all Sql statements will be deleted from the current Sql tuning set.
    It takes either credentialDetails or databaseCredential. It's recommended to provide databaseCredential
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DropSqlsInSqlTuningSetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_details:
            The value to assign to the credential_details property of this DropSqlsInSqlTuningSetDetails.
        :type credential_details: oci.database_management.models.SqlTuningSetAdminCredentialDetails

        :param database_credential:
            The value to assign to the database_credential property of this DropSqlsInSqlTuningSetDetails.
        :type database_credential: oci.database_management.models.DatabaseCredentialDetails

        :param show_sql_only:
            The value to assign to the show_sql_only property of this DropSqlsInSqlTuningSetDetails.
        :type show_sql_only: int

        :param owner:
            The value to assign to the owner property of this DropSqlsInSqlTuningSetDetails.
        :type owner: str

        :param name:
            The value to assign to the name property of this DropSqlsInSqlTuningSetDetails.
        :type name: str

        :param basic_filter:
            The value to assign to the basic_filter property of this DropSqlsInSqlTuningSetDetails.
        :type basic_filter: str

        """
        self.swagger_types = {
            'credential_details': 'SqlTuningSetAdminCredentialDetails',
            'database_credential': 'DatabaseCredentialDetails',
            'show_sql_only': 'int',
            'owner': 'str',
            'name': 'str',
            'basic_filter': 'str'
        }
        self.attribute_map = {
            'credential_details': 'credentialDetails',
            'database_credential': 'databaseCredential',
            'show_sql_only': 'showSqlOnly',
            'owner': 'owner',
            'name': 'name',
            'basic_filter': 'basicFilter'
        }
        self._credential_details = None
        self._database_credential = None
        self._show_sql_only = None
        self._owner = None
        self._name = None
        self._basic_filter = None

    @property
    def credential_details(self):
        """
        Gets the credential_details of this DropSqlsInSqlTuningSetDetails.

        :return: The credential_details of this DropSqlsInSqlTuningSetDetails.
        :rtype: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        return self._credential_details

    @credential_details.setter
    def credential_details(self, credential_details):
        """
        Sets the credential_details of this DropSqlsInSqlTuningSetDetails.

        :param credential_details: The credential_details of this DropSqlsInSqlTuningSetDetails.
        :type: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        self._credential_details = credential_details

    @property
    def database_credential(self):
        """
        Gets the database_credential of this DropSqlsInSqlTuningSetDetails.

        :return: The database_credential of this DropSqlsInSqlTuningSetDetails.
        :rtype: oci.database_management.models.DatabaseCredentialDetails
        """
        return self._database_credential

    @database_credential.setter
    def database_credential(self, database_credential):
        """
        Sets the database_credential of this DropSqlsInSqlTuningSetDetails.

        :param database_credential: The database_credential of this DropSqlsInSqlTuningSetDetails.
        :type: oci.database_management.models.DatabaseCredentialDetails
        """
        self._database_credential = database_credential

    @property
    def show_sql_only(self):
        """
        Gets the show_sql_only of this DropSqlsInSqlTuningSetDetails.
        Flag to indicate whether to drop the Sql statements or just display the plsql used to drop the Sql statements.


        :return: The show_sql_only of this DropSqlsInSqlTuningSetDetails.
        :rtype: int
        """
        return self._show_sql_only

    @show_sql_only.setter
    def show_sql_only(self, show_sql_only):
        """
        Sets the show_sql_only of this DropSqlsInSqlTuningSetDetails.
        Flag to indicate whether to drop the Sql statements or just display the plsql used to drop the Sql statements.


        :param show_sql_only: The show_sql_only of this DropSqlsInSqlTuningSetDetails.
        :type: int
        """
        self._show_sql_only = show_sql_only

    @property
    def owner(self):
        """
        Gets the owner of this DropSqlsInSqlTuningSetDetails.
        The owner of the Sql tuning set.


        :return: The owner of this DropSqlsInSqlTuningSetDetails.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this DropSqlsInSqlTuningSetDetails.
        The owner of the Sql tuning set.


        :param owner: The owner of this DropSqlsInSqlTuningSetDetails.
        :type: str
        """
        self._owner = owner

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DropSqlsInSqlTuningSetDetails.
        The name of the Sql tuning set.


        :return: The name of this DropSqlsInSqlTuningSetDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DropSqlsInSqlTuningSetDetails.
        The name of the Sql tuning set.


        :param name: The name of this DropSqlsInSqlTuningSetDetails.
        :type: str
        """
        self._name = name

    @property
    def basic_filter(self):
        """
        Gets the basic_filter of this DropSqlsInSqlTuningSetDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :return: The basic_filter of this DropSqlsInSqlTuningSetDetails.
        :rtype: str
        """
        return self._basic_filter

    @basic_filter.setter
    def basic_filter(self, basic_filter):
        """
        Sets the basic_filter of this DropSqlsInSqlTuningSetDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :param basic_filter: The basic_filter of this DropSqlsInSqlTuningSetDetails.
        :type: str
        """
        self._basic_filter = basic_filter

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
