# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FetchSqlTuningSetDetails(object):
    """
    The details required to fetch the Sql tuning set details.
    It takes either credentialDetails or databaseCredential. It's recommended to provide databaseCredential
    """

    #: A constant which can be used with the recursive_sql property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "HAS_RECURSIVE_SQL"
    RECURSIVE_SQL_HAS_RECURSIVE_SQL = "HAS_RECURSIVE_SQL"

    #: A constant which can be used with the recursive_sql property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "NO_RECURSIVE_SQL"
    RECURSIVE_SQL_NO_RECURSIVE_SQL = "NO_RECURSIVE_SQL"

    #: A constant which can be used with the ranking_measure1 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE1_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure1 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE1_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure1 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE1_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure1 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE1_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure1 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE1_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure1 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE1_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the ranking_measure2 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE2_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure2 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE2_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure2 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE2_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure2 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE2_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure2 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE2_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure2 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE2_DIRECT_WRITES = "DIRECT_WRITES"

    #: A constant which can be used with the ranking_measure3 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "ELAPSED_TIME"
    RANKING_MEASURE3_ELAPSED_TIME = "ELAPSED_TIME"

    #: A constant which can be used with the ranking_measure3 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "CPU_TIME"
    RANKING_MEASURE3_CPU_TIME = "CPU_TIME"

    #: A constant which can be used with the ranking_measure3 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "OPTIMIZER_COST"
    RANKING_MEASURE3_OPTIMIZER_COST = "OPTIMIZER_COST"

    #: A constant which can be used with the ranking_measure3 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "BUFFER_GETS"
    RANKING_MEASURE3_BUFFER_GETS = "BUFFER_GETS"

    #: A constant which can be used with the ranking_measure3 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "DISK_READS"
    RANKING_MEASURE3_DISK_READS = "DISK_READS"

    #: A constant which can be used with the ranking_measure3 property of a FetchSqlTuningSetDetails.
    #: This constant has a value of "DIRECT_WRITES"
    RANKING_MEASURE3_DIRECT_WRITES = "DIRECT_WRITES"

    def __init__(self, **kwargs):
        """
        Initializes a new FetchSqlTuningSetDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_details:
            The value to assign to the credential_details property of this FetchSqlTuningSetDetails.
        :type credential_details: oci.database_management.models.SqlTuningSetAdminCredentialDetails

        :param database_credential:
            The value to assign to the database_credential property of this FetchSqlTuningSetDetails.
        :type database_credential: oci.database_management.models.DatabaseCredentialDetails

        :param owner:
            The value to assign to the owner property of this FetchSqlTuningSetDetails.
        :type owner: str

        :param name:
            The value to assign to the name property of this FetchSqlTuningSetDetails.
        :type name: str

        :param basic_filter:
            The value to assign to the basic_filter property of this FetchSqlTuningSetDetails.
        :type basic_filter: str

        :param recursive_sql:
            The value to assign to the recursive_sql property of this FetchSqlTuningSetDetails.
            Allowed values for this property are: "HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"
        :type recursive_sql: str

        :param result_percentage:
            The value to assign to the result_percentage property of this FetchSqlTuningSetDetails.
        :type result_percentage: float

        :param result_limit:
            The value to assign to the result_limit property of this FetchSqlTuningSetDetails.
        :type result_limit: int

        :param ranking_measure1:
            The value to assign to the ranking_measure1 property of this FetchSqlTuningSetDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure1: str

        :param ranking_measure2:
            The value to assign to the ranking_measure2 property of this FetchSqlTuningSetDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure2: str

        :param ranking_measure3:
            The value to assign to the ranking_measure3 property of this FetchSqlTuningSetDetails.
            Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"
        :type ranking_measure3: str

        """
        self.swagger_types = {
            'credential_details': 'SqlTuningSetAdminCredentialDetails',
            'database_credential': 'DatabaseCredentialDetails',
            'owner': 'str',
            'name': 'str',
            'basic_filter': 'str',
            'recursive_sql': 'str',
            'result_percentage': 'float',
            'result_limit': 'int',
            'ranking_measure1': 'str',
            'ranking_measure2': 'str',
            'ranking_measure3': 'str'
        }
        self.attribute_map = {
            'credential_details': 'credentialDetails',
            'database_credential': 'databaseCredential',
            'owner': 'owner',
            'name': 'name',
            'basic_filter': 'basicFilter',
            'recursive_sql': 'recursiveSql',
            'result_percentage': 'resultPercentage',
            'result_limit': 'resultLimit',
            'ranking_measure1': 'rankingMeasure1',
            'ranking_measure2': 'rankingMeasure2',
            'ranking_measure3': 'rankingMeasure3'
        }
        self._credential_details = None
        self._database_credential = None
        self._owner = None
        self._name = None
        self._basic_filter = None
        self._recursive_sql = None
        self._result_percentage = None
        self._result_limit = None
        self._ranking_measure1 = None
        self._ranking_measure2 = None
        self._ranking_measure3 = None

    @property
    def credential_details(self):
        """
        Gets the credential_details of this FetchSqlTuningSetDetails.

        :return: The credential_details of this FetchSqlTuningSetDetails.
        :rtype: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        return self._credential_details

    @credential_details.setter
    def credential_details(self, credential_details):
        """
        Sets the credential_details of this FetchSqlTuningSetDetails.

        :param credential_details: The credential_details of this FetchSqlTuningSetDetails.
        :type: oci.database_management.models.SqlTuningSetAdminCredentialDetails
        """
        self._credential_details = credential_details

    @property
    def database_credential(self):
        """
        Gets the database_credential of this FetchSqlTuningSetDetails.

        :return: The database_credential of this FetchSqlTuningSetDetails.
        :rtype: oci.database_management.models.DatabaseCredentialDetails
        """
        return self._database_credential

    @database_credential.setter
    def database_credential(self, database_credential):
        """
        Sets the database_credential of this FetchSqlTuningSetDetails.

        :param database_credential: The database_credential of this FetchSqlTuningSetDetails.
        :type: oci.database_management.models.DatabaseCredentialDetails
        """
        self._database_credential = database_credential

    @property
    def owner(self):
        """
        **[Required]** Gets the owner of this FetchSqlTuningSetDetails.
        The owner of the Sql tuning set.


        :return: The owner of this FetchSqlTuningSetDetails.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this FetchSqlTuningSetDetails.
        The owner of the Sql tuning set.


        :param owner: The owner of this FetchSqlTuningSetDetails.
        :type: str
        """
        self._owner = owner

    @property
    def name(self):
        """
        **[Required]** Gets the name of this FetchSqlTuningSetDetails.
        The name of the Sql tuning set.


        :return: The name of this FetchSqlTuningSetDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FetchSqlTuningSetDetails.
        The name of the Sql tuning set.


        :param name: The name of this FetchSqlTuningSetDetails.
        :type: str
        """
        self._name = name

    @property
    def basic_filter(self):
        """
        Gets the basic_filter of this FetchSqlTuningSetDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :return: The basic_filter of this FetchSqlTuningSetDetails.
        :rtype: str
        """
        return self._basic_filter

    @basic_filter.setter
    def basic_filter(self, basic_filter):
        """
        Sets the basic_filter of this FetchSqlTuningSetDetails.
        Specifies the Sql predicate to filter the Sql from the Sql tuning set defined on attributes of the SQLSET_ROW.
        User could use any combination of the following columns with appropriate values as Sql predicate
        Refer to the documentation https://docs.oracle.com/en/database/oracle/oracle-database/18/arpls/DBMS_SQLTUNE.html#GUID-1F4AFB03-7B29-46FC-B3F2-CB01EC36326C


        :param basic_filter: The basic_filter of this FetchSqlTuningSetDetails.
        :type: str
        """
        self._basic_filter = basic_filter

    @property
    def recursive_sql(self):
        """
        Gets the recursive_sql of this FetchSqlTuningSetDetails.
        Specifies that the filter must include recursive Sql in the Sql tuning set.

        Allowed values for this property are: "HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"


        :return: The recursive_sql of this FetchSqlTuningSetDetails.
        :rtype: str
        """
        return self._recursive_sql

    @recursive_sql.setter
    def recursive_sql(self, recursive_sql):
        """
        Sets the recursive_sql of this FetchSqlTuningSetDetails.
        Specifies that the filter must include recursive Sql in the Sql tuning set.


        :param recursive_sql: The recursive_sql of this FetchSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["HAS_RECURSIVE_SQL", "NO_RECURSIVE_SQL"]
        if not value_allowed_none_or_none_sentinel(recursive_sql, allowed_values):
            raise ValueError(
                f"Invalid value for `recursive_sql`, must be None or one of {allowed_values}"
            )
        self._recursive_sql = recursive_sql

    @property
    def result_percentage(self):
        """
        Gets the result_percentage of this FetchSqlTuningSetDetails.
        Specifies a filter that picks the top n% according to the supplied ranking measure.
        Note that this parameter applies only if one ranking measure is supplied.


        :return: The result_percentage of this FetchSqlTuningSetDetails.
        :rtype: float
        """
        return self._result_percentage

    @result_percentage.setter
    def result_percentage(self, result_percentage):
        """
        Sets the result_percentage of this FetchSqlTuningSetDetails.
        Specifies a filter that picks the top n% according to the supplied ranking measure.
        Note that this parameter applies only if one ranking measure is supplied.


        :param result_percentage: The result_percentage of this FetchSqlTuningSetDetails.
        :type: float
        """
        self._result_percentage = result_percentage

    @property
    def result_limit(self):
        """
        Gets the result_limit of this FetchSqlTuningSetDetails.
        The top limit Sql from the filtered source, ranked by the ranking measure.


        :return: The result_limit of this FetchSqlTuningSetDetails.
        :rtype: int
        """
        return self._result_limit

    @result_limit.setter
    def result_limit(self, result_limit):
        """
        Sets the result_limit of this FetchSqlTuningSetDetails.
        The top limit Sql from the filtered source, ranked by the ranking measure.


        :param result_limit: The result_limit of this FetchSqlTuningSetDetails.
        :type: int
        """
        self._result_limit = result_limit

    @property
    def ranking_measure1(self):
        """
        Gets the ranking_measure1 of this FetchSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure1 of this FetchSqlTuningSetDetails.
        :rtype: str
        """
        return self._ranking_measure1

    @ranking_measure1.setter
    def ranking_measure1(self, ranking_measure1):
        """
        Sets the ranking_measure1 of this FetchSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure1: The ranking_measure1 of this FetchSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure1, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure1`, must be None or one of {allowed_values}"
            )
        self._ranking_measure1 = ranking_measure1

    @property
    def ranking_measure2(self):
        """
        Gets the ranking_measure2 of this FetchSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure2 of this FetchSqlTuningSetDetails.
        :rtype: str
        """
        return self._ranking_measure2

    @ranking_measure2.setter
    def ranking_measure2(self, ranking_measure2):
        """
        Sets the ranking_measure2 of this FetchSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure2: The ranking_measure2 of this FetchSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure2, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure2`, must be None or one of {allowed_values}"
            )
        self._ranking_measure2 = ranking_measure2

    @property
    def ranking_measure3(self):
        """
        Gets the ranking_measure3 of this FetchSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.

        Allowed values for this property are: "ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"


        :return: The ranking_measure3 of this FetchSqlTuningSetDetails.
        :rtype: str
        """
        return self._ranking_measure3

    @ranking_measure3.setter
    def ranking_measure3(self, ranking_measure3):
        """
        Sets the ranking_measure3 of this FetchSqlTuningSetDetails.
        Specifies an ORDER BY clause on the selected Sql. User can specify upto three ranking measures.


        :param ranking_measure3: The ranking_measure3 of this FetchSqlTuningSetDetails.
        :type: str
        """
        allowed_values = ["ELAPSED_TIME", "CPU_TIME", "OPTIMIZER_COST", "BUFFER_GETS", "DISK_READS", "DIRECT_WRITES"]
        if not value_allowed_none_or_none_sentinel(ranking_measure3, allowed_values):
            raise ValueError(
                f"Invalid value for `ranking_measure3`, must be None or one of {allowed_values}"
            )
        self._ranking_measure3 = ranking_measure3

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
