# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HeatWaveFleetMetricSummaryDefinition(object):
    """
    A summary of the fleet metrics, which provides the metric aggregated value of the HeatWave clusters in the fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HeatWaveFleetMetricSummaryDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this HeatWaveFleetMetricSummaryDefinition.
        :type metric_name: str

        :param metric_value:
            The value to assign to the metric_value property of this HeatWaveFleetMetricSummaryDefinition.
        :type metric_value: float

        :param dimensions:
            The value to assign to the dimensions property of this HeatWaveFleetMetricSummaryDefinition.
        :type dimensions: list[oci.database_management.models.MetricDimensionDefinition]

        :param unit:
            The value to assign to the unit property of this HeatWaveFleetMetricSummaryDefinition.
        :type unit: str

        """
        self.swagger_types = {
            'metric_name': 'str',
            'metric_value': 'float',
            'dimensions': 'list[MetricDimensionDefinition]',
            'unit': 'str'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'metric_value': 'metricValue',
            'dimensions': 'dimensions',
            'unit': 'unit'
        }
        self._metric_name = None
        self._metric_value = None
        self._dimensions = None
        self._unit = None

    @property
    def metric_name(self):
        """
        **[Required]** Gets the metric_name of this HeatWaveFleetMetricSummaryDefinition.
        The name of the metric.


        :return: The metric_name of this HeatWaveFleetMetricSummaryDefinition.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this HeatWaveFleetMetricSummaryDefinition.
        The name of the metric.


        :param metric_name: The metric_name of this HeatWaveFleetMetricSummaryDefinition.
        :type: str
        """
        self._metric_name = metric_name

    @property
    def metric_value(self):
        """
        **[Required]** Gets the metric_value of this HeatWaveFleetMetricSummaryDefinition.
        The aggregated metric value.


        :return: The metric_value of this HeatWaveFleetMetricSummaryDefinition.
        :rtype: float
        """
        return self._metric_value

    @metric_value.setter
    def metric_value(self, metric_value):
        """
        Sets the metric_value of this HeatWaveFleetMetricSummaryDefinition.
        The aggregated metric value.


        :param metric_value: The metric_value of this HeatWaveFleetMetricSummaryDefinition.
        :type: float
        """
        self._metric_value = metric_value

    @property
    def dimensions(self):
        """
        **[Required]** Gets the dimensions of this HeatWaveFleetMetricSummaryDefinition.
        The unique dimension key and values of the metric.


        :return: The dimensions of this HeatWaveFleetMetricSummaryDefinition.
        :rtype: list[oci.database_management.models.MetricDimensionDefinition]
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this HeatWaveFleetMetricSummaryDefinition.
        The unique dimension key and values of the metric.


        :param dimensions: The dimensions of this HeatWaveFleetMetricSummaryDefinition.
        :type: list[oci.database_management.models.MetricDimensionDefinition]
        """
        self._dimensions = dimensions

    @property
    def unit(self):
        """
        **[Required]** Gets the unit of this HeatWaveFleetMetricSummaryDefinition.
        The unit of the metric value.


        :return: The unit of this HeatWaveFleetMetricSummaryDefinition.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this HeatWaveFleetMetricSummaryDefinition.
        The unit of the metric value.


        :param unit: The unit of this HeatWaveFleetMetricSummaryDefinition.
        :type: str
        """
        self._unit = unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
