# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlHighAvailabilityStatusSummary(object):
    """
    High availability status summary of a MySQL server.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlHighAvailabilityStatusSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param channel_fetch_errors:
            The value to assign to the channel_fetch_errors property of this MySqlHighAvailabilityStatusSummary.
        :type channel_fetch_errors: list[oci.database_management.models.MySqlChannelFetchError]

        :param channel_apply_errors:
            The value to assign to the channel_apply_errors property of this MySqlHighAvailabilityStatusSummary.
        :type channel_apply_errors: list[oci.database_management.models.MySqlChannelApplyError]

        """
        self.swagger_types = {
            'channel_fetch_errors': 'list[MySqlChannelFetchError]',
            'channel_apply_errors': 'list[MySqlChannelApplyError]'
        }
        self.attribute_map = {
            'channel_fetch_errors': 'channelFetchErrors',
            'channel_apply_errors': 'channelApplyErrors'
        }
        self._channel_fetch_errors = None
        self._channel_apply_errors = None

    @property
    def channel_fetch_errors(self):
        """
        Gets the channel_fetch_errors of this MySqlHighAvailabilityStatusSummary.
        A list of MySqlChannelFetchError records.


        :return: The channel_fetch_errors of this MySqlHighAvailabilityStatusSummary.
        :rtype: list[oci.database_management.models.MySqlChannelFetchError]
        """
        return self._channel_fetch_errors

    @channel_fetch_errors.setter
    def channel_fetch_errors(self, channel_fetch_errors):
        """
        Sets the channel_fetch_errors of this MySqlHighAvailabilityStatusSummary.
        A list of MySqlChannelFetchError records.


        :param channel_fetch_errors: The channel_fetch_errors of this MySqlHighAvailabilityStatusSummary.
        :type: list[oci.database_management.models.MySqlChannelFetchError]
        """
        self._channel_fetch_errors = channel_fetch_errors

    @property
    def channel_apply_errors(self):
        """
        Gets the channel_apply_errors of this MySqlHighAvailabilityStatusSummary.
        A list of MySqlChannelApplyError records.


        :return: The channel_apply_errors of this MySqlHighAvailabilityStatusSummary.
        :rtype: list[oci.database_management.models.MySqlChannelApplyError]
        """
        return self._channel_apply_errors

    @channel_apply_errors.setter
    def channel_apply_errors(self, channel_apply_errors):
        """
        Sets the channel_apply_errors of this MySqlHighAvailabilityStatusSummary.
        A list of MySqlChannelApplyError records.


        :param channel_apply_errors: The channel_apply_errors of this MySqlHighAvailabilityStatusSummary.
        :type: list[oci.database_management.models.MySqlChannelApplyError]
        """
        self._channel_apply_errors = channel_apply_errors

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
