# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MySqlQueryMessage(object):
    """
    The MySQL error, warning or note raised when a query is run, if any.
    """

    #: A constant which can be used with the level property of a MySqlQueryMessage.
    #: This constant has a value of "ERROR"
    LEVEL_ERROR = "ERROR"

    #: A constant which can be used with the level property of a MySqlQueryMessage.
    #: This constant has a value of "WARNING"
    LEVEL_WARNING = "WARNING"

    #: A constant which can be used with the level property of a MySqlQueryMessage.
    #: This constant has a value of "NOTE"
    LEVEL_NOTE = "NOTE"

    def __init__(self, **kwargs):
        """
        Initializes a new MySqlQueryMessage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param level:
            The value to assign to the level property of this MySqlQueryMessage.
            Allowed values for this property are: "ERROR", "WARNING", "NOTE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type level: str

        :param code:
            The value to assign to the code property of this MySqlQueryMessage.
        :type code: int

        :param message_text:
            The value to assign to the message_text property of this MySqlQueryMessage.
        :type message_text: str

        """
        self.swagger_types = {
            'level': 'str',
            'code': 'int',
            'message_text': 'str'
        }
        self.attribute_map = {
            'level': 'level',
            'code': 'code',
            'message_text': 'messageText'
        }
        self._level = None
        self._code = None
        self._message_text = None

    @property
    def level(self):
        """
        **[Required]** Gets the level of this MySqlQueryMessage.
        The level of severity of the MySQL message.

        Allowed values for this property are: "ERROR", "WARNING", "NOTE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The level of this MySqlQueryMessage.
        :rtype: str
        """
        return self._level

    @level.setter
    def level(self, level):
        """
        Sets the level of this MySqlQueryMessage.
        The level of severity of the MySQL message.


        :param level: The level of this MySqlQueryMessage.
        :type: str
        """
        allowed_values = ["ERROR", "WARNING", "NOTE"]
        if not value_allowed_none_or_none_sentinel(level, allowed_values):
            level = 'UNKNOWN_ENUM_VALUE'
        self._level = level

    @property
    def code(self):
        """
        **[Required]** Gets the code of this MySqlQueryMessage.
        The MySQL code of the raised error, warning or note.


        :return: The code of this MySqlQueryMessage.
        :rtype: int
        """
        return self._code

    @code.setter
    def code(self, code):
        """
        Sets the code of this MySqlQueryMessage.
        The MySQL code of the raised error, warning or note.


        :param code: The code of this MySqlQueryMessage.
        :type: int
        """
        self._code = code

    @property
    def message_text(self):
        """
        **[Required]** Gets the message_text of this MySqlQueryMessage.
        The MySQL message text of the raised error, warning or note.


        :return: The message_text of this MySqlQueryMessage.
        :rtype: str
        """
        return self._message_text

    @message_text.setter
    def message_text(self, message_text):
        """
        Sets the message_text of this MySqlQueryMessage.
        The MySQL message text of the raised error, warning or note.


        :param message_text: The message_text of this MySqlQueryMessage.
        :type: str
        """
        self._message_text = message_text

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
