# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlMetrics(object):
    """
    Metrics of the Sql in the Sql tuning set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SqlMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cpu_time:
            The value to assign to the cpu_time property of this SqlMetrics.
        :type cpu_time: int

        :param elapsed_time:
            The value to assign to the elapsed_time property of this SqlMetrics.
        :type elapsed_time: int

        :param buffer_gets:
            The value to assign to the buffer_gets property of this SqlMetrics.
        :type buffer_gets: int

        :param disk_reads:
            The value to assign to the disk_reads property of this SqlMetrics.
        :type disk_reads: int

        :param direct_writes:
            The value to assign to the direct_writes property of this SqlMetrics.
        :type direct_writes: int

        :param executions:
            The value to assign to the executions property of this SqlMetrics.
        :type executions: int

        """
        self.swagger_types = {
            'cpu_time': 'int',
            'elapsed_time': 'int',
            'buffer_gets': 'int',
            'disk_reads': 'int',
            'direct_writes': 'int',
            'executions': 'int'
        }
        self.attribute_map = {
            'cpu_time': 'cpuTime',
            'elapsed_time': 'elapsedTime',
            'buffer_gets': 'bufferGets',
            'disk_reads': 'diskReads',
            'direct_writes': 'directWrites',
            'executions': 'executions'
        }
        self._cpu_time = None
        self._elapsed_time = None
        self._buffer_gets = None
        self._disk_reads = None
        self._direct_writes = None
        self._executions = None

    @property
    def cpu_time(self):
        """
        Gets the cpu_time of this SqlMetrics.
        Total CPU time consumed by the Sql.


        :return: The cpu_time of this SqlMetrics.
        :rtype: int
        """
        return self._cpu_time

    @cpu_time.setter
    def cpu_time(self, cpu_time):
        """
        Sets the cpu_time of this SqlMetrics.
        Total CPU time consumed by the Sql.


        :param cpu_time: The cpu_time of this SqlMetrics.
        :type: int
        """
        self._cpu_time = cpu_time

    @property
    def elapsed_time(self):
        """
        Gets the elapsed_time of this SqlMetrics.
        Elapsed time of the Sql.


        :return: The elapsed_time of this SqlMetrics.
        :rtype: int
        """
        return self._elapsed_time

    @elapsed_time.setter
    def elapsed_time(self, elapsed_time):
        """
        Sets the elapsed_time of this SqlMetrics.
        Elapsed time of the Sql.


        :param elapsed_time: The elapsed_time of this SqlMetrics.
        :type: int
        """
        self._elapsed_time = elapsed_time

    @property
    def buffer_gets(self):
        """
        Gets the buffer_gets of this SqlMetrics.
        Sum total number of buffer gets.


        :return: The buffer_gets of this SqlMetrics.
        :rtype: int
        """
        return self._buffer_gets

    @buffer_gets.setter
    def buffer_gets(self, buffer_gets):
        """
        Sets the buffer_gets of this SqlMetrics.
        Sum total number of buffer gets.


        :param buffer_gets: The buffer_gets of this SqlMetrics.
        :type: int
        """
        self._buffer_gets = buffer_gets

    @property
    def disk_reads(self):
        """
        Gets the disk_reads of this SqlMetrics.
        Sum total number of disk reads.


        :return: The disk_reads of this SqlMetrics.
        :rtype: int
        """
        return self._disk_reads

    @disk_reads.setter
    def disk_reads(self, disk_reads):
        """
        Sets the disk_reads of this SqlMetrics.
        Sum total number of disk reads.


        :param disk_reads: The disk_reads of this SqlMetrics.
        :type: int
        """
        self._disk_reads = disk_reads

    @property
    def direct_writes(self):
        """
        Gets the direct_writes of this SqlMetrics.
        Sum total number of direct path writes.


        :return: The direct_writes of this SqlMetrics.
        :rtype: int
        """
        return self._direct_writes

    @direct_writes.setter
    def direct_writes(self, direct_writes):
        """
        Sets the direct_writes of this SqlMetrics.
        Sum total number of direct path writes.


        :param direct_writes: The direct_writes of this SqlMetrics.
        :type: int
        """
        self._direct_writes = direct_writes

    @property
    def executions(self):
        """
        Gets the executions of this SqlMetrics.
        Total executions of this SQL statement.


        :return: The executions of this SqlMetrics.
        :rtype: int
        """
        return self._executions

    @executions.setter
    def executions(self, executions):
        """
        Sets the executions of this SqlMetrics.
        Total executions of this SQL statement.


        :param executions: The executions of this SqlMetrics.
        :type: int
        """
        self._executions = executions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
