# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateExternalMySqlDatabaseDetails(object):
    """
    Details for updating an external MySQL database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateExternalMySqlDatabaseDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_name:
            The value to assign to the db_name property of this UpdateExternalMySqlDatabaseDetails.
        :type db_name: str

        """
        self.swagger_types = {
            'db_name': 'str'
        }
        self.attribute_map = {
            'db_name': 'dbName'
        }
        self._db_name = None

    @property
    def db_name(self):
        """
        **[Required]** Gets the db_name of this UpdateExternalMySqlDatabaseDetails.
        Display Name of the External MySQL Database.


        :return: The db_name of this UpdateExternalMySqlDatabaseDetails.
        :rtype: str
        """
        return self._db_name

    @db_name.setter
    def db_name(self, db_name):
        """
        Sets the db_name of this UpdateExternalMySqlDatabaseDetails.
        Display Name of the External MySQL Database.


        :param db_name: The db_name of this UpdateExternalMySqlDatabaseDetails.
        :type: str
        """
        self._db_name = db_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
