# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseToolsIdentitySummary(object):
    """
    Summary of the Database Tools identity.
    """

    #: A constant which can be used with the type property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "ORACLE_DATABASE_RESOURCE_PRINCIPAL"
    TYPE_ORACLE_DATABASE_RESOURCE_PRINCIPAL = "ORACLE_DATABASE_RESOURCE_PRINCIPAL"

    #: A constant which can be used with the lifecycle_state property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a DatabaseToolsIdentitySummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseToolsIdentitySummary object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_tools.models.DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DatabaseToolsIdentitySummary.
        :type id: str

        :param type:
            The value to assign to the type property of this DatabaseToolsIdentitySummary.
            Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DatabaseToolsIdentitySummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this DatabaseToolsIdentitySummary.
        :type display_name: str

        :param database_tools_connection_id:
            The value to assign to the database_tools_connection_id property of this DatabaseToolsIdentitySummary.
        :type database_tools_connection_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DatabaseToolsIdentitySummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DatabaseToolsIdentitySummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this DatabaseToolsIdentitySummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DatabaseToolsIdentitySummary.
        :type time_updated: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this DatabaseToolsIdentitySummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DatabaseToolsIdentitySummary.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this DatabaseToolsIdentitySummary.
        :type system_tags: dict(str, dict(str, object))

        :param locks:
            The value to assign to the locks property of this DatabaseToolsIdentitySummary.
        :type locks: list[oci.database_tools.models.ResourceLock]

        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'database_tools_connection_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))',
            'locks': 'list[ResourceLock]'
        }
        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'database_tools_connection_id': 'databaseToolsConnectionId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags',
            'locks': 'locks'
        }
        self._id = None
        self._type = None
        self._compartment_id = None
        self._display_name = None
        self._database_tools_connection_id = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None
        self._locks = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'ORACLE_DATABASE_RESOURCE_PRINCIPAL':
            return 'DatabaseToolsIdentityOracleDatabaseResourcePrincipalSummary'
        else:
            return 'DatabaseToolsIdentitySummary'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DatabaseToolsIdentitySummary.
        The `OCID`__ of the Database Tools identity.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DatabaseToolsIdentitySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DatabaseToolsIdentitySummary.
        The `OCID`__ of the Database Tools identity.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DatabaseToolsIdentitySummary.
        :type: str
        """
        self._id = id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this DatabaseToolsIdentitySummary.
        The Database Tools identity type.

        Allowed values for this property are: "ORACLE_DATABASE_RESOURCE_PRINCIPAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this DatabaseToolsIdentitySummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this DatabaseToolsIdentitySummary.
        The Database Tools identity type.


        :param type: The type of this DatabaseToolsIdentitySummary.
        :type: str
        """
        allowed_values = ["ORACLE_DATABASE_RESOURCE_PRINCIPAL"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DatabaseToolsIdentitySummary.
        The `OCID`__ of the compartment containing the Database Tools identity.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DatabaseToolsIdentitySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DatabaseToolsIdentitySummary.
        The `OCID`__ of the compartment containing the Database Tools identity.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DatabaseToolsIdentitySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DatabaseToolsIdentitySummary.
        A user-friendly name. Does not have to be unique and can be updated. Avoid entering confidential information.


        :return: The display_name of this DatabaseToolsIdentitySummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DatabaseToolsIdentitySummary.
        A user-friendly name. Does not have to be unique and can be updated. Avoid entering confidential information.


        :param display_name: The display_name of this DatabaseToolsIdentitySummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def database_tools_connection_id(self):
        """
        **[Required]** Gets the database_tools_connection_id of this DatabaseToolsIdentitySummary.
        The `OCID`__ of the related Database Tools connection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The database_tools_connection_id of this DatabaseToolsIdentitySummary.
        :rtype: str
        """
        return self._database_tools_connection_id

    @database_tools_connection_id.setter
    def database_tools_connection_id(self, database_tools_connection_id):
        """
        Sets the database_tools_connection_id of this DatabaseToolsIdentitySummary.
        The `OCID`__ of the related Database Tools connection.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param database_tools_connection_id: The database_tools_connection_id of this DatabaseToolsIdentitySummary.
        :type: str
        """
        self._database_tools_connection_id = database_tools_connection_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DatabaseToolsIdentitySummary.
        The current state of the Database Tools identity.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DatabaseToolsIdentitySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DatabaseToolsIdentitySummary.
        The current state of the Database Tools identity.


        :param lifecycle_state: The lifecycle_state of this DatabaseToolsIdentitySummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DatabaseToolsIdentitySummary.
        A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this DatabaseToolsIdentitySummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DatabaseToolsIdentitySummary.
        A message describing the current state in more detail. For example, this message can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this DatabaseToolsIdentitySummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DatabaseToolsIdentitySummary.
        The time the Database Tools identity was created. An RFC3339 formatted datetime string.


        :return: The time_created of this DatabaseToolsIdentitySummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DatabaseToolsIdentitySummary.
        The time the Database Tools identity was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this DatabaseToolsIdentitySummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DatabaseToolsIdentitySummary.
        The time the Database Tools identity was updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this DatabaseToolsIdentitySummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DatabaseToolsIdentitySummary.
        The time the Database Tools identity was updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this DatabaseToolsIdentitySummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DatabaseToolsIdentitySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DatabaseToolsIdentitySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DatabaseToolsIdentitySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DatabaseToolsIdentitySummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DatabaseToolsIdentitySummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DatabaseToolsIdentitySummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DatabaseToolsIdentitySummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DatabaseToolsIdentitySummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DatabaseToolsIdentitySummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DatabaseToolsIdentitySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DatabaseToolsIdentitySummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DatabaseToolsIdentitySummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def locks(self):
        """
        Gets the locks of this DatabaseToolsIdentitySummary.
        Locks associated with this resource.


        :return: The locks of this DatabaseToolsIdentitySummary.
        :rtype: list[oci.database_tools.models.ResourceLock]
        """
        return self._locks

    @locks.setter
    def locks(self, locks):
        """
        Sets the locks of this DatabaseToolsIdentitySummary.
        Locks associated with this resource.


        :param locks: The locks of this DatabaseToolsIdentitySummary.
        :type: list[oci.database_tools.models.ResourceLock]
        """
        self._locks = locks

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
