# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceSummary(object):
    """
    Summary of dblm registered and unregistered resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_resources_count:
            The value to assign to the total_resources_count property of this ResourceSummary.
        :type total_resources_count: int

        :param registered_resources_count:
            The value to assign to the registered_resources_count property of this ResourceSummary.
        :type registered_resources_count: int

        :param not_registered_resources_count:
            The value to assign to the not_registered_resources_count property of this ResourceSummary.
        :type not_registered_resources_count: int

        :param vulnerable_resources_count:
            The value to assign to the vulnerable_resources_count property of this ResourceSummary.
        :type vulnerable_resources_count: int

        :param clean_resources_count:
            The value to assign to the clean_resources_count property of this ResourceSummary.
        :type clean_resources_count: int

        :param error_resources_count:
            The value to assign to the error_resources_count property of this ResourceSummary.
        :type error_resources_count: int

        """
        self.swagger_types = {
            'total_resources_count': 'int',
            'registered_resources_count': 'int',
            'not_registered_resources_count': 'int',
            'vulnerable_resources_count': 'int',
            'clean_resources_count': 'int',
            'error_resources_count': 'int'
        }
        self.attribute_map = {
            'total_resources_count': 'totalResourcesCount',
            'registered_resources_count': 'registeredResourcesCount',
            'not_registered_resources_count': 'notRegisteredResourcesCount',
            'vulnerable_resources_count': 'vulnerableResourcesCount',
            'clean_resources_count': 'cleanResourcesCount',
            'error_resources_count': 'errorResourcesCount'
        }
        self._total_resources_count = None
        self._registered_resources_count = None
        self._not_registered_resources_count = None
        self._vulnerable_resources_count = None
        self._clean_resources_count = None
        self._error_resources_count = None

    @property
    def total_resources_count(self):
        """
        **[Required]** Gets the total_resources_count of this ResourceSummary.
        The total number of resources.


        :return: The total_resources_count of this ResourceSummary.
        :rtype: int
        """
        return self._total_resources_count

    @total_resources_count.setter
    def total_resources_count(self, total_resources_count):
        """
        Sets the total_resources_count of this ResourceSummary.
        The total number of resources.


        :param total_resources_count: The total_resources_count of this ResourceSummary.
        :type: int
        """
        self._total_resources_count = total_resources_count

    @property
    def registered_resources_count(self):
        """
        **[Required]** Gets the registered_resources_count of this ResourceSummary.
        The total number of registered resources.


        :return: The registered_resources_count of this ResourceSummary.
        :rtype: int
        """
        return self._registered_resources_count

    @registered_resources_count.setter
    def registered_resources_count(self, registered_resources_count):
        """
        Sets the registered_resources_count of this ResourceSummary.
        The total number of registered resources.


        :param registered_resources_count: The registered_resources_count of this ResourceSummary.
        :type: int
        """
        self._registered_resources_count = registered_resources_count

    @property
    def not_registered_resources_count(self):
        """
        **[Required]** Gets the not_registered_resources_count of this ResourceSummary.
        The total number of resources that are not registered.


        :return: The not_registered_resources_count of this ResourceSummary.
        :rtype: int
        """
        return self._not_registered_resources_count

    @not_registered_resources_count.setter
    def not_registered_resources_count(self, not_registered_resources_count):
        """
        Sets the not_registered_resources_count of this ResourceSummary.
        The total number of resources that are not registered.


        :param not_registered_resources_count: The not_registered_resources_count of this ResourceSummary.
        :type: int
        """
        self._not_registered_resources_count = not_registered_resources_count

    @property
    def vulnerable_resources_count(self):
        """
        **[Required]** Gets the vulnerable_resources_count of this ResourceSummary.
        Total number of resources that have 1 or more vulnerabilities.


        :return: The vulnerable_resources_count of this ResourceSummary.
        :rtype: int
        """
        return self._vulnerable_resources_count

    @vulnerable_resources_count.setter
    def vulnerable_resources_count(self, vulnerable_resources_count):
        """
        Sets the vulnerable_resources_count of this ResourceSummary.
        Total number of resources that have 1 or more vulnerabilities.


        :param vulnerable_resources_count: The vulnerable_resources_count of this ResourceSummary.
        :type: int
        """
        self._vulnerable_resources_count = vulnerable_resources_count

    @property
    def clean_resources_count(self):
        """
        **[Required]** Gets the clean_resources_count of this ResourceSummary.
        Total number of resources that have 0 vulnerabilities.


        :return: The clean_resources_count of this ResourceSummary.
        :rtype: int
        """
        return self._clean_resources_count

    @clean_resources_count.setter
    def clean_resources_count(self, clean_resources_count):
        """
        Sets the clean_resources_count of this ResourceSummary.
        Total number of resources that have 0 vulnerabilities.


        :param clean_resources_count: The clean_resources_count of this ResourceSummary.
        :type: int
        """
        self._clean_resources_count = clean_resources_count

    @property
    def error_resources_count(self):
        """
        **[Required]** Gets the error_resources_count of this ResourceSummary.
        Total number of resources that contain an error.


        :return: The error_resources_count of this ResourceSummary.
        :rtype: int
        """
        return self._error_resources_count

    @error_resources_count.setter
    def error_resources_count(self, error_resources_count):
        """
        Sets the error_resources_count of this ResourceSummary.
        Total number of resources that contain an error.


        :param error_resources_count: The error_resources_count of this ResourceSummary.
        :type: int
        """
        self._error_resources_count = error_resources_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
