# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OracleDbAzureVaultAssociation(object):
    """
    Oracle DB Azure Vault Association resource object.
    """

    #: A constant which can be used with the lifecycle_state property of a OracleDbAzureVaultAssociation.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAzureVaultAssociation.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAzureVaultAssociation.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAzureVaultAssociation.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAzureVaultAssociation.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a OracleDbAzureVaultAssociation.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new OracleDbAzureVaultAssociation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OracleDbAzureVaultAssociation.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OracleDbAzureVaultAssociation.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this OracleDbAzureVaultAssociation.
        :type display_name: str

        :param oracle_db_azure_connector_id:
            The value to assign to the oracle_db_azure_connector_id property of this OracleDbAzureVaultAssociation.
        :type oracle_db_azure_connector_id: str

        :param oracle_db_azure_vault_id:
            The value to assign to the oracle_db_azure_vault_id property of this OracleDbAzureVaultAssociation.
        :type oracle_db_azure_vault_id: str

        :param is_resource_accessible:
            The value to assign to the is_resource_accessible property of this OracleDbAzureVaultAssociation.
        :type is_resource_accessible: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OracleDbAzureVaultAssociation.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this OracleDbAzureVaultAssociation.
        :type lifecycle_state_details: str

        :param time_created:
            The value to assign to the time_created property of this OracleDbAzureVaultAssociation.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OracleDbAzureVaultAssociation.
        :type time_updated: datetime

        :param last_modification:
            The value to assign to the last_modification property of this OracleDbAzureVaultAssociation.
        :type last_modification: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OracleDbAzureVaultAssociation.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OracleDbAzureVaultAssociation.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OracleDbAzureVaultAssociation.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'oracle_db_azure_connector_id': 'str',
            'oracle_db_azure_vault_id': 'str',
            'is_resource_accessible': 'bool',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'last_modification': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'oracle_db_azure_connector_id': 'oracleDbAzureConnectorId',
            'oracle_db_azure_vault_id': 'oracleDbAzureVaultId',
            'is_resource_accessible': 'isResourceAccessible',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'last_modification': 'lastModification',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._oracle_db_azure_connector_id = None
        self._oracle_db_azure_vault_id = None
        self._is_resource_accessible = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._time_created = None
        self._time_updated = None
        self._last_modification = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this OracleDbAzureVaultAssociation.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the compartment that contains Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the compartment that contains Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this OracleDbAzureVaultAssociation.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this OracleDbAzureVaultAssociation.
        Oracle DB Azure Vault Association resource name.


        :return: The display_name of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OracleDbAzureVaultAssociation.
        Oracle DB Azure Vault Association resource name.


        :param display_name: The display_name of this OracleDbAzureVaultAssociation.
        :type: str
        """
        self._display_name = display_name

    @property
    def oracle_db_azure_connector_id(self):
        """
        **[Required]** Gets the oracle_db_azure_connector_id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the Oracle DB Azure Connector that contains Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_azure_connector_id of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._oracle_db_azure_connector_id

    @oracle_db_azure_connector_id.setter
    def oracle_db_azure_connector_id(self, oracle_db_azure_connector_id):
        """
        Sets the oracle_db_azure_connector_id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the Oracle DB Azure Connector that contains Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_azure_connector_id: The oracle_db_azure_connector_id of this OracleDbAzureVaultAssociation.
        :type: str
        """
        self._oracle_db_azure_connector_id = oracle_db_azure_connector_id

    @property
    def oracle_db_azure_vault_id(self):
        """
        **[Required]** Gets the oracle_db_azure_vault_id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the Oracle DB Azure Vault that contains Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The oracle_db_azure_vault_id of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._oracle_db_azure_vault_id

    @oracle_db_azure_vault_id.setter
    def oracle_db_azure_vault_id(self, oracle_db_azure_vault_id):
        """
        Sets the oracle_db_azure_vault_id of this OracleDbAzureVaultAssociation.
        The `OCID`__ of the Oracle DB Azure Vault that contains Oracle DB Azure Vault Association resource.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param oracle_db_azure_vault_id: The oracle_db_azure_vault_id of this OracleDbAzureVaultAssociation.
        :type: str
        """
        self._oracle_db_azure_vault_id = oracle_db_azure_vault_id

    @property
    def is_resource_accessible(self):
        """
        Gets the is_resource_accessible of this OracleDbAzureVaultAssociation.
        The Associated resource is accessible or not.


        :return: The is_resource_accessible of this OracleDbAzureVaultAssociation.
        :rtype: bool
        """
        return self._is_resource_accessible

    @is_resource_accessible.setter
    def is_resource_accessible(self, is_resource_accessible):
        """
        Sets the is_resource_accessible of this OracleDbAzureVaultAssociation.
        The Associated resource is accessible or not.


        :param is_resource_accessible: The is_resource_accessible of this OracleDbAzureVaultAssociation.
        :type: bool
        """
        self._is_resource_accessible = is_resource_accessible

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OracleDbAzureVaultAssociation.
        The current lifecycle state of the Oracle DB Azure Vault Association resource.

        Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OracleDbAzureVaultAssociation.
        The current lifecycle state of the Oracle DB Azure Vault Association resource.


        :param lifecycle_state: The lifecycle_state of this OracleDbAzureVaultAssociation.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this OracleDbAzureVaultAssociation.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this OracleDbAzureVaultAssociation.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this OracleDbAzureVaultAssociation.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def time_created(self):
        """
        Gets the time_created of this OracleDbAzureVaultAssociation.
        Time when the Oracle DB Azure Vault Association resource was created in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this OracleDbAzureVaultAssociation.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OracleDbAzureVaultAssociation.
        Time when the Oracle DB Azure Vault Association resource was created in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this OracleDbAzureVaultAssociation.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this OracleDbAzureVaultAssociation.
        Time when the Oracle DB Azure Vault Association resource was last modified, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this OracleDbAzureVaultAssociation.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OracleDbAzureVaultAssociation.
        Time when the Oracle DB Azure Vault Association resource was last modified, expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this OracleDbAzureVaultAssociation.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def last_modification(self):
        """
        Gets the last_modification of this OracleDbAzureVaultAssociation.
        Description of the latest modification of the Oracle DB Azure Vault Association resource.


        :return: The last_modification of this OracleDbAzureVaultAssociation.
        :rtype: str
        """
        return self._last_modification

    @last_modification.setter
    def last_modification(self, last_modification):
        """
        Sets the last_modification of this OracleDbAzureVaultAssociation.
        Description of the latest modification of the Oracle DB Azure Vault Association resource.


        :param last_modification: The last_modification of this OracleDbAzureVaultAssociation.
        :type: str
        """
        self._last_modification = last_modification

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OracleDbAzureVaultAssociation.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this OracleDbAzureVaultAssociation.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OracleDbAzureVaultAssociation.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this OracleDbAzureVaultAssociation.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OracleDbAzureVaultAssociation.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this OracleDbAzureVaultAssociation.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OracleDbAzureVaultAssociation.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this OracleDbAzureVaultAssociation.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OracleDbAzureVaultAssociation.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OracleDbAzureVaultAssociation.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OracleDbAzureVaultAssociation.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OracleDbAzureVaultAssociation.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
