# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOracleDbGcpIdentityConnectorDetails(object):
    """
    This object is about to provide input params to create Oracle DB GCP Identity Connector resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOracleDbGcpIdentityConnectorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type display_name: str

        :param issuer_url:
            The value to assign to the issuer_url property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type issuer_url: str

        :param project_id:
            The value to assign to the project_id property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type project_id: str

        :param resource_id:
            The value to assign to the resource_id property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type resource_id: str

        :param gcp_location:
            The value to assign to the gcp_location property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type gcp_location: str

        :param gcp_workload_identity_pool_id:
            The value to assign to the gcp_workload_identity_pool_id property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type gcp_workload_identity_pool_id: str

        :param gcp_workload_identity_provider_id:
            The value to assign to the gcp_workload_identity_provider_id property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type gcp_workload_identity_provider_id: str

        :param gcp_resource_service_agent_id:
            The value to assign to the gcp_resource_service_agent_id property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type gcp_resource_service_agent_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'issuer_url': 'str',
            'project_id': 'str',
            'resource_id': 'str',
            'gcp_location': 'str',
            'gcp_workload_identity_pool_id': 'str',
            'gcp_workload_identity_provider_id': 'str',
            'gcp_resource_service_agent_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'issuer_url': 'issuerUrl',
            'project_id': 'projectId',
            'resource_id': 'resourceId',
            'gcp_location': 'gcpLocation',
            'gcp_workload_identity_pool_id': 'gcpWorkloadIdentityPoolId',
            'gcp_workload_identity_provider_id': 'gcpWorkloadIdentityProviderId',
            'gcp_resource_service_agent_id': 'gcpResourceServiceAgentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._issuer_url = None
        self._project_id = None
        self._resource_id = None
        self._gcp_location = None
        self._gcp_workload_identity_pool_id = None
        self._gcp_workload_identity_provider_id = None
        self._gcp_resource_service_agent_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateOracleDbGcpIdentityConnectorDetails.
        Oracle DB Google GCP Identity Connector resource name.


        :return: The display_name of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateOracleDbGcpIdentityConnectorDetails.
        Oracle DB Google GCP Identity Connector resource name.


        :param display_name: The display_name of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def issuer_url(self):
        """
        Gets the issuer_url of this UpdateOracleDbGcpIdentityConnectorDetails.
        OIDC token issuer Url


        :return: The issuer_url of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._issuer_url

    @issuer_url.setter
    def issuer_url(self, issuer_url):
        """
        Sets the issuer_url of this UpdateOracleDbGcpIdentityConnectorDetails.
        OIDC token issuer Url


        :param issuer_url: The issuer_url of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._issuer_url = issuer_url

    @property
    def project_id(self):
        """
        Gets the project_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        Project ID of the customer project.


        :return: The project_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        Project ID of the customer project.


        :param project_id: The project_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._project_id = project_id

    @property
    def resource_id(self):
        """
        Gets the resource_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The `OCID`__ of the GCP VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The `OCID`__ of the GCP VM Cluster resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def gcp_location(self):
        """
        Gets the gcp_location of this UpdateOracleDbGcpIdentityConnectorDetails.
        GCP Location.


        :return: The gcp_location of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._gcp_location

    @gcp_location.setter
    def gcp_location(self, gcp_location):
        """
        Sets the gcp_location of this UpdateOracleDbGcpIdentityConnectorDetails.
        GCP Location.


        :param gcp_location: The gcp_location of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._gcp_location = gcp_location

    @property
    def gcp_workload_identity_pool_id(self):
        """
        Gets the gcp_workload_identity_pool_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The ID of the cloud GCP Workload Identity Pool.


        :return: The gcp_workload_identity_pool_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._gcp_workload_identity_pool_id

    @gcp_workload_identity_pool_id.setter
    def gcp_workload_identity_pool_id(self, gcp_workload_identity_pool_id):
        """
        Sets the gcp_workload_identity_pool_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The ID of the cloud GCP Workload Identity Pool.


        :param gcp_workload_identity_pool_id: The gcp_workload_identity_pool_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._gcp_workload_identity_pool_id = gcp_workload_identity_pool_id

    @property
    def gcp_workload_identity_provider_id(self):
        """
        Gets the gcp_workload_identity_provider_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The ID of the GCP Workload Identity Provider.


        :return: The gcp_workload_identity_provider_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._gcp_workload_identity_provider_id

    @gcp_workload_identity_provider_id.setter
    def gcp_workload_identity_provider_id(self, gcp_workload_identity_provider_id):
        """
        Sets the gcp_workload_identity_provider_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The ID of the GCP Workload Identity Provider.


        :param gcp_workload_identity_provider_id: The gcp_workload_identity_provider_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._gcp_workload_identity_provider_id = gcp_workload_identity_provider_id

    @property
    def gcp_resource_service_agent_id(self):
        """
        Gets the gcp_resource_service_agent_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The ID of the GCP resource service agent.


        :return: The gcp_resource_service_agent_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: str
        """
        return self._gcp_resource_service_agent_id

    @gcp_resource_service_agent_id.setter
    def gcp_resource_service_agent_id(self, gcp_resource_service_agent_id):
        """
        Sets the gcp_resource_service_agent_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        The ID of the GCP resource service agent.


        :param gcp_resource_service_agent_id: The gcp_resource_service_agent_id of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: str
        """
        self._gcp_resource_service_agent_id = gcp_resource_service_agent_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateOracleDbGcpIdentityConnectorDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
