# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DelegatedResourceAccessRequestApprovalDetails(object):
    """
    Approval info for initial access or extension of a Delegated Resource Access Request
    """

    #: A constant which can be used with the approval_action property of a DelegatedResourceAccessRequestApprovalDetails.
    #: This constant has a value of "APPROVE"
    APPROVAL_ACTION_APPROVE = "APPROVE"

    #: A constant which can be used with the approval_action property of a DelegatedResourceAccessRequestApprovalDetails.
    #: This constant has a value of "REJECT"
    APPROVAL_ACTION_REJECT = "REJECT"

    #: A constant which can be used with the approval_type property of a DelegatedResourceAccessRequestApprovalDetails.
    #: This constant has a value of "INITIAL"
    APPROVAL_TYPE_INITIAL = "INITIAL"

    #: A constant which can be used with the approval_type property of a DelegatedResourceAccessRequestApprovalDetails.
    #: This constant has a value of "EXTENSION"
    APPROVAL_TYPE_EXTENSION = "EXTENSION"

    def __init__(self, **kwargs):
        """
        Initializes a new DelegatedResourceAccessRequestApprovalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param approval_action:
            The value to assign to the approval_action property of this DelegatedResourceAccessRequestApprovalDetails.
            Allowed values for this property are: "APPROVE", "REJECT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type approval_action: str

        :param time_approved_for_access:
            The value to assign to the time_approved_for_access property of this DelegatedResourceAccessRequestApprovalDetails.
        :type time_approved_for_access: datetime

        :param approval_type:
            The value to assign to the approval_type property of this DelegatedResourceAccessRequestApprovalDetails.
            Allowed values for this property are: "INITIAL", "EXTENSION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type approval_type: str

        :param approver_comment:
            The value to assign to the approver_comment property of this DelegatedResourceAccessRequestApprovalDetails.
        :type approver_comment: str

        :param approver_id:
            The value to assign to the approver_id property of this DelegatedResourceAccessRequestApprovalDetails.
        :type approver_id: str

        :param approver_additional_message:
            The value to assign to the approver_additional_message property of this DelegatedResourceAccessRequestApprovalDetails.
        :type approver_additional_message: str

        """
        self.swagger_types = {
            'approval_action': 'str',
            'time_approved_for_access': 'datetime',
            'approval_type': 'str',
            'approver_comment': 'str',
            'approver_id': 'str',
            'approver_additional_message': 'str'
        }
        self.attribute_map = {
            'approval_action': 'approvalAction',
            'time_approved_for_access': 'timeApprovedForAccess',
            'approval_type': 'approvalType',
            'approver_comment': 'approverComment',
            'approver_id': 'approverId',
            'approver_additional_message': 'approverAdditionalMessage'
        }
        self._approval_action = None
        self._time_approved_for_access = None
        self._approval_type = None
        self._approver_comment = None
        self._approver_id = None
        self._approver_additional_message = None

    @property
    def approval_action(self):
        """
        Gets the approval_action of this DelegatedResourceAccessRequestApprovalDetails.
        Indicated whether the request is approved or rejected.

        Allowed values for this property are: "APPROVE", "REJECT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The approval_action of this DelegatedResourceAccessRequestApprovalDetails.
        :rtype: str
        """
        return self._approval_action

    @approval_action.setter
    def approval_action(self, approval_action):
        """
        Sets the approval_action of this DelegatedResourceAccessRequestApprovalDetails.
        Indicated whether the request is approved or rejected.


        :param approval_action: The approval_action of this DelegatedResourceAccessRequestApprovalDetails.
        :type: str
        """
        allowed_values = ["APPROVE", "REJECT"]
        if not value_allowed_none_or_none_sentinel(approval_action, allowed_values):
            approval_action = 'UNKNOWN_ENUM_VALUE'
        self._approval_action = approval_action

    @property
    def time_approved_for_access(self):
        """
        Gets the time_approved_for_access of this DelegatedResourceAccessRequestApprovalDetails.
        Access start time that is actually approved by the customer in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_approved_for_access of this DelegatedResourceAccessRequestApprovalDetails.
        :rtype: datetime
        """
        return self._time_approved_for_access

    @time_approved_for_access.setter
    def time_approved_for_access(self, time_approved_for_access):
        """
        Sets the time_approved_for_access of this DelegatedResourceAccessRequestApprovalDetails.
        Access start time that is actually approved by the customer in `RFC 3339`__timestamp format, e.g. '2020-05-22T21:10:29.600Z'.

        __ https://tools.ietf.org/html/rfc3339


        :param time_approved_for_access: The time_approved_for_access of this DelegatedResourceAccessRequestApprovalDetails.
        :type: datetime
        """
        self._time_approved_for_access = time_approved_for_access

    @property
    def approval_type(self):
        """
        Gets the approval_type of this DelegatedResourceAccessRequestApprovalDetails.
        approval type, initial or extension

        Allowed values for this property are: "INITIAL", "EXTENSION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The approval_type of this DelegatedResourceAccessRequestApprovalDetails.
        :rtype: str
        """
        return self._approval_type

    @approval_type.setter
    def approval_type(self, approval_type):
        """
        Sets the approval_type of this DelegatedResourceAccessRequestApprovalDetails.
        approval type, initial or extension


        :param approval_type: The approval_type of this DelegatedResourceAccessRequestApprovalDetails.
        :type: str
        """
        allowed_values = ["INITIAL", "EXTENSION"]
        if not value_allowed_none_or_none_sentinel(approval_type, allowed_values):
            approval_type = 'UNKNOWN_ENUM_VALUE'
        self._approval_type = approval_type

    @property
    def approver_comment(self):
        """
        **[Required]** Gets the approver_comment of this DelegatedResourceAccessRequestApprovalDetails.
        Comment specified by the approver of the request.


        :return: The approver_comment of this DelegatedResourceAccessRequestApprovalDetails.
        :rtype: str
        """
        return self._approver_comment

    @approver_comment.setter
    def approver_comment(self, approver_comment):
        """
        Sets the approver_comment of this DelegatedResourceAccessRequestApprovalDetails.
        Comment specified by the approver of the request.


        :param approver_comment: The approver_comment of this DelegatedResourceAccessRequestApprovalDetails.
        :type: str
        """
        self._approver_comment = approver_comment

    @property
    def approver_id(self):
        """
        Gets the approver_id of this DelegatedResourceAccessRequestApprovalDetails.
        User ID of the approver.


        :return: The approver_id of this DelegatedResourceAccessRequestApprovalDetails.
        :rtype: str
        """
        return self._approver_id

    @approver_id.setter
    def approver_id(self, approver_id):
        """
        Sets the approver_id of this DelegatedResourceAccessRequestApprovalDetails.
        User ID of the approver.


        :param approver_id: The approver_id of this DelegatedResourceAccessRequestApprovalDetails.
        :type: str
        """
        self._approver_id = approver_id

    @property
    def approver_additional_message(self):
        """
        Gets the approver_additional_message of this DelegatedResourceAccessRequestApprovalDetails.
        Additional message specified by the approver of the request.


        :return: The approver_additional_message of this DelegatedResourceAccessRequestApprovalDetails.
        :rtype: str
        """
        return self._approver_additional_message

    @approver_additional_message.setter
    def approver_additional_message(self, approver_additional_message):
        """
        Sets the approver_additional_message of this DelegatedResourceAccessRequestApprovalDetails.
        Additional message specified by the approver of the request.


        :param approver_additional_message: The approver_additional_message of this DelegatedResourceAccessRequestApprovalDetails.
        :type: str
        """
        self._approver_additional_message = approver_additional_message

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
