# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MergePullRequestDetails(object):
    """
    determines if this is a merge or a validation.
    """

    #: A constant which can be used with the action_type property of a MergePullRequestDetails.
    #: This constant has a value of "EXECUTE"
    ACTION_TYPE_EXECUTE = "EXECUTE"

    #: A constant which can be used with the action_type property of a MergePullRequestDetails.
    #: This constant has a value of "VALIDATE"
    ACTION_TYPE_VALIDATE = "VALIDATE"

    def __init__(self, **kwargs):
        """
        Initializes a new MergePullRequestDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.devops.models.ExecuteMergePullRequestDetails`
        * :class:`~oci.devops.models.ValidateMergePullRequestDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_type:
            The value to assign to the action_type property of this MergePullRequestDetails.
            Allowed values for this property are: "EXECUTE", "VALIDATE"
        :type action_type: str

        """
        self.swagger_types = {
            'action_type': 'str'
        }
        self.attribute_map = {
            'action_type': 'actionType'
        }
        self._action_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['actionType']

        if type == 'EXECUTE':
            return 'ExecuteMergePullRequestDetails'

        if type == 'VALIDATE':
            return 'ValidateMergePullRequestDetails'
        else:
            return 'MergePullRequestDetails'

    @property
    def action_type(self):
        """
        **[Required]** Gets the action_type of this MergePullRequestDetails.
        the type of action for this merge.

        Allowed values for this property are: "EXECUTE", "VALIDATE"


        :return: The action_type of this MergePullRequestDetails.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """
        Sets the action_type of this MergePullRequestDetails.
        the type of action for this merge.


        :param action_type: The action_type of this MergePullRequestDetails.
        :type: str
        """
        allowed_values = ["EXECUTE", "VALIDATE"]
        if not value_allowed_none_or_none_sentinel(action_type, allowed_values):
            raise ValueError(
                f"Invalid value for `action_type`, must be None or one of {allowed_values}"
            )
        self._action_type = action_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
