# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrincipalDetails(object):
    """
    The principal details
    """

    #: A constant which can be used with the principal_type property of a PrincipalDetails.
    #: This constant has a value of "SERVICE"
    PRINCIPAL_TYPE_SERVICE = "SERVICE"

    #: A constant which can be used with the principal_type property of a PrincipalDetails.
    #: This constant has a value of "USER"
    PRINCIPAL_TYPE_USER = "USER"

    #: A constant which can be used with the principal_type property of a PrincipalDetails.
    #: This constant has a value of "INSTANCE"
    PRINCIPAL_TYPE_INSTANCE = "INSTANCE"

    #: A constant which can be used with the principal_type property of a PrincipalDetails.
    #: This constant has a value of "RESOURCE"
    PRINCIPAL_TYPE_RESOURCE = "RESOURCE"

    #: A constant which can be used with the principal_state property of a PrincipalDetails.
    #: This constant has a value of "ACTIVE"
    PRINCIPAL_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the principal_state property of a PrincipalDetails.
    #: This constant has a value of "INACTIVE"
    PRINCIPAL_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the principal_state property of a PrincipalDetails.
    #: This constant has a value of "SUPPRESSED"
    PRINCIPAL_STATE_SUPPRESSED = "SUPPRESSED"

    def __init__(self, **kwargs):
        """
        Initializes a new PrincipalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param principal_id:
            The value to assign to the principal_id property of this PrincipalDetails.
        :type principal_id: str

        :param principal_name:
            The value to assign to the principal_name property of this PrincipalDetails.
        :type principal_name: str

        :param principal_type:
            The value to assign to the principal_type property of this PrincipalDetails.
            Allowed values for this property are: "SERVICE", "USER", "INSTANCE", "RESOURCE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type principal_type: str

        :param principal_state:
            The value to assign to the principal_state property of this PrincipalDetails.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "SUPPRESSED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type principal_state: str

        """
        self.swagger_types = {
            'principal_id': 'str',
            'principal_name': 'str',
            'principal_type': 'str',
            'principal_state': 'str'
        }
        self.attribute_map = {
            'principal_id': 'principalId',
            'principal_name': 'principalName',
            'principal_type': 'principalType',
            'principal_state': 'principalState'
        }
        self._principal_id = None
        self._principal_name = None
        self._principal_type = None
        self._principal_state = None

    @property
    def principal_id(self):
        """
        **[Required]** Gets the principal_id of this PrincipalDetails.
        the OCID of the principal


        :return: The principal_id of this PrincipalDetails.
        :rtype: str
        """
        return self._principal_id

    @principal_id.setter
    def principal_id(self, principal_id):
        """
        Sets the principal_id of this PrincipalDetails.
        the OCID of the principal


        :param principal_id: The principal_id of this PrincipalDetails.
        :type: str
        """
        self._principal_id = principal_id

    @property
    def principal_name(self):
        """
        Gets the principal_name of this PrincipalDetails.
        the name of the principal


        :return: The principal_name of this PrincipalDetails.
        :rtype: str
        """
        return self._principal_name

    @principal_name.setter
    def principal_name(self, principal_name):
        """
        Sets the principal_name of this PrincipalDetails.
        the name of the principal


        :param principal_name: The principal_name of this PrincipalDetails.
        :type: str
        """
        self._principal_name = principal_name

    @property
    def principal_type(self):
        """
        Gets the principal_type of this PrincipalDetails.
        the type of principal

        Allowed values for this property are: "SERVICE", "USER", "INSTANCE", "RESOURCE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The principal_type of this PrincipalDetails.
        :rtype: str
        """
        return self._principal_type

    @principal_type.setter
    def principal_type(self, principal_type):
        """
        Sets the principal_type of this PrincipalDetails.
        the type of principal


        :param principal_type: The principal_type of this PrincipalDetails.
        :type: str
        """
        allowed_values = ["SERVICE", "USER", "INSTANCE", "RESOURCE"]
        if not value_allowed_none_or_none_sentinel(principal_type, allowed_values):
            principal_type = 'UNKNOWN_ENUM_VALUE'
        self._principal_type = principal_type

    @property
    def principal_state(self):
        """
        Gets the principal_state of this PrincipalDetails.
        The state of the principal, it can be active or inactive or suppressed for emails

        Allowed values for this property are: "ACTIVE", "INACTIVE", "SUPPRESSED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The principal_state of this PrincipalDetails.
        :rtype: str
        """
        return self._principal_state

    @principal_state.setter
    def principal_state(self, principal_state):
        """
        Sets the principal_state of this PrincipalDetails.
        The state of the principal, it can be active or inactive or suppressed for emails


        :param principal_state: The principal_state of this PrincipalDetails.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "SUPPRESSED"]
        if not value_allowed_none_or_none_sentinel(principal_state, allowed_values):
            principal_state = 'UNKNOWN_ENUM_VALUE'
        self._principal_state = principal_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
