# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddServiceDetails(object):
    """
    The configuration details for adding new services to the existing Stack.
    """

    #: A constant which can be used with the stack_templates property of a AddServiceDetails.
    #: This constant has a value of "DATALAKE"
    STACK_TEMPLATES_DATALAKE = "DATALAKE"

    #: A constant which can be used with the stack_templates property of a AddServiceDetails.
    #: This constant has a value of "DATAPIPELINE"
    STACK_TEMPLATES_DATAPIPELINE = "DATAPIPELINE"

    #: A constant which can be used with the stack_templates property of a AddServiceDetails.
    #: This constant has a value of "AISERVICES"
    STACK_TEMPLATES_AISERVICES = "AISERVICES"

    #: A constant which can be used with the stack_templates property of a AddServiceDetails.
    #: This constant has a value of "DATATRANSFORMATION"
    STACK_TEMPLATES_DATATRANSFORMATION = "DATATRANSFORMATION"

    #: A constant which can be used with the services property of a AddServiceDetails.
    #: This constant has a value of "ADB"
    SERVICES_ADB = "ADB"

    #: A constant which can be used with the services property of a AddServiceDetails.
    #: This constant has a value of "GGCS"
    SERVICES_GGCS = "GGCS"

    #: A constant which can be used with the services property of a AddServiceDetails.
    #: This constant has a value of "OBJECTSTORAGE"
    SERVICES_OBJECTSTORAGE = "OBJECTSTORAGE"

    #: A constant which can be used with the services property of a AddServiceDetails.
    #: This constant has a value of "GENAI"
    SERVICES_GENAI = "GENAI"

    #: A constant which can be used with the services property of a AddServiceDetails.
    #: This constant has a value of "DATAFLOW"
    SERVICES_DATAFLOW = "DATAFLOW"

    def __init__(self, **kwargs):
        """
        Initializes a new AddServiceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stack_templates:
            The value to assign to the stack_templates property of this AddServiceDetails.
            Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"
        :type stack_templates: list[str]

        :param services:
            The value to assign to the services property of this AddServiceDetails.
            Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"
        :type services: list[str]

        :param adb:
            The value to assign to the adb property of this AddServiceDetails.
        :type adb: list[oci.dif.models.AdbDetail]

        :param ggcs:
            The value to assign to the ggcs property of this AddServiceDetails.
        :type ggcs: list[oci.dif.models.GgcsDetail]

        :param dataflow:
            The value to assign to the dataflow property of this AddServiceDetails.
        :type dataflow: list[oci.dif.models.DataflowDetail]

        :param objectstorage:
            The value to assign to the objectstorage property of this AddServiceDetails.
        :type objectstorage: list[oci.dif.models.ObjectStorageDetail]

        :param genai:
            The value to assign to the genai property of this AddServiceDetails.
        :type genai: list[oci.dif.models.GenAiDetail]

        """
        self.swagger_types = {
            'stack_templates': 'list[str]',
            'services': 'list[str]',
            'adb': 'list[AdbDetail]',
            'ggcs': 'list[GgcsDetail]',
            'dataflow': 'list[DataflowDetail]',
            'objectstorage': 'list[ObjectStorageDetail]',
            'genai': 'list[GenAiDetail]'
        }
        self.attribute_map = {
            'stack_templates': 'stackTemplates',
            'services': 'services',
            'adb': 'adb',
            'ggcs': 'ggcs',
            'dataflow': 'dataflow',
            'objectstorage': 'objectstorage',
            'genai': 'genai'
        }
        self._stack_templates = None
        self._services = None
        self._adb = None
        self._ggcs = None
        self._dataflow = None
        self._objectstorage = None
        self._genai = None

    @property
    def stack_templates(self):
        """
        **[Required]** Gets the stack_templates of this AddServiceDetails.
        List of templates to be added for the stack.

        Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"


        :return: The stack_templates of this AddServiceDetails.
        :rtype: list[str]
        """
        return self._stack_templates

    @stack_templates.setter
    def stack_templates(self, stack_templates):
        """
        Sets the stack_templates of this AddServiceDetails.
        List of templates to be added for the stack.


        :param stack_templates: The stack_templates of this AddServiceDetails.
        :type: list[str]
        """
        allowed_values = ["DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"]

        if stack_templates and stack_templates is not NONE_SENTINEL:
            for value in stack_templates:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `stack_templates`, must be None or one of {allowed_values}"
                    )
        self._stack_templates = stack_templates

    @property
    def services(self):
        """
        **[Required]** Gets the services of this AddServiceDetails.
        List of services to be added for the stack.

        Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"


        :return: The services of this AddServiceDetails.
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this AddServiceDetails.
        List of services to be added for the stack.


        :param services: The services of this AddServiceDetails.
        :type: list[str]
        """
        allowed_values = ["ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"]

        if services and services is not NONE_SENTINEL:
            for value in services:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `services`, must be None or one of {allowed_values}"
                    )
        self._services = services

    @property
    def adb(self):
        """
        Gets the adb of this AddServiceDetails.
        ADB details if adb is included in the services to be added.


        :return: The adb of this AddServiceDetails.
        :rtype: list[oci.dif.models.AdbDetail]
        """
        return self._adb

    @adb.setter
    def adb(self, adb):
        """
        Sets the adb of this AddServiceDetails.
        ADB details if adb is included in the services to be added.


        :param adb: The adb of this AddServiceDetails.
        :type: list[oci.dif.models.AdbDetail]
        """
        self._adb = adb

    @property
    def ggcs(self):
        """
        Gets the ggcs of this AddServiceDetails.
        GGCS details if ggcs is included in the services to be added.


        :return: The ggcs of this AddServiceDetails.
        :rtype: list[oci.dif.models.GgcsDetail]
        """
        return self._ggcs

    @ggcs.setter
    def ggcs(self, ggcs):
        """
        Sets the ggcs of this AddServiceDetails.
        GGCS details if ggcs is included in the services to be added.


        :param ggcs: The ggcs of this AddServiceDetails.
        :type: list[oci.dif.models.GgcsDetail]
        """
        self._ggcs = ggcs

    @property
    def dataflow(self):
        """
        Gets the dataflow of this AddServiceDetails.
        DATAFLOW details if dataflow is included in the services to be added.


        :return: The dataflow of this AddServiceDetails.
        :rtype: list[oci.dif.models.DataflowDetail]
        """
        return self._dataflow

    @dataflow.setter
    def dataflow(self, dataflow):
        """
        Sets the dataflow of this AddServiceDetails.
        DATAFLOW details if dataflow is included in the services to be added.


        :param dataflow: The dataflow of this AddServiceDetails.
        :type: list[oci.dif.models.DataflowDetail]
        """
        self._dataflow = dataflow

    @property
    def objectstorage(self):
        """
        Gets the objectstorage of this AddServiceDetails.
        Object Storage Details if object storage is included in services to be added.


        :return: The objectstorage of this AddServiceDetails.
        :rtype: list[oci.dif.models.ObjectStorageDetail]
        """
        return self._objectstorage

    @objectstorage.setter
    def objectstorage(self, objectstorage):
        """
        Sets the objectstorage of this AddServiceDetails.
        Object Storage Details if object storage is included in services to be added.


        :param objectstorage: The objectstorage of this AddServiceDetails.
        :type: list[oci.dif.models.ObjectStorageDetail]
        """
        self._objectstorage = objectstorage

    @property
    def genai(self):
        """
        Gets the genai of this AddServiceDetails.
        GenAI Details if genai is included in services to be added.


        :return: The genai of this AddServiceDetails.
        :rtype: list[oci.dif.models.GenAiDetail]
        """
        return self._genai

    @genai.setter
    def genai(self, genai):
        """
        Sets the genai of this AddServiceDetails.
        GenAI Details if genai is included in services to be added.


        :param genai: The genai of this AddServiceDetails.
        :type: list[oci.dif.models.GenAiDetail]
        """
        self._genai = genai

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
