# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataflowUpdateDetail(object):
    """
    Details of the existing dataflow instance to be updated.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataflowUpdateDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this DataflowUpdateDetail.
        :type instance_id: str

        :param spark_version:
            The value to assign to the spark_version property of this DataflowUpdateDetail.
        :type spark_version: str

        :param driver_shape:
            The value to assign to the driver_shape property of this DataflowUpdateDetail.
        :type driver_shape: str

        :param executor_shape:
            The value to assign to the executor_shape property of this DataflowUpdateDetail.
        :type executor_shape: str

        :param driver_shape_config:
            The value to assign to the driver_shape_config property of this DataflowUpdateDetail.
        :type driver_shape_config: oci.dif.models.ShapeConfig

        :param executor_shape_config:
            The value to assign to the executor_shape_config property of this DataflowUpdateDetail.
        :type executor_shape_config: oci.dif.models.ShapeConfig

        :param num_executors:
            The value to assign to the num_executors property of this DataflowUpdateDetail.
        :type num_executors: int

        :param private_endpoint_id:
            The value to assign to the private_endpoint_id property of this DataflowUpdateDetail.
        :type private_endpoint_id: str

        :param connections:
            The value to assign to the connections property of this DataflowUpdateDetail.
        :type connections: oci.dif.models.UpdateDataflowConnections

        :param log_bucket_instance_id:
            The value to assign to the log_bucket_instance_id property of this DataflowUpdateDetail.
        :type log_bucket_instance_id: str

        :param warehouse_bucket_instance_id:
            The value to assign to the warehouse_bucket_instance_id property of this DataflowUpdateDetail.
        :type warehouse_bucket_instance_id: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'spark_version': 'str',
            'driver_shape': 'str',
            'executor_shape': 'str',
            'driver_shape_config': 'ShapeConfig',
            'executor_shape_config': 'ShapeConfig',
            'num_executors': 'int',
            'private_endpoint_id': 'str',
            'connections': 'UpdateDataflowConnections',
            'log_bucket_instance_id': 'str',
            'warehouse_bucket_instance_id': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'spark_version': 'sparkVersion',
            'driver_shape': 'driverShape',
            'executor_shape': 'executorShape',
            'driver_shape_config': 'driverShapeConfig',
            'executor_shape_config': 'executorShapeConfig',
            'num_executors': 'numExecutors',
            'private_endpoint_id': 'privateEndpointId',
            'connections': 'connections',
            'log_bucket_instance_id': 'logBucketInstanceId',
            'warehouse_bucket_instance_id': 'warehouseBucketInstanceId'
        }
        self._instance_id = None
        self._spark_version = None
        self._driver_shape = None
        self._executor_shape = None
        self._driver_shape_config = None
        self._executor_shape_config = None
        self._num_executors = None
        self._private_endpoint_id = None
        self._connections = None
        self._log_bucket_instance_id = None
        self._warehouse_bucket_instance_id = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this DataflowUpdateDetail.
        Instance id of the existing dataflow instance to be updated.


        :return: The instance_id of this DataflowUpdateDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this DataflowUpdateDetail.
        Instance id of the existing dataflow instance to be updated.


        :param instance_id: The instance_id of this DataflowUpdateDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def spark_version(self):
        """
        Gets the spark_version of this DataflowUpdateDetail.
        The Spark version utilized to run the application.


        :return: The spark_version of this DataflowUpdateDetail.
        :rtype: str
        """
        return self._spark_version

    @spark_version.setter
    def spark_version(self, spark_version):
        """
        Sets the spark_version of this DataflowUpdateDetail.
        The Spark version utilized to run the application.


        :param spark_version: The spark_version of this DataflowUpdateDetail.
        :type: str
        """
        self._spark_version = spark_version

    @property
    def driver_shape(self):
        """
        Gets the driver_shape of this DataflowUpdateDetail.
        The VM shape for the driver. Sets the driver cores and memory.


        :return: The driver_shape of this DataflowUpdateDetail.
        :rtype: str
        """
        return self._driver_shape

    @driver_shape.setter
    def driver_shape(self, driver_shape):
        """
        Sets the driver_shape of this DataflowUpdateDetail.
        The VM shape for the driver. Sets the driver cores and memory.


        :param driver_shape: The driver_shape of this DataflowUpdateDetail.
        :type: str
        """
        self._driver_shape = driver_shape

    @property
    def executor_shape(self):
        """
        Gets the executor_shape of this DataflowUpdateDetail.
        The VM shape for the executors. Sets the executor cores and memory.


        :return: The executor_shape of this DataflowUpdateDetail.
        :rtype: str
        """
        return self._executor_shape

    @executor_shape.setter
    def executor_shape(self, executor_shape):
        """
        Sets the executor_shape of this DataflowUpdateDetail.
        The VM shape for the executors. Sets the executor cores and memory.


        :param executor_shape: The executor_shape of this DataflowUpdateDetail.
        :type: str
        """
        self._executor_shape = executor_shape

    @property
    def driver_shape_config(self):
        """
        Gets the driver_shape_config of this DataflowUpdateDetail.

        :return: The driver_shape_config of this DataflowUpdateDetail.
        :rtype: oci.dif.models.ShapeConfig
        """
        return self._driver_shape_config

    @driver_shape_config.setter
    def driver_shape_config(self, driver_shape_config):
        """
        Sets the driver_shape_config of this DataflowUpdateDetail.

        :param driver_shape_config: The driver_shape_config of this DataflowUpdateDetail.
        :type: oci.dif.models.ShapeConfig
        """
        self._driver_shape_config = driver_shape_config

    @property
    def executor_shape_config(self):
        """
        Gets the executor_shape_config of this DataflowUpdateDetail.

        :return: The executor_shape_config of this DataflowUpdateDetail.
        :rtype: oci.dif.models.ShapeConfig
        """
        return self._executor_shape_config

    @executor_shape_config.setter
    def executor_shape_config(self, executor_shape_config):
        """
        Sets the executor_shape_config of this DataflowUpdateDetail.

        :param executor_shape_config: The executor_shape_config of this DataflowUpdateDetail.
        :type: oci.dif.models.ShapeConfig
        """
        self._executor_shape_config = executor_shape_config

    @property
    def num_executors(self):
        """
        Gets the num_executors of this DataflowUpdateDetail.
        The number of executor VMs requested.


        :return: The num_executors of this DataflowUpdateDetail.
        :rtype: int
        """
        return self._num_executors

    @num_executors.setter
    def num_executors(self, num_executors):
        """
        Sets the num_executors of this DataflowUpdateDetail.
        The number of executor VMs requested.


        :param num_executors: The num_executors of this DataflowUpdateDetail.
        :type: int
        """
        self._num_executors = num_executors

    @property
    def private_endpoint_id(self):
        """
        Gets the private_endpoint_id of this DataflowUpdateDetail.
        OCID of the already provisioned dataflow private endpoint.


        :return: The private_endpoint_id of this DataflowUpdateDetail.
        :rtype: str
        """
        return self._private_endpoint_id

    @private_endpoint_id.setter
    def private_endpoint_id(self, private_endpoint_id):
        """
        Sets the private_endpoint_id of this DataflowUpdateDetail.
        OCID of the already provisioned dataflow private endpoint.


        :param private_endpoint_id: The private_endpoint_id of this DataflowUpdateDetail.
        :type: str
        """
        self._private_endpoint_id = private_endpoint_id

    @property
    def connections(self):
        """
        Gets the connections of this DataflowUpdateDetail.

        :return: The connections of this DataflowUpdateDetail.
        :rtype: oci.dif.models.UpdateDataflowConnections
        """
        return self._connections

    @connections.setter
    def connections(self, connections):
        """
        Sets the connections of this DataflowUpdateDetail.

        :param connections: The connections of this DataflowUpdateDetail.
        :type: oci.dif.models.UpdateDataflowConnections
        """
        self._connections = connections

    @property
    def log_bucket_instance_id(self):
        """
        Gets the log_bucket_instance_id of this DataflowUpdateDetail.
        InstanceId of log bucket created as part of objectstorage service in stack. Used for storing application run logs.


        :return: The log_bucket_instance_id of this DataflowUpdateDetail.
        :rtype: str
        """
        return self._log_bucket_instance_id

    @log_bucket_instance_id.setter
    def log_bucket_instance_id(self, log_bucket_instance_id):
        """
        Sets the log_bucket_instance_id of this DataflowUpdateDetail.
        InstanceId of log bucket created as part of objectstorage service in stack. Used for storing application run logs.


        :param log_bucket_instance_id: The log_bucket_instance_id of this DataflowUpdateDetail.
        :type: str
        """
        self._log_bucket_instance_id = log_bucket_instance_id

    @property
    def warehouse_bucket_instance_id(self):
        """
        Gets the warehouse_bucket_instance_id of this DataflowUpdateDetail.
        InstanceId of warehouse bucket created as part of objectstorage service in stack. Mandatory for SQL applications.


        :return: The warehouse_bucket_instance_id of this DataflowUpdateDetail.
        :rtype: str
        """
        return self._warehouse_bucket_instance_id

    @warehouse_bucket_instance_id.setter
    def warehouse_bucket_instance_id(self, warehouse_bucket_instance_id):
        """
        Sets the warehouse_bucket_instance_id of this DataflowUpdateDetail.
        InstanceId of warehouse bucket created as part of objectstorage service in stack. Mandatory for SQL applications.


        :param warehouse_bucket_instance_id: The warehouse_bucket_instance_id of this DataflowUpdateDetail.
        :type: str
        """
        self._warehouse_bucket_instance_id = warehouse_bucket_instance_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
