# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeployArtifactsDetails(object):
    """
    The data to create a DataIntelligence.
    """

    #: A constant which can be used with the stack_templates property of a DeployArtifactsDetails.
    #: This constant has a value of "DATALAKE"
    STACK_TEMPLATES_DATALAKE = "DATALAKE"

    #: A constant which can be used with the stack_templates property of a DeployArtifactsDetails.
    #: This constant has a value of "DATAPIPELINE"
    STACK_TEMPLATES_DATAPIPELINE = "DATAPIPELINE"

    #: A constant which can be used with the stack_templates property of a DeployArtifactsDetails.
    #: This constant has a value of "AISERVICES"
    STACK_TEMPLATES_AISERVICES = "AISERVICES"

    #: A constant which can be used with the stack_templates property of a DeployArtifactsDetails.
    #: This constant has a value of "DATATRANSFORMATION"
    STACK_TEMPLATES_DATATRANSFORMATION = "DATATRANSFORMATION"

    #: A constant which can be used with the services property of a DeployArtifactsDetails.
    #: This constant has a value of "ADB"
    SERVICES_ADB = "ADB"

    #: A constant which can be used with the services property of a DeployArtifactsDetails.
    #: This constant has a value of "GGCS"
    SERVICES_GGCS = "GGCS"

    #: A constant which can be used with the services property of a DeployArtifactsDetails.
    #: This constant has a value of "OBJECTSTORAGE"
    SERVICES_OBJECTSTORAGE = "OBJECTSTORAGE"

    #: A constant which can be used with the services property of a DeployArtifactsDetails.
    #: This constant has a value of "GENAI"
    SERVICES_GENAI = "GENAI"

    #: A constant which can be used with the services property of a DeployArtifactsDetails.
    #: This constant has a value of "DATAFLOW"
    SERVICES_DATAFLOW = "DATAFLOW"

    def __init__(self, **kwargs):
        """
        Initializes a new DeployArtifactsDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stack_templates:
            The value to assign to the stack_templates property of this DeployArtifactsDetails.
            Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"
        :type stack_templates: list[str]

        :param services:
            The value to assign to the services property of this DeployArtifactsDetails.
            Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"
        :type services: list[str]

        :param subnet_id:
            The value to assign to the subnet_id property of this DeployArtifactsDetails.
        :type subnet_id: str

        :param adb:
            The value to assign to the adb property of this DeployArtifactsDetails.
        :type adb: list[oci.dif.models.AdbArtifactsDetail]

        :param ggcs:
            The value to assign to the ggcs property of this DeployArtifactsDetails.
        :type ggcs: list[oci.dif.models.GgcsArtifactsDetail]

        :param dataflow:
            The value to assign to the dataflow property of this DeployArtifactsDetails.
        :type dataflow: list[oci.dif.models.DataflowArtifactsDetail]

        """
        self.swagger_types = {
            'stack_templates': 'list[str]',
            'services': 'list[str]',
            'subnet_id': 'str',
            'adb': 'list[AdbArtifactsDetail]',
            'ggcs': 'list[GgcsArtifactsDetail]',
            'dataflow': 'list[DataflowArtifactsDetail]'
        }
        self.attribute_map = {
            'stack_templates': 'stackTemplates',
            'services': 'services',
            'subnet_id': 'subnetId',
            'adb': 'adb',
            'ggcs': 'ggcs',
            'dataflow': 'dataflow'
        }
        self._stack_templates = None
        self._services = None
        self._subnet_id = None
        self._adb = None
        self._ggcs = None
        self._dataflow = None

    @property
    def stack_templates(self):
        """
        **[Required]** Gets the stack_templates of this DeployArtifactsDetails.
        List of templates to be onboarded for the stack.

        Allowed values for items in this list are: "DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"


        :return: The stack_templates of this DeployArtifactsDetails.
        :rtype: list[str]
        """
        return self._stack_templates

    @stack_templates.setter
    def stack_templates(self, stack_templates):
        """
        Sets the stack_templates of this DeployArtifactsDetails.
        List of templates to be onboarded for the stack.


        :param stack_templates: The stack_templates of this DeployArtifactsDetails.
        :type: list[str]
        """
        allowed_values = ["DATALAKE", "DATAPIPELINE", "AISERVICES", "DATATRANSFORMATION"]

        if stack_templates and stack_templates is not NONE_SENTINEL:
            for value in stack_templates:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `stack_templates`, must be None or one of {allowed_values}"
                    )
        self._stack_templates = stack_templates

    @property
    def services(self):
        """
        **[Required]** Gets the services of this DeployArtifactsDetails.
        List of services to be onboarded for the stack.

        Allowed values for items in this list are: "ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"


        :return: The services of this DeployArtifactsDetails.
        :rtype: list[str]
        """
        return self._services

    @services.setter
    def services(self, services):
        """
        Sets the services of this DeployArtifactsDetails.
        List of services to be onboarded for the stack.


        :param services: The services of this DeployArtifactsDetails.
        :type: list[str]
        """
        allowed_values = ["ADB", "GGCS", "OBJECTSTORAGE", "GENAI", "DATAFLOW"]

        if services and services is not NONE_SENTINEL:
            for value in services:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `services`, must be None or one of {allowed_values}"
                    )
        self._services = services

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this DeployArtifactsDetails.
        Subnet id for the Private Endpoint creation for artifact deployment.


        :return: The subnet_id of this DeployArtifactsDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this DeployArtifactsDetails.
        Subnet id for the Private Endpoint creation for artifact deployment.


        :param subnet_id: The subnet_id of this DeployArtifactsDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def adb(self):
        """
        Gets the adb of this DeployArtifactsDetails.
        ADB artifact details if adb is included in the services.


        :return: The adb of this DeployArtifactsDetails.
        :rtype: list[oci.dif.models.AdbArtifactsDetail]
        """
        return self._adb

    @adb.setter
    def adb(self, adb):
        """
        Sets the adb of this DeployArtifactsDetails.
        ADB artifact details if adb is included in the services.


        :param adb: The adb of this DeployArtifactsDetails.
        :type: list[oci.dif.models.AdbArtifactsDetail]
        """
        self._adb = adb

    @property
    def ggcs(self):
        """
        Gets the ggcs of this DeployArtifactsDetails.
        GGCS artifact details if ggcs is included in the services.


        :return: The ggcs of this DeployArtifactsDetails.
        :rtype: list[oci.dif.models.GgcsArtifactsDetail]
        """
        return self._ggcs

    @ggcs.setter
    def ggcs(self, ggcs):
        """
        Sets the ggcs of this DeployArtifactsDetails.
        GGCS artifact details if ggcs is included in the services.


        :param ggcs: The ggcs of this DeployArtifactsDetails.
        :type: list[oci.dif.models.GgcsArtifactsDetail]
        """
        self._ggcs = ggcs

    @property
    def dataflow(self):
        """
        Gets the dataflow of this DeployArtifactsDetails.
        Dataflow artifact details if dataflow is included in the services.


        :return: The dataflow of this DeployArtifactsDetails.
        :rtype: list[oci.dif.models.DataflowArtifactsDetail]
        """
        return self._dataflow

    @dataflow.setter
    def dataflow(self, dataflow):
        """
        Sets the dataflow of this DeployArtifactsDetails.
        Dataflow artifact details if dataflow is included in the services.


        :param dataflow: The dataflow of this DeployArtifactsDetails.
        :type: list[oci.dif.models.DataflowArtifactsDetail]
        """
        self._dataflow = dataflow

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
