# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceDetailResponse(object):
    """
    Details of the cloud service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceDetailResponse object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this ServiceDetailResponse.
        :type instance_id: str

        :param service_id:
            The value to assign to the service_id property of this ServiceDetailResponse.
        :type service_id: str

        :param display_name:
            The value to assign to the display_name property of this ServiceDetailResponse.
        :type display_name: str

        :param current_artifact_path:
            The value to assign to the current_artifact_path property of this ServiceDetailResponse.
        :type current_artifact_path: str

        :param service_type:
            The value to assign to the service_type property of this ServiceDetailResponse.
        :type service_type: str

        :param service_url:
            The value to assign to the service_url property of this ServiceDetailResponse.
        :type service_url: str

        :param status:
            The value to assign to the status property of this ServiceDetailResponse.
        :type status: str

        :param additional_details:
            The value to assign to the additional_details property of this ServiceDetailResponse.
        :type additional_details: oci.dif.models.AdditionalDetails

        """
        self.swagger_types = {
            'instance_id': 'str',
            'service_id': 'str',
            'display_name': 'str',
            'current_artifact_path': 'str',
            'service_type': 'str',
            'service_url': 'str',
            'status': 'str',
            'additional_details': 'AdditionalDetails'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'service_id': 'serviceId',
            'display_name': 'displayName',
            'current_artifact_path': 'currentArtifactPath',
            'service_type': 'serviceType',
            'service_url': 'serviceUrl',
            'status': 'status',
            'additional_details': 'additionalDetails'
        }
        self._instance_id = None
        self._service_id = None
        self._display_name = None
        self._current_artifact_path = None
        self._service_type = None
        self._service_url = None
        self._status = None
        self._additional_details = None

    @property
    def instance_id(self):
        """
        Gets the instance_id of this ServiceDetailResponse.
        ID for the service instance.


        :return: The instance_id of this ServiceDetailResponse.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this ServiceDetailResponse.
        ID for the service instance.


        :param instance_id: The instance_id of this ServiceDetailResponse.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def service_id(self):
        """
        Gets the service_id of this ServiceDetailResponse.
        ID for the service


        :return: The service_id of this ServiceDetailResponse.
        :rtype: str
        """
        return self._service_id

    @service_id.setter
    def service_id(self, service_id):
        """
        Sets the service_id of this ServiceDetailResponse.
        ID for the service


        :param service_id: The service_id of this ServiceDetailResponse.
        :type: str
        """
        self._service_id = service_id

    @property
    def display_name(self):
        """
        Gets the display_name of this ServiceDetailResponse.
        name of the service


        :return: The display_name of this ServiceDetailResponse.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ServiceDetailResponse.
        name of the service


        :param display_name: The display_name of this ServiceDetailResponse.
        :type: str
        """
        self._display_name = display_name

    @property
    def current_artifact_path(self):
        """
        Gets the current_artifact_path of this ServiceDetailResponse.
        name of the service


        :return: The current_artifact_path of this ServiceDetailResponse.
        :rtype: str
        """
        return self._current_artifact_path

    @current_artifact_path.setter
    def current_artifact_path(self, current_artifact_path):
        """
        Sets the current_artifact_path of this ServiceDetailResponse.
        name of the service


        :param current_artifact_path: The current_artifact_path of this ServiceDetailResponse.
        :type: str
        """
        self._current_artifact_path = current_artifact_path

    @property
    def service_type(self):
        """
        Gets the service_type of this ServiceDetailResponse.
        name of the cloud service


        :return: The service_type of this ServiceDetailResponse.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this ServiceDetailResponse.
        name of the cloud service


        :param service_type: The service_type of this ServiceDetailResponse.
        :type: str
        """
        self._service_type = service_type

    @property
    def service_url(self):
        """
        Gets the service_url of this ServiceDetailResponse.
        url for the service


        :return: The service_url of this ServiceDetailResponse.
        :rtype: str
        """
        return self._service_url

    @service_url.setter
    def service_url(self, service_url):
        """
        Sets the service_url of this ServiceDetailResponse.
        url for the service


        :param service_url: The service_url of this ServiceDetailResponse.
        :type: str
        """
        self._service_url = service_url

    @property
    def status(self):
        """
        Gets the status of this ServiceDetailResponse.
        state of the service


        :return: The status of this ServiceDetailResponse.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ServiceDetailResponse.
        state of the service


        :param status: The status of this ServiceDetailResponse.
        :type: str
        """
        self._status = status

    @property
    def additional_details(self):
        """
        Gets the additional_details of this ServiceDetailResponse.

        :return: The additional_details of this ServiceDetailResponse.
        :rtype: oci.dif.models.AdditionalDetails
        """
        return self._additional_details

    @additional_details.setter
    def additional_details(self, additional_details):
        """
        Sets the additional_details of this ServiceDetailResponse.

        :param additional_details: The additional_details of this ServiceDetailResponse.
        :type: oci.dif.models.AdditionalDetails
        """
        self._additional_details = additional_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
