# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DrPlanExecutionWarningStepStatusCounts(object):
    """
    A summary of steps that encountered warnings during a DR plan execution.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DrPlanExecutionWarningStepStatusCounts object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_warnings:
            The value to assign to the total_warnings property of this DrPlanExecutionWarningStepStatusCounts.
        :type total_warnings: int

        :param warnings_ignored:
            The value to assign to the warnings_ignored property of this DrPlanExecutionWarningStepStatusCounts.
        :type warnings_ignored: int

        """
        self.swagger_types = {
            'total_warnings': 'int',
            'warnings_ignored': 'int'
        }
        self.attribute_map = {
            'total_warnings': 'totalWarnings',
            'warnings_ignored': 'warningsIgnored'
        }
        self._total_warnings = None
        self._warnings_ignored = None

    @property
    def total_warnings(self):
        """
        **[Required]** Gets the total_warnings of this DrPlanExecutionWarningStepStatusCounts.
        The total number of steps that encountered warnings in a DR plan execution.


        :return: The total_warnings of this DrPlanExecutionWarningStepStatusCounts.
        :rtype: int
        """
        return self._total_warnings

    @total_warnings.setter
    def total_warnings(self, total_warnings):
        """
        Sets the total_warnings of this DrPlanExecutionWarningStepStatusCounts.
        The total number of steps that encountered warnings in a DR plan execution.


        :param total_warnings: The total_warnings of this DrPlanExecutionWarningStepStatusCounts.
        :type: int
        """
        self._total_warnings = total_warnings

    @property
    def warnings_ignored(self):
        """
        **[Required]** Gets the warnings_ignored of this DrPlanExecutionWarningStepStatusCounts.
        The total number of steps with warnings that were ignored during a DR plan execution.


        :return: The warnings_ignored of this DrPlanExecutionWarningStepStatusCounts.
        :rtype: int
        """
        return self._warnings_ignored

    @warnings_ignored.setter
    def warnings_ignored(self, warnings_ignored):
        """
        Sets the warnings_ignored of this DrPlanExecutionWarningStepStatusCounts.
        The total number of steps with warnings that were ignored during a DR plan execution.


        :param warnings_ignored: The warnings_ignored of this DrPlanExecutionWarningStepStatusCounts.
        :type: int
        """
        self._warnings_ignored = warnings_ignored

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
