# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateComputeInstanceNonMovableBlockVolumeOperationDetails(object):
    """
    Deprecated. Use the 'UpdateComputeInstanceNonMovableBlockVolumeAttachAndMountOperationsDetails' definition instead of this.
    The details for updating the operations performed on a block volume.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateComputeInstanceNonMovableBlockVolumeOperationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param block_volume_id:
            The value to assign to the block_volume_id property of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :type block_volume_id: str

        :param attachment_details:
            The value to assign to the attachment_details property of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :type attachment_details: oci.disaster_recovery.models.UpdateBlockVolumeAttachmentDetails

        :param mount_details:
            The value to assign to the mount_details property of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :type mount_details: oci.disaster_recovery.models.UpdateBlockVolumeMountDetails

        """
        self.swagger_types = {
            'block_volume_id': 'str',
            'attachment_details': 'UpdateBlockVolumeAttachmentDetails',
            'mount_details': 'UpdateBlockVolumeMountDetails'
        }
        self.attribute_map = {
            'block_volume_id': 'blockVolumeId',
            'attachment_details': 'attachmentDetails',
            'mount_details': 'mountDetails'
        }
        self._block_volume_id = None
        self._attachment_details = None
        self._mount_details = None

    @property
    def block_volume_id(self):
        """
        **[Required]** Gets the block_volume_id of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        The OCID of the block volume.

        Example: `ocid1.volume.oc1..uniqueID`


        :return: The block_volume_id of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :rtype: str
        """
        return self._block_volume_id

    @block_volume_id.setter
    def block_volume_id(self, block_volume_id):
        """
        Sets the block_volume_id of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        The OCID of the block volume.

        Example: `ocid1.volume.oc1..uniqueID`


        :param block_volume_id: The block_volume_id of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :type: str
        """
        self._block_volume_id = block_volume_id

    @property
    def attachment_details(self):
        """
        Gets the attachment_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.

        :return: The attachment_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :rtype: oci.disaster_recovery.models.UpdateBlockVolumeAttachmentDetails
        """
        return self._attachment_details

    @attachment_details.setter
    def attachment_details(self, attachment_details):
        """
        Sets the attachment_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.

        :param attachment_details: The attachment_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :type: oci.disaster_recovery.models.UpdateBlockVolumeAttachmentDetails
        """
        self._attachment_details = attachment_details

    @property
    def mount_details(self):
        """
        Gets the mount_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.

        :return: The mount_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :rtype: oci.disaster_recovery.models.UpdateBlockVolumeMountDetails
        """
        return self._mount_details

    @mount_details.setter
    def mount_details(self, mount_details):
        """
        Sets the mount_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.

        :param mount_details: The mount_details of this UpdateComputeInstanceNonMovableBlockVolumeOperationDetails.
        :type: oci.disaster_recovery.models.UpdateBlockVolumeMountDetails
        """
        self._mount_details = mount_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
