# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170907


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EmailOutboundIpSummary(object):
    """
    Summary of the Outbound IP address assigned to the tenancy.
    """

    #: A constant which can be used with the lifecycle_state property of a EmailOutboundIpSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a EmailOutboundIpSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a EmailOutboundIpSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a EmailOutboundIpSummary.
    #: This constant has a value of "DRAINING"
    LIFECYCLE_STATE_DRAINING = "DRAINING"

    #: A constant which can be used with the assignment_state property of a EmailOutboundIpSummary.
    #: This constant has a value of "AVAILABLE"
    ASSIGNMENT_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the assignment_state property of a EmailOutboundIpSummary.
    #: This constant has a value of "ASSIGNED"
    ASSIGNMENT_STATE_ASSIGNED = "ASSIGNED"

    def __init__(self, **kwargs):
        """
        Initializes a new EmailOutboundIpSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param outbound_ip:
            The value to assign to the outbound_ip property of this EmailOutboundIpSummary.
        :type outbound_ip: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this EmailOutboundIpSummary.
            Allowed values for this property are: "UPDATING", "ACTIVE", "FAILED", "DRAINING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this EmailOutboundIpSummary.
        :type lifecycle_details: str

        :param assignment_state:
            The value to assign to the assignment_state property of this EmailOutboundIpSummary.
            Allowed values for this property are: "AVAILABLE", "ASSIGNED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type assignment_state: str

        """
        self.swagger_types = {
            'outbound_ip': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'assignment_state': 'str'
        }
        self.attribute_map = {
            'outbound_ip': 'outboundIp',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'assignment_state': 'assignmentState'
        }
        self._outbound_ip = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._assignment_state = None

    @property
    def outbound_ip(self):
        """
        **[Required]** Gets the outbound_ip of this EmailOutboundIpSummary.
        The public IP address assigned to the tenancy.


        :return: The outbound_ip of this EmailOutboundIpSummary.
        :rtype: str
        """
        return self._outbound_ip

    @outbound_ip.setter
    def outbound_ip(self, outbound_ip):
        """
        Sets the outbound_ip of this EmailOutboundIpSummary.
        The public IP address assigned to the tenancy.


        :param outbound_ip: The outbound_ip of this EmailOutboundIpSummary.
        :type: str
        """
        self._outbound_ip = outbound_ip

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this EmailOutboundIpSummary.
        The current state of the Email Outbound Public IP.

        Allowed values for this property are: "UPDATING", "ACTIVE", "FAILED", "DRAINING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this EmailOutboundIpSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this EmailOutboundIpSummary.
        The current state of the Email Outbound Public IP.


        :param lifecycle_state: The lifecycle_state of this EmailOutboundIpSummary.
        :type: str
        """
        allowed_values = ["UPDATING", "ACTIVE", "FAILED", "DRAINING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this EmailOutboundIpSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a
        resource in 'DRAINING' state.


        :return: The lifecycle_details of this EmailOutboundIpSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this EmailOutboundIpSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a
        resource in 'DRAINING' state.


        :param lifecycle_details: The lifecycle_details of this EmailOutboundIpSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def assignment_state(self):
        """
        **[Required]** Gets the assignment_state of this EmailOutboundIpSummary.
        The assignment state of the public IP address.

        Allowed values for this property are: "AVAILABLE", "ASSIGNED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The assignment_state of this EmailOutboundIpSummary.
        :rtype: str
        """
        return self._assignment_state

    @assignment_state.setter
    def assignment_state(self, assignment_state):
        """
        Sets the assignment_state of this EmailOutboundIpSummary.
        The assignment state of the public IP address.


        :param assignment_state: The assignment_state of this EmailOutboundIpSummary.
        :type: str
        """
        allowed_values = ["AVAILABLE", "ASSIGNED"]
        if not value_allowed_none_or_none_sentinel(assignment_state, allowed_values):
            assignment_state = 'UNKNOWN_ENUM_VALUE'
        self._assignment_state = assignment_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
