# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogItemVariablesDefinition(object):
    """
    Variables Definitions for a CatalogItem.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogItemVariablesDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param schema_document:
            The value to assign to the schema_document property of this CatalogItemVariablesDefinition.
        :type schema_document: oci.fleet_apps_management.models.SchemaDocument

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CatalogItemVariablesDefinition.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CatalogItemVariablesDefinition.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CatalogItemVariablesDefinition.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'schema_document': 'SchemaDocument',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'schema_document': 'schemaDocument',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._schema_document = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def schema_document(self):
        """
        **[Required]** Gets the schema_document of this CatalogItemVariablesDefinition.

        :return: The schema_document of this CatalogItemVariablesDefinition.
        :rtype: oci.fleet_apps_management.models.SchemaDocument
        """
        return self._schema_document

    @schema_document.setter
    def schema_document(self, schema_document):
        """
        Sets the schema_document of this CatalogItemVariablesDefinition.

        :param schema_document: The schema_document of this CatalogItemVariablesDefinition.
        :type: oci.fleet_apps_management.models.SchemaDocument
        """
        self._schema_document = schema_document

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CatalogItemVariablesDefinition.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CatalogItemVariablesDefinition.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CatalogItemVariablesDefinition.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CatalogItemVariablesDefinition.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CatalogItemVariablesDefinition.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CatalogItemVariablesDefinition.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CatalogItemVariablesDefinition.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CatalogItemVariablesDefinition.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CatalogItemVariablesDefinition.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this CatalogItemVariablesDefinition.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CatalogItemVariablesDefinition.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this CatalogItemVariablesDefinition.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
