# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .catalog_source_payload import CatalogSourcePayload
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogMarketplaceSourceConfig(CatalogSourcePayload):
    """
    Catalog market source config.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogMarketplaceSourceConfig object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.CatalogMarketplaceSourceConfig.config_source_type` attribute
        of this class is ``MARKETPLACE_CATALOG_SOURCE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_source_type:
            The value to assign to the config_source_type property of this CatalogMarketplaceSourceConfig.
        :type config_source_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogMarketplaceSourceConfig.
        :type working_directory: str

        :param listing_id:
            The value to assign to the listing_id property of this CatalogMarketplaceSourceConfig.
        :type listing_id: str

        :param version:
            The value to assign to the version property of this CatalogMarketplaceSourceConfig.
        :type version: str

        """
        self.swagger_types = {
            'config_source_type': 'str',
            'working_directory': 'str',
            'listing_id': 'str',
            'version': 'str'
        }
        self.attribute_map = {
            'config_source_type': 'configSourceType',
            'working_directory': 'workingDirectory',
            'listing_id': 'listingId',
            'version': 'version'
        }
        self._config_source_type = None
        self._working_directory = None
        self._listing_id = None
        self._version = None
        self._config_source_type = 'MARKETPLACE_CATALOG_SOURCE'

    @property
    def listing_id(self):
        """
        Gets the listing_id of this CatalogMarketplaceSourceConfig.
        This listing Id parameter of Payload.


        :return: The listing_id of this CatalogMarketplaceSourceConfig.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this CatalogMarketplaceSourceConfig.
        This listing Id parameter of Payload.


        :param listing_id: The listing_id of this CatalogMarketplaceSourceConfig.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def version(self):
        """
        Gets the version of this CatalogMarketplaceSourceConfig.
        This version parameter of Payload.


        :return: The version of this CatalogMarketplaceSourceConfig.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this CatalogMarketplaceSourceConfig.
        This version parameter of Payload.


        :param version: The version of this CatalogMarketplaceSourceConfig.
        :type: str
        """
        self._version = version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
