# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CatalogSourcePayload(object):
    """
    Catalog source payload.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CatalogSourcePayload object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.CatalogGitSourceConfig`
        * :class:`~oci.fleet_apps_management.models.CatalogSourceTemplateConfig`
        * :class:`~oci.fleet_apps_management.models.CatalogParSourceConfig`
        * :class:`~oci.fleet_apps_management.models.CatalogMarketplaceSourceConfig`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_source_type:
            The value to assign to the config_source_type property of this CatalogSourcePayload.
        :type config_source_type: str

        :param working_directory:
            The value to assign to the working_directory property of this CatalogSourcePayload.
        :type working_directory: str

        """
        self.swagger_types = {
            'config_source_type': 'str',
            'working_directory': 'str'
        }
        self.attribute_map = {
            'config_source_type': 'configSourceType',
            'working_directory': 'workingDirectory'
        }
        self._config_source_type = None
        self._working_directory = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['configSourceType']

        if type == 'GIT_CATALOG_SOURCE':
            return 'CatalogGitSourceConfig'

        if type == 'STACK_TEMPLATE_CATALOG_SOURCE':
            return 'CatalogSourceTemplateConfig'

        if type == 'PAR_CATALOG_SOURCE':
            return 'CatalogParSourceConfig'

        if type == 'MARKETPLACE_CATALOG_SOURCE':
            return 'CatalogMarketplaceSourceConfig'
        else:
            return 'CatalogSourcePayload'

    @property
    def config_source_type(self):
        """
        **[Required]** Gets the config_source_type of this CatalogSourcePayload.
        config source type.


        :return: The config_source_type of this CatalogSourcePayload.
        :rtype: str
        """
        return self._config_source_type

    @config_source_type.setter
    def config_source_type(self, config_source_type):
        """
        Sets the config_source_type of this CatalogSourcePayload.
        config source type.


        :param config_source_type: The config_source_type of this CatalogSourcePayload.
        :type: str
        """
        self._config_source_type = config_source_type

    @property
    def working_directory(self):
        """
        Gets the working_directory of this CatalogSourcePayload.
        File path to the directory to use for running Terraform. If not specified, the root directory is used.


        :return: The working_directory of this CatalogSourcePayload.
        :rtype: str
        """
        return self._working_directory

    @working_directory.setter
    def working_directory(self, working_directory):
        """
        Sets the working_directory of this CatalogSourcePayload.
        File path to the directory to use for running Terraform. If not specified, the root directory is used.


        :param working_directory: The working_directory of this CatalogSourcePayload.
        :type: str
        """
        self._working_directory = working_directory

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
