# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateProvisionDetails(object):
    """
    The data to create a FamProvision.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateProvisionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateProvisionDetails.
        :type display_name: str

        :param provision_description:
            The value to assign to the provision_description property of this CreateProvisionDetails.
        :type provision_description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateProvisionDetails.
        :type compartment_id: str

        :param package_catalog_item_id:
            The value to assign to the package_catalog_item_id property of this CreateProvisionDetails.
        :type package_catalog_item_id: str

        :param config_catalog_item_id:
            The value to assign to the config_catalog_item_id property of this CreateProvisionDetails.
        :type config_catalog_item_id: str

        :param fleet_id:
            The value to assign to the fleet_id property of this CreateProvisionDetails.
        :type fleet_id: str

        :param tf_variable_tenancy_id:
            The value to assign to the tf_variable_tenancy_id property of this CreateProvisionDetails.
        :type tf_variable_tenancy_id: str

        :param tf_variable_region_id:
            The value to assign to the tf_variable_region_id property of this CreateProvisionDetails.
        :type tf_variable_region_id: str

        :param tf_variable_current_user_id:
            The value to assign to the tf_variable_current_user_id property of this CreateProvisionDetails.
        :type tf_variable_current_user_id: str

        :param tf_variable_compartment_id:
            The value to assign to the tf_variable_compartment_id property of this CreateProvisionDetails.
        :type tf_variable_compartment_id: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateProvisionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateProvisionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'provision_description': 'str',
            'compartment_id': 'str',
            'package_catalog_item_id': 'str',
            'config_catalog_item_id': 'str',
            'fleet_id': 'str',
            'tf_variable_tenancy_id': 'str',
            'tf_variable_region_id': 'str',
            'tf_variable_current_user_id': 'str',
            'tf_variable_compartment_id': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'provision_description': 'provisionDescription',
            'compartment_id': 'compartmentId',
            'package_catalog_item_id': 'packageCatalogItemId',
            'config_catalog_item_id': 'configCatalogItemId',
            'fleet_id': 'fleetId',
            'tf_variable_tenancy_id': 'tfVariableTenancyId',
            'tf_variable_region_id': 'tfVariableRegionId',
            'tf_variable_current_user_id': 'tfVariableCurrentUserId',
            'tf_variable_compartment_id': 'tfVariableCompartmentId',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._provision_description = None
        self._compartment_id = None
        self._package_catalog_item_id = None
        self._config_catalog_item_id = None
        self._fleet_id = None
        self._tf_variable_tenancy_id = None
        self._tf_variable_region_id = None
        self._tf_variable_current_user_id = None
        self._tf_variable_compartment_id = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateProvisionDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this CreateProvisionDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateProvisionDetails.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this CreateProvisionDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def provision_description(self):
        """
        Gets the provision_description of this CreateProvisionDetails.
        A description of the provision.


        :return: The provision_description of this CreateProvisionDetails.
        :rtype: str
        """
        return self._provision_description

    @provision_description.setter
    def provision_description(self, provision_description):
        """
        Sets the provision_description of this CreateProvisionDetails.
        A description of the provision.


        :param provision_description: The provision_description of this CreateProvisionDetails.
        :type: str
        """
        self._provision_description = provision_description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateProvisionDetails.
        The `OCID`__ of the compartment to create the FamProvision in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateProvisionDetails.
        The `OCID`__ of the compartment to create the FamProvision in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateProvisionDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def package_catalog_item_id(self):
        """
        **[Required]** Gets the package_catalog_item_id of this CreateProvisionDetails.
        The `OCID`__ of the Catalog Item.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The package_catalog_item_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._package_catalog_item_id

    @package_catalog_item_id.setter
    def package_catalog_item_id(self, package_catalog_item_id):
        """
        Sets the package_catalog_item_id of this CreateProvisionDetails.
        The `OCID`__ of the Catalog Item.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param package_catalog_item_id: The package_catalog_item_id of this CreateProvisionDetails.
        :type: str
        """
        self._package_catalog_item_id = package_catalog_item_id

    @property
    def config_catalog_item_id(self):
        """
        **[Required]** Gets the config_catalog_item_id of this CreateProvisionDetails.
        A `OCID`__ of the Catalog Item to a file with key/value pairs to set up variables for createStack API.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The config_catalog_item_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._config_catalog_item_id

    @config_catalog_item_id.setter
    def config_catalog_item_id(self, config_catalog_item_id):
        """
        Sets the config_catalog_item_id of this CreateProvisionDetails.
        A `OCID`__ of the Catalog Item to a file with key/value pairs to set up variables for createStack API.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param config_catalog_item_id: The config_catalog_item_id of this CreateProvisionDetails.
        :type: str
        """
        self._config_catalog_item_id = config_catalog_item_id

    @property
    def fleet_id(self):
        """
        **[Required]** Gets the fleet_id of this CreateProvisionDetails.
        The `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The fleet_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._fleet_id

    @fleet_id.setter
    def fleet_id(self, fleet_id):
        """
        Sets the fleet_id of this CreateProvisionDetails.
        The `OCID`__ of the Fleet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param fleet_id: The fleet_id of this CreateProvisionDetails.
        :type: str
        """
        self._fleet_id = fleet_id

    @property
    def tf_variable_tenancy_id(self):
        """
        **[Required]** Gets the tf_variable_tenancy_id of this CreateProvisionDetails.
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :return: The tf_variable_tenancy_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._tf_variable_tenancy_id

    @tf_variable_tenancy_id.setter
    def tf_variable_tenancy_id(self, tf_variable_tenancy_id):
        """
        Sets the tf_variable_tenancy_id of this CreateProvisionDetails.
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :param tf_variable_tenancy_id: The tf_variable_tenancy_id of this CreateProvisionDetails.
        :type: str
        """
        self._tf_variable_tenancy_id = tf_variable_tenancy_id

    @property
    def tf_variable_region_id(self):
        """
        **[Required]** Gets the tf_variable_region_id of this CreateProvisionDetails.
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :return: The tf_variable_region_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._tf_variable_region_id

    @tf_variable_region_id.setter
    def tf_variable_region_id(self, tf_variable_region_id):
        """
        Sets the tf_variable_region_id of this CreateProvisionDetails.
        A mandatory variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :param tf_variable_region_id: The tf_variable_region_id of this CreateProvisionDetails.
        :type: str
        """
        self._tf_variable_region_id = tf_variable_region_id

    @property
    def tf_variable_current_user_id(self):
        """
        Gets the tf_variable_current_user_id of this CreateProvisionDetails.
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :return: The tf_variable_current_user_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._tf_variable_current_user_id

    @tf_variable_current_user_id.setter
    def tf_variable_current_user_id(self, tf_variable_current_user_id):
        """
        Sets the tf_variable_current_user_id of this CreateProvisionDetails.
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :param tf_variable_current_user_id: The tf_variable_current_user_id of this CreateProvisionDetails.
        :type: str
        """
        self._tf_variable_current_user_id = tf_variable_current_user_id

    @property
    def tf_variable_compartment_id(self):
        """
        Gets the tf_variable_compartment_id of this CreateProvisionDetails.
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :return: The tf_variable_compartment_id of this CreateProvisionDetails.
        :rtype: str
        """
        return self._tf_variable_compartment_id

    @tf_variable_compartment_id.setter
    def tf_variable_compartment_id(self, tf_variable_compartment_id):
        """
        Sets the tf_variable_compartment_id of this CreateProvisionDetails.
        An optional variable added to a list of RMS variables for createStack API. Overrides the one supplied in configuration file.


        :param tf_variable_compartment_id: The tf_variable_compartment_id of this CreateProvisionDetails.
        :type: str
        """
        self._tf_variable_compartment_id = tf_variable_compartment_id

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateProvisionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateProvisionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateProvisionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateProvisionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateProvisionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateProvisionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateProvisionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateProvisionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
