# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbHomeVersionVariableDependsOn(object):
    """
    Depends on object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbHomeVersionVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_home_id:
            The value to assign to the db_home_id property of this DbHomeVersionVariableDependsOn.
        :type db_home_id: str

        """
        self.swagger_types = {
            'db_home_id': 'str'
        }
        self.attribute_map = {
            'db_home_id': 'dbHomeId'
        }
        self._db_home_id = None

    @property
    def db_home_id(self):
        """
        **[Required]** Gets the db_home_id of this DbHomeVersionVariableDependsOn.
        OCID of the DB Home.


        :return: The db_home_id of this DbHomeVersionVariableDependsOn.
        :rtype: str
        """
        return self._db_home_id

    @db_home_id.setter
    def db_home_id(self, db_home_id):
        """
        Sets the db_home_id of this DbHomeVersionVariableDependsOn.
        OCID of the DB Home.


        :param db_home_id: The db_home_id of this DbHomeVersionVariableDependsOn.
        :type: str
        """
        self._db_home_id = db_home_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
