# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DeployedResourceDetails(object):
    """
    The Filtered List Of Deployed Resources
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DeployedResourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param mode:
            The value to assign to the mode property of this DeployedResourceDetails.
        :type mode: str

        :param resource_name:
            The value to assign to the resource_name property of this DeployedResourceDetails.
        :type resource_name: str

        :param resource_provider:
            The value to assign to the resource_provider property of this DeployedResourceDetails.
        :type resource_provider: str

        :param resource_type:
            The value to assign to the resource_type property of this DeployedResourceDetails.
        :type resource_type: str

        :param resource_instance_list:
            The value to assign to the resource_instance_list property of this DeployedResourceDetails.
        :type resource_instance_list: list[oci.fleet_apps_management.models.InstanceSummary]

        """
        self.swagger_types = {
            'mode': 'str',
            'resource_name': 'str',
            'resource_provider': 'str',
            'resource_type': 'str',
            'resource_instance_list': 'list[InstanceSummary]'
        }
        self.attribute_map = {
            'mode': 'mode',
            'resource_name': 'resourceName',
            'resource_provider': 'resourceProvider',
            'resource_type': 'resourceType',
            'resource_instance_list': 'resourceInstanceList'
        }
        self._mode = None
        self._resource_name = None
        self._resource_provider = None
        self._resource_type = None
        self._resource_instance_list = None

    @property
    def mode(self):
        """
        **[Required]** Gets the mode of this DeployedResourceDetails.
        The mode of the resource. Example: \"managed\"


        :return: The mode of this DeployedResourceDetails.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """
        Sets the mode of this DeployedResourceDetails.
        The mode of the resource. Example: \"managed\"


        :param mode: The mode of this DeployedResourceDetails.
        :type: str
        """
        self._mode = mode

    @property
    def resource_name(self):
        """
        **[Required]** Gets the resource_name of this DeployedResourceDetails.
        The name of the resource


        :return: The resource_name of this DeployedResourceDetails.
        :rtype: str
        """
        return self._resource_name

    @resource_name.setter
    def resource_name(self, resource_name):
        """
        Sets the resource_name of this DeployedResourceDetails.
        The name of the resource


        :param resource_name: The resource_name of this DeployedResourceDetails.
        :type: str
        """
        self._resource_name = resource_name

    @property
    def resource_provider(self):
        """
        **[Required]** Gets the resource_provider of this DeployedResourceDetails.
        The name of the Provider


        :return: The resource_provider of this DeployedResourceDetails.
        :rtype: str
        """
        return self._resource_provider

    @resource_provider.setter
    def resource_provider(self, resource_provider):
        """
        Sets the resource_provider of this DeployedResourceDetails.
        The name of the Provider


        :param resource_provider: The resource_provider of this DeployedResourceDetails.
        :type: str
        """
        self._resource_provider = resource_provider

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this DeployedResourceDetails.
        The provider resource type. Must be supported by the `Oracle Cloud Infrastructure provider`__.
        Example: oci_core_instance

        __ https://registry.terraform.io/providers/oracle/oci/latest/docs


        :return: The resource_type of this DeployedResourceDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this DeployedResourceDetails.
        The provider resource type. Must be supported by the `Oracle Cloud Infrastructure provider`__.
        Example: oci_core_instance

        __ https://registry.terraform.io/providers/oracle/oci/latest/docs


        :param resource_type: The resource_type of this DeployedResourceDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def resource_instance_list(self):
        """
        **[Required]** Gets the resource_instance_list of this DeployedResourceDetails.
        Collection of InstanceSummary


        :return: The resource_instance_list of this DeployedResourceDetails.
        :rtype: list[oci.fleet_apps_management.models.InstanceSummary]
        """
        return self._resource_instance_list

    @resource_instance_list.setter
    def resource_instance_list(self, resource_instance_list):
        """
        Sets the resource_instance_list of this DeployedResourceDetails.
        Collection of InstanceSummary


        :param resource_instance_list: The resource_instance_list of this DeployedResourceDetails.
        :type: list[oci.fleet_apps_management.models.InstanceSummary]
        """
        self._resource_instance_list = resource_instance_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
