# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Fleet(object):
    """
    A fleet is a collection or grouping of resources based on criteria.
    """

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Fleet.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new Fleet object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Fleet.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Fleet.
        :type compartment_id: str

        :param resource_region:
            The value to assign to the resource_region property of this Fleet.
        :type resource_region: str

        :param display_name:
            The value to assign to the display_name property of this Fleet.
        :type display_name: str

        :param description:
            The value to assign to the description property of this Fleet.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this Fleet.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Fleet.
        :type time_updated: datetime

        :param products:
            The value to assign to the products property of this Fleet.
        :type products: list[str]

        :param details:
            The value to assign to the details property of this Fleet.
        :type details: oci.fleet_apps_management.models.FleetDetails

        :param environment_type:
            The value to assign to the environment_type property of this Fleet.
        :type environment_type: str

        :param resource_selection:
            The value to assign to the resource_selection property of this Fleet.
        :type resource_selection: oci.fleet_apps_management.models.ResourceSelection

        :param notification_preferences:
            The value to assign to the notification_preferences property of this Fleet.
        :type notification_preferences: list[oci.fleet_apps_management.models.NotificationPreference]

        :param resources:
            The value to assign to the resources property of this Fleet.
        :type resources: list[oci.fleet_apps_management.models.AssociatedFleetResourceDetails]

        :param properties:
            The value to assign to the properties property of this Fleet.
        :type properties: list[oci.fleet_apps_management.models.AssociatedFleetPropertyDetails]

        :param credentials:
            The value to assign to the credentials property of this Fleet.
        :type credentials: list[oci.fleet_apps_management.models.AssociatedFleetCredentialDetails]

        :param parent_fleet_id:
            The value to assign to the parent_fleet_id property of this Fleet.
        :type parent_fleet_id: str

        :param is_target_auto_confirm:
            The value to assign to the is_target_auto_confirm property of this Fleet.
        :type is_target_auto_confirm: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Fleet.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "UPDATING", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Fleet.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Fleet.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Fleet.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Fleet.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'resource_region': 'str',
            'display_name': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'products': 'list[str]',
            'details': 'FleetDetails',
            'environment_type': 'str',
            'resource_selection': 'ResourceSelection',
            'notification_preferences': 'list[NotificationPreference]',
            'resources': 'list[AssociatedFleetResourceDetails]',
            'properties': 'list[AssociatedFleetPropertyDetails]',
            'credentials': 'list[AssociatedFleetCredentialDetails]',
            'parent_fleet_id': 'str',
            'is_target_auto_confirm': 'bool',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'resource_region': 'resourceRegion',
            'display_name': 'displayName',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'products': 'products',
            'details': 'details',
            'environment_type': 'environmentType',
            'resource_selection': 'resourceSelection',
            'notification_preferences': 'notificationPreferences',
            'resources': 'resources',
            'properties': 'properties',
            'credentials': 'credentials',
            'parent_fleet_id': 'parentFleetId',
            'is_target_auto_confirm': 'isTargetAutoConfirm',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._resource_region = None
        self._display_name = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._products = None
        self._details = None
        self._environment_type = None
        self._resource_selection = None
        self._notification_preferences = None
        self._resources = None
        self._properties = None
        self._credentials = None
        self._parent_fleet_id = None
        self._is_target_auto_confirm = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Fleet.
        The OCID of the resource.


        :return: The id of this Fleet.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Fleet.
        The OCID of the resource.


        :param id: The id of this Fleet.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Fleet.
        Compartment OCID


        :return: The compartment_id of this Fleet.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Fleet.
        Compartment OCID


        :param compartment_id: The compartment_id of this Fleet.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_region(self):
        """
        Gets the resource_region of this Fleet.
        Associated region


        :return: The resource_region of this Fleet.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this Fleet.
        Associated region


        :param resource_region: The resource_region of this Fleet.
        :type: str
        """
        self._resource_region = resource_region

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Fleet.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this Fleet.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Fleet.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this Fleet.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Fleet.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this Fleet.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Fleet.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this Fleet.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Fleet.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this Fleet.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Fleet.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this Fleet.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Fleet.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this Fleet.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Fleet.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this Fleet.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def products(self):
        """
        Gets the products of this Fleet.
        Products associated with the Fleet.
        PlatformConfiguration Ids corresponding to the Products.


        :return: The products of this Fleet.
        :rtype: list[str]
        """
        return self._products

    @products.setter
    def products(self, products):
        """
        Sets the products of this Fleet.
        Products associated with the Fleet.
        PlatformConfiguration Ids corresponding to the Products.


        :param products: The products of this Fleet.
        :type: list[str]
        """
        self._products = products

    @property
    def details(self):
        """
        Gets the details of this Fleet.

        :return: The details of this Fleet.
        :rtype: oci.fleet_apps_management.models.FleetDetails
        """
        return self._details

    @details.setter
    def details(self, details):
        """
        Sets the details of this Fleet.

        :param details: The details of this Fleet.
        :type: oci.fleet_apps_management.models.FleetDetails
        """
        self._details = details

    @property
    def environment_type(self):
        """
        Gets the environment_type of this Fleet.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :return: The environment_type of this Fleet.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this Fleet.
        Environment Type associated with the Fleet.
        Applicable for ENVIRONMENT fleet types.


        :param environment_type: The environment_type of this Fleet.
        :type: str
        """
        self._environment_type = environment_type

    @property
    def resource_selection(self):
        """
        Gets the resource_selection of this Fleet.

        :return: The resource_selection of this Fleet.
        :rtype: oci.fleet_apps_management.models.ResourceSelection
        """
        return self._resource_selection

    @resource_selection.setter
    def resource_selection(self, resource_selection):
        """
        Sets the resource_selection of this Fleet.

        :param resource_selection: The resource_selection of this Fleet.
        :type: oci.fleet_apps_management.models.ResourceSelection
        """
        self._resource_selection = resource_selection

    @property
    def notification_preferences(self):
        """
        Gets the notification_preferences of this Fleet.
        Notification Preferences associated with the Fleet.


        :return: The notification_preferences of this Fleet.
        :rtype: list[oci.fleet_apps_management.models.NotificationPreference]
        """
        return self._notification_preferences

    @notification_preferences.setter
    def notification_preferences(self, notification_preferences):
        """
        Sets the notification_preferences of this Fleet.
        Notification Preferences associated with the Fleet.


        :param notification_preferences: The notification_preferences of this Fleet.
        :type: list[oci.fleet_apps_management.models.NotificationPreference]
        """
        self._notification_preferences = notification_preferences

    @property
    def resources(self):
        """
        Gets the resources of this Fleet.
        Resources associated with the Fleet if resourceSelectionType is MANUAL.


        :return: The resources of this Fleet.
        :rtype: list[oci.fleet_apps_management.models.AssociatedFleetResourceDetails]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this Fleet.
        Resources associated with the Fleet if resourceSelectionType is MANUAL.


        :param resources: The resources of this Fleet.
        :type: list[oci.fleet_apps_management.models.AssociatedFleetResourceDetails]
        """
        self._resources = resources

    @property
    def properties(self):
        """
        Gets the properties of this Fleet.
        Properties associated with the Fleet.


        :return: The properties of this Fleet.
        :rtype: list[oci.fleet_apps_management.models.AssociatedFleetPropertyDetails]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this Fleet.
        Properties associated with the Fleet.


        :param properties: The properties of this Fleet.
        :type: list[oci.fleet_apps_management.models.AssociatedFleetPropertyDetails]
        """
        self._properties = properties

    @property
    def credentials(self):
        """
        Gets the credentials of this Fleet.
        Credentials associated with the Fleet.


        :return: The credentials of this Fleet.
        :rtype: list[oci.fleet_apps_management.models.AssociatedFleetCredentialDetails]
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials):
        """
        Sets the credentials of this Fleet.
        Credentials associated with the Fleet.


        :param credentials: The credentials of this Fleet.
        :type: list[oci.fleet_apps_management.models.AssociatedFleetCredentialDetails]
        """
        self._credentials = credentials

    @property
    def parent_fleet_id(self):
        """
        Gets the parent_fleet_id of this Fleet.
        The `OCID`__ of the fleet that would be the parent for this fleet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The parent_fleet_id of this Fleet.
        :rtype: str
        """
        return self._parent_fleet_id

    @parent_fleet_id.setter
    def parent_fleet_id(self, parent_fleet_id):
        """
        Sets the parent_fleet_id of this Fleet.
        The `OCID`__ of the fleet that would be the parent for this fleet.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param parent_fleet_id: The parent_fleet_id of this Fleet.
        :type: str
        """
        self._parent_fleet_id = parent_fleet_id

    @property
    def is_target_auto_confirm(self):
        """
        Gets the is_target_auto_confirm of this Fleet.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :return: The is_target_auto_confirm of this Fleet.
        :rtype: bool
        """
        return self._is_target_auto_confirm

    @is_target_auto_confirm.setter
    def is_target_auto_confirm(self, is_target_auto_confirm):
        """
        Sets the is_target_auto_confirm of this Fleet.
        A value that represents if auto-confirming of the targets can be enabled.
        This will allow targets to be auto-confirmed in the fleet without manual intervention.


        :param is_target_auto_confirm: The is_target_auto_confirm of this Fleet.
        :type: bool
        """
        self._is_target_auto_confirm = is_target_auto_confirm

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Fleet.
        The lifecycle state of the Fleet.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "UPDATING", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Fleet.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Fleet.
        The lifecycle state of the Fleet.


        :param lifecycle_state: The lifecycle_state of this Fleet.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "CREATING", "DELETED", "DELETING", "FAILED", "UPDATING", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Fleet.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this Fleet.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Fleet.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this Fleet.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this Fleet.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this Fleet.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Fleet.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this Fleet.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this Fleet.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this Fleet.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Fleet.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this Fleet.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Fleet.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Fleet.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Fleet.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Fleet.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
