# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FleetResource(object):
    """
    Resource added to a fleet in Fleet Application Management.
    """

    #: A constant which can be used with the compliance_state property of a FleetResource.
    #: This constant has a value of "UNKNOWN"
    COMPLIANCE_STATE_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the compliance_state property of a FleetResource.
    #: This constant has a value of "COMPLIANT"
    COMPLIANCE_STATE_COMPLIANT = "COMPLIANT"

    #: A constant which can be used with the compliance_state property of a FleetResource.
    #: This constant has a value of "NON_COMPLIANT"
    COMPLIANCE_STATE_NON_COMPLIANT = "NON_COMPLIANT"

    #: A constant which can be used with the compliance_state property of a FleetResource.
    #: This constant has a value of "WARNING"
    COMPLIANCE_STATE_WARNING = "WARNING"

    #: A constant which can be used with the lifecycle_state property of a FleetResource.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a FleetResource.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a FleetResource.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a FleetResource.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new FleetResource object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this FleetResource.
        :type id: str

        :param tenancy_id:
            The value to assign to the tenancy_id property of this FleetResource.
        :type tenancy_id: str

        :param resource_region:
            The value to assign to the resource_region property of this FleetResource.
        :type resource_region: str

        :param time_created:
            The value to assign to the time_created property of this FleetResource.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this FleetResource.
        :type time_updated: datetime

        :param compartment_id:
            The value to assign to the compartment_id property of this FleetResource.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this FleetResource.
        :type display_name: str

        :param resource_id:
            The value to assign to the resource_id property of this FleetResource.
        :type resource_id: str

        :param compartment:
            The value to assign to the compartment property of this FleetResource.
        :type compartment: str

        :param compliance_state:
            The value to assign to the compliance_state property of this FleetResource.
            Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type compliance_state: str

        :param percent_compliant:
            The value to assign to the percent_compliant property of this FleetResource.
        :type percent_compliant: float

        :param tenancy_name:
            The value to assign to the tenancy_name property of this FleetResource.
        :type tenancy_name: str

        :param resource_type:
            The value to assign to the resource_type property of this FleetResource.
        :type resource_type: str

        :param product_count:
            The value to assign to the product_count property of this FleetResource.
        :type product_count: int

        :param target_count:
            The value to assign to the target_count property of this FleetResource.
        :type target_count: int

        :param product:
            The value to assign to the product property of this FleetResource.
        :type product: str

        :param environment_type:
            The value to assign to the environment_type property of this FleetResource.
        :type environment_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this FleetResource.
            Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this FleetResource.
        :type lifecycle_details: str

        :param system_tags:
            The value to assign to the system_tags property of this FleetResource.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'tenancy_id': 'str',
            'resource_region': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'compartment_id': 'str',
            'display_name': 'str',
            'resource_id': 'str',
            'compartment': 'str',
            'compliance_state': 'str',
            'percent_compliant': 'float',
            'tenancy_name': 'str',
            'resource_type': 'str',
            'product_count': 'int',
            'target_count': 'int',
            'product': 'str',
            'environment_type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'tenancy_id': 'tenancyId',
            'resource_region': 'resourceRegion',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'resource_id': 'resourceId',
            'compartment': 'compartment',
            'compliance_state': 'complianceState',
            'percent_compliant': 'percentCompliant',
            'tenancy_name': 'tenancyName',
            'resource_type': 'resourceType',
            'product_count': 'productCount',
            'target_count': 'targetCount',
            'product': 'product',
            'environment_type': 'environmentType',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._tenancy_id = None
        self._resource_region = None
        self._time_created = None
        self._time_updated = None
        self._compartment_id = None
        self._display_name = None
        self._resource_id = None
        self._compartment = None
        self._compliance_state = None
        self._percent_compliant = None
        self._tenancy_name = None
        self._resource_type = None
        self._product_count = None
        self._target_count = None
        self._product = None
        self._environment_type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this FleetResource.
        The unique id of the resource.


        :return: The id of this FleetResource.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FleetResource.
        The unique id of the resource.


        :param id: The id of this FleetResource.
        :type: str
        """
        self._id = id

    @property
    def tenancy_id(self):
        """
        **[Required]** Gets the tenancy_id of this FleetResource.
        OCID of the tenancy to which the resource belongs to.


        :return: The tenancy_id of this FleetResource.
        :rtype: str
        """
        return self._tenancy_id

    @tenancy_id.setter
    def tenancy_id(self, tenancy_id):
        """
        Sets the tenancy_id of this FleetResource.
        OCID of the tenancy to which the resource belongs to.


        :param tenancy_id: The tenancy_id of this FleetResource.
        :type: str
        """
        self._tenancy_id = tenancy_id

    @property
    def resource_region(self):
        """
        Gets the resource_region of this FleetResource.
        Associated region


        :return: The resource_region of this FleetResource.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this FleetResource.
        Associated region


        :param resource_region: The resource_region of this FleetResource.
        :type: str
        """
        self._resource_region = resource_region

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this FleetResource.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this FleetResource.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this FleetResource.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this FleetResource.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this FleetResource.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this FleetResource.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this FleetResource.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this FleetResource.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this FleetResource.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this FleetResource.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this FleetResource.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this FleetResource.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this FleetResource.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this FleetResource.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this FleetResource.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this FleetResource.
        :type: str
        """
        self._display_name = display_name

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this FleetResource.
        The OCID of the resource.


        :return: The resource_id of this FleetResource.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this FleetResource.
        The OCID of the resource.


        :param resource_id: The resource_id of this FleetResource.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def compartment(self):
        """
        Gets the compartment of this FleetResource.
        Resource Compartment name.


        :return: The compartment of this FleetResource.
        :rtype: str
        """
        return self._compartment

    @compartment.setter
    def compartment(self, compartment):
        """
        Sets the compartment of this FleetResource.
        Resource Compartment name.


        :param compartment: The compartment of this FleetResource.
        :type: str
        """
        self._compartment = compartment

    @property
    def compliance_state(self):
        """
        Gets the compliance_state of this FleetResource.
        Compliance State of the Resource.

        Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The compliance_state of this FleetResource.
        :rtype: str
        """
        return self._compliance_state

    @compliance_state.setter
    def compliance_state(self, compliance_state):
        """
        Sets the compliance_state of this FleetResource.
        Compliance State of the Resource.


        :param compliance_state: The compliance_state of this FleetResource.
        :type: str
        """
        allowed_values = ["UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING"]
        if not value_allowed_none_or_none_sentinel(compliance_state, allowed_values):
            compliance_state = 'UNKNOWN_ENUM_VALUE'
        self._compliance_state = compliance_state

    @property
    def percent_compliant(self):
        """
        Gets the percent_compliant of this FleetResource.
        The compliance percentage.


        :return: The percent_compliant of this FleetResource.
        :rtype: float
        """
        return self._percent_compliant

    @percent_compliant.setter
    def percent_compliant(self, percent_compliant):
        """
        Sets the percent_compliant of this FleetResource.
        The compliance percentage.


        :param percent_compliant: The percent_compliant of this FleetResource.
        :type: float
        """
        self._percent_compliant = percent_compliant

    @property
    def tenancy_name(self):
        """
        Gets the tenancy_name of this FleetResource.
        Resource Tenancy Name.


        :return: The tenancy_name of this FleetResource.
        :rtype: str
        """
        return self._tenancy_name

    @tenancy_name.setter
    def tenancy_name(self, tenancy_name):
        """
        Sets the tenancy_name of this FleetResource.
        Resource Tenancy Name.


        :param tenancy_name: The tenancy_name of this FleetResource.
        :type: str
        """
        self._tenancy_name = tenancy_name

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this FleetResource.
        Type of the Resource.


        :return: The resource_type of this FleetResource.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this FleetResource.
        Type of the Resource.


        :param resource_type: The resource_type of this FleetResource.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def product_count(self):
        """
        Gets the product_count of this FleetResource.
        Count of products within the resource.


        :return: The product_count of this FleetResource.
        :rtype: int
        """
        return self._product_count

    @product_count.setter
    def product_count(self, product_count):
        """
        Sets the product_count of this FleetResource.
        Count of products within the resource.


        :param product_count: The product_count of this FleetResource.
        :type: int
        """
        self._product_count = product_count

    @property
    def target_count(self):
        """
        Gets the target_count of this FleetResource.
        Count of targets within the resource.


        :return: The target_count of this FleetResource.
        :rtype: int
        """
        return self._target_count

    @target_count.setter
    def target_count(self, target_count):
        """
        Sets the target_count of this FleetResource.
        Count of targets within the resource.


        :param target_count: The target_count of this FleetResource.
        :type: int
        """
        self._target_count = target_count

    @property
    def product(self):
        """
        Gets the product of this FleetResource.
        Product associated with the resource when the resource type is fleet.
        Will only be returned for PRODUCT fleets that are part of a GROUP Fleet.


        :return: The product of this FleetResource.
        :rtype: str
        """
        return self._product

    @product.setter
    def product(self, product):
        """
        Sets the product of this FleetResource.
        Product associated with the resource when the resource type is fleet.
        Will only be returned for PRODUCT fleets that are part of a GROUP Fleet.


        :param product: The product of this FleetResource.
        :type: str
        """
        self._product = product

    @property
    def environment_type(self):
        """
        Gets the environment_type of this FleetResource.
        Environment Type associated with the Fleet when the resource type is fleet.
        Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.


        :return: The environment_type of this FleetResource.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this FleetResource.
        Environment Type associated with the Fleet when the resource type is fleet.
        Will only be returned for ENVIRONMENT fleets that are part of a GROUP Fleet.


        :param environment_type: The environment_type of this FleetResource.
        :type: str
        """
        self._environment_type = environment_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this FleetResource.
        The current state of the FleetResource.

        Allowed values for this property are: "ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this FleetResource.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this FleetResource.
        The current state of the FleetResource.


        :param lifecycle_state: The lifecycle_state of this FleetResource.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED", "FAILED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this FleetResource.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this FleetResource.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this FleetResource.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this FleetResource.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def system_tags(self):
        """
        Gets the system_tags of this FleetResource.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this FleetResource.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this FleetResource.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this FleetResource.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
