# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportRunbookDetails(object):
    """
    Request to Import Runbook.
    """

    #: A constant which can be used with the import_option property of a ImportRunbookDetails.
    #: This constant has a value of "RETAIN"
    IMPORT_OPTION_RETAIN = "RETAIN"

    #: A constant which can be used with the import_option property of a ImportRunbookDetails.
    #: This constant has a value of "REPLACE"
    IMPORT_OPTION_REPLACE = "REPLACE"

    #: A constant which can be used with the import_option property of a ImportRunbookDetails.
    #: This constant has a value of "INCREMENT"
    IMPORT_OPTION_INCREMENT = "INCREMENT"

    def __init__(self, **kwargs):
        """
        Initializes a new ImportRunbookDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ImportRunbookDetails.
        :type compartment_id: str

        :param content_source:
            The value to assign to the content_source property of this ImportRunbookDetails.
        :type content_source: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param content_destination:
            The value to assign to the content_destination property of this ImportRunbookDetails.
        :type content_destination: oci.fleet_apps_management.models.TransferRunbookContentDetails

        :param runbook_name:
            The value to assign to the runbook_name property of this ImportRunbookDetails.
        :type runbook_name: str

        :param import_option:
            The value to assign to the import_option property of this ImportRunbookDetails.
            Allowed values for this property are: "RETAIN", "REPLACE", "INCREMENT"
        :type import_option: str

        :param version:
            The value to assign to the version property of this ImportRunbookDetails.
        :type version: str

        :param required_values:
            The value to assign to the required_values property of this ImportRunbookDetails.
        :type required_values: list[oci.fleet_apps_management.models.RunbookImportRequiredValue]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'content_source': 'TransferRunbookContentDetails',
            'content_destination': 'TransferRunbookContentDetails',
            'runbook_name': 'str',
            'import_option': 'str',
            'version': 'str',
            'required_values': 'list[RunbookImportRequiredValue]'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'content_source': 'contentSource',
            'content_destination': 'contentDestination',
            'runbook_name': 'runbookName',
            'import_option': 'importOption',
            'version': 'version',
            'required_values': 'requiredValues'
        }
        self._compartment_id = None
        self._content_source = None
        self._content_destination = None
        self._runbook_name = None
        self._import_option = None
        self._version = None
        self._required_values = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ImportRunbookDetails.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this ImportRunbookDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ImportRunbookDetails.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this ImportRunbookDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def content_source(self):
        """
        **[Required]** Gets the content_source of this ImportRunbookDetails.

        :return: The content_source of this ImportRunbookDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_source

    @content_source.setter
    def content_source(self, content_source):
        """
        Sets the content_source of this ImportRunbookDetails.

        :param content_source: The content_source of this ImportRunbookDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_source = content_source

    @property
    def content_destination(self):
        """
        **[Required]** Gets the content_destination of this ImportRunbookDetails.

        :return: The content_destination of this ImportRunbookDetails.
        :rtype: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        return self._content_destination

    @content_destination.setter
    def content_destination(self, content_destination):
        """
        Sets the content_destination of this ImportRunbookDetails.

        :param content_destination: The content_destination of this ImportRunbookDetails.
        :type: oci.fleet_apps_management.models.TransferRunbookContentDetails
        """
        self._content_destination = content_destination

    @property
    def runbook_name(self):
        """
        Gets the runbook_name of this ImportRunbookDetails.
        The name of the runbook.


        :return: The runbook_name of this ImportRunbookDetails.
        :rtype: str
        """
        return self._runbook_name

    @runbook_name.setter
    def runbook_name(self, runbook_name):
        """
        Sets the runbook_name of this ImportRunbookDetails.
        The name of the runbook.


        :param runbook_name: The runbook_name of this ImportRunbookDetails.
        :type: str
        """
        self._runbook_name = runbook_name

    @property
    def import_option(self):
        """
        Gets the import_option of this ImportRunbookDetails.
        ImportOptions for Runbook.

        Allowed values for this property are: "RETAIN", "REPLACE", "INCREMENT"


        :return: The import_option of this ImportRunbookDetails.
        :rtype: str
        """
        return self._import_option

    @import_option.setter
    def import_option(self, import_option):
        """
        Sets the import_option of this ImportRunbookDetails.
        ImportOptions for Runbook.


        :param import_option: The import_option of this ImportRunbookDetails.
        :type: str
        """
        allowed_values = ["RETAIN", "REPLACE", "INCREMENT"]
        if not value_allowed_none_or_none_sentinel(import_option, allowed_values):
            raise ValueError(
                f"Invalid value for `import_option`, must be None or one of {allowed_values}"
            )
        self._import_option = import_option

    @property
    def version(self):
        """
        Gets the version of this ImportRunbookDetails.
        Version number.


        :return: The version of this ImportRunbookDetails.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ImportRunbookDetails.
        Version number.


        :param version: The version of this ImportRunbookDetails.
        :type: str
        """
        self._version = version

    @property
    def required_values(self):
        """
        Gets the required_values of this ImportRunbookDetails.
        List of required values.


        :return: The required_values of this ImportRunbookDetails.
        :rtype: list[oci.fleet_apps_management.models.RunbookImportRequiredValue]
        """
        return self._required_values

    @required_values.setter
    def required_values(self, required_values):
        """
        Sets the required_values of this ImportRunbookDetails.
        List of required values.


        :param required_values: The required_values of this ImportRunbookDetails.
        :type: list[oci.fleet_apps_management.models.RunbookImportRequiredValue]
        """
        self._required_values = required_values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
