# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InventoryRecord(object):
    """
    Information about an inventory target.
    """

    #: A constant which can be used with the lifecycle_state property of a InventoryRecord.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new InventoryRecord object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param target_id:
            The value to assign to the target_id property of this InventoryRecord.
        :type target_id: str

        :param target_name:
            The value to assign to the target_name property of this InventoryRecord.
        :type target_name: str

        :param version:
            The value to assign to the version property of this InventoryRecord.
        :type version: str

        :param target_resource_id:
            The value to assign to the target_resource_id property of this InventoryRecord.
        :type target_resource_id: str

        :param target_resource_name:
            The value to assign to the target_resource_name property of this InventoryRecord.
        :type target_resource_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this InventoryRecord.
        :type compartment_id: str

        :param target_product_id:
            The value to assign to the target_product_id property of this InventoryRecord.
        :type target_product_id: str

        :param target_product_name:
            The value to assign to the target_product_name property of this InventoryRecord.
        :type target_product_name: str

        :param os_type:
            The value to assign to the os_type property of this InventoryRecord.
        :type os_type: str

        :param architecture:
            The value to assign to the architecture property of this InventoryRecord.
        :type architecture: str

        :param properties:
            The value to assign to the properties property of this InventoryRecord.
        :type properties: list[oci.fleet_apps_management.models.InventoryRecordProperty]

        :param components:
            The value to assign to the components property of this InventoryRecord.
        :type components: list[oci.fleet_apps_management.models.InventoryRecordComponent]

        :param installed_patches:
            The value to assign to the installed_patches property of this InventoryRecord.
        :type installed_patches: list[oci.fleet_apps_management.models.InventoryRecordPatchDetails]

        :param time_created:
            The value to assign to the time_created property of this InventoryRecord.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this InventoryRecord.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this InventoryRecord.
            Allowed values for this property are: "ACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'target_id': 'str',
            'target_name': 'str',
            'version': 'str',
            'target_resource_id': 'str',
            'target_resource_name': 'str',
            'compartment_id': 'str',
            'target_product_id': 'str',
            'target_product_name': 'str',
            'os_type': 'str',
            'architecture': 'str',
            'properties': 'list[InventoryRecordProperty]',
            'components': 'list[InventoryRecordComponent]',
            'installed_patches': 'list[InventoryRecordPatchDetails]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'target_id': 'targetId',
            'target_name': 'targetName',
            'version': 'version',
            'target_resource_id': 'targetResourceId',
            'target_resource_name': 'targetResourceName',
            'compartment_id': 'compartmentId',
            'target_product_id': 'targetProductId',
            'target_product_name': 'targetProductName',
            'os_type': 'osType',
            'architecture': 'architecture',
            'properties': 'properties',
            'components': 'components',
            'installed_patches': 'installedPatches',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState'
        }
        self._target_id = None
        self._target_name = None
        self._version = None
        self._target_resource_id = None
        self._target_resource_name = None
        self._compartment_id = None
        self._target_product_id = None
        self._target_product_name = None
        self._os_type = None
        self._architecture = None
        self._properties = None
        self._components = None
        self._installed_patches = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this InventoryRecord.
        The id of the Inventory target.


        :return: The target_id of this InventoryRecord.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this InventoryRecord.
        The id of the Inventory target.


        :param target_id: The target_id of this InventoryRecord.
        :type: str
        """
        self._target_id = target_id

    @property
    def target_name(self):
        """
        **[Required]** Gets the target_name of this InventoryRecord.
        Name of the target


        :return: The target_name of this InventoryRecord.
        :rtype: str
        """
        return self._target_name

    @target_name.setter
    def target_name(self, target_name):
        """
        Sets the target_name of this InventoryRecord.
        Name of the target


        :param target_name: The target_name of this InventoryRecord.
        :type: str
        """
        self._target_name = target_name

    @property
    def version(self):
        """
        **[Required]** Gets the version of this InventoryRecord.
        Version of the product on the target


        :return: The version of this InventoryRecord.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this InventoryRecord.
        Version of the product on the target


        :param version: The version of this InventoryRecord.
        :type: str
        """
        self._version = version

    @property
    def target_resource_id(self):
        """
        **[Required]** Gets the target_resource_id of this InventoryRecord.
        OCID of the resource associated with the target


        :return: The target_resource_id of this InventoryRecord.
        :rtype: str
        """
        return self._target_resource_id

    @target_resource_id.setter
    def target_resource_id(self, target_resource_id):
        """
        Sets the target_resource_id of this InventoryRecord.
        OCID of the resource associated with the target


        :param target_resource_id: The target_resource_id of this InventoryRecord.
        :type: str
        """
        self._target_resource_id = target_resource_id

    @property
    def target_resource_name(self):
        """
        Gets the target_resource_name of this InventoryRecord.
        Name of the resource associated with the target


        :return: The target_resource_name of this InventoryRecord.
        :rtype: str
        """
        return self._target_resource_name

    @target_resource_name.setter
    def target_resource_name(self, target_resource_name):
        """
        Sets the target_resource_name of this InventoryRecord.
        Name of the resource associated with the target


        :param target_resource_name: The target_resource_name of this InventoryRecord.
        :type: str
        """
        self._target_resource_name = target_resource_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this InventoryRecord.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this InventoryRecord.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InventoryRecord.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this InventoryRecord.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def target_product_id(self):
        """
        Gets the target_product_id of this InventoryRecord.
        OCID of the product installed at the target path


        :return: The target_product_id of this InventoryRecord.
        :rtype: str
        """
        return self._target_product_id

    @target_product_id.setter
    def target_product_id(self, target_product_id):
        """
        Sets the target_product_id of this InventoryRecord.
        OCID of the product installed at the target path


        :param target_product_id: The target_product_id of this InventoryRecord.
        :type: str
        """
        self._target_product_id = target_product_id

    @property
    def target_product_name(self):
        """
        **[Required]** Gets the target_product_name of this InventoryRecord.
        Name of the product installed at the target path


        :return: The target_product_name of this InventoryRecord.
        :rtype: str
        """
        return self._target_product_name

    @target_product_name.setter
    def target_product_name(self, target_product_name):
        """
        Sets the target_product_name of this InventoryRecord.
        Name of the product installed at the target path


        :param target_product_name: The target_product_name of this InventoryRecord.
        :type: str
        """
        self._target_product_name = target_product_name

    @property
    def os_type(self):
        """
        **[Required]** Gets the os_type of this InventoryRecord.
        OS installed on the resource associated with the target


        :return: The os_type of this InventoryRecord.
        :rtype: str
        """
        return self._os_type

    @os_type.setter
    def os_type(self, os_type):
        """
        Sets the os_type of this InventoryRecord.
        OS installed on the resource associated with the target


        :param os_type: The os_type of this InventoryRecord.
        :type: str
        """
        self._os_type = os_type

    @property
    def architecture(self):
        """
        **[Required]** Gets the architecture of this InventoryRecord.
        Architecture of the resource associated with the target


        :return: The architecture of this InventoryRecord.
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """
        Sets the architecture of this InventoryRecord.
        Architecture of the resource associated with the target


        :param architecture: The architecture of this InventoryRecord.
        :type: str
        """
        self._architecture = architecture

    @property
    def properties(self):
        """
        **[Required]** Gets the properties of this InventoryRecord.
        List of target properties


        :return: The properties of this InventoryRecord.
        :rtype: list[oci.fleet_apps_management.models.InventoryRecordProperty]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this InventoryRecord.
        List of target properties


        :param properties: The properties of this InventoryRecord.
        :type: list[oci.fleet_apps_management.models.InventoryRecordProperty]
        """
        self._properties = properties

    @property
    def components(self):
        """
        **[Required]** Gets the components of this InventoryRecord.
        List of target components


        :return: The components of this InventoryRecord.
        :rtype: list[oci.fleet_apps_management.models.InventoryRecordComponent]
        """
        return self._components

    @components.setter
    def components(self, components):
        """
        Sets the components of this InventoryRecord.
        List of target components


        :param components: The components of this InventoryRecord.
        :type: list[oci.fleet_apps_management.models.InventoryRecordComponent]
        """
        self._components = components

    @property
    def installed_patches(self):
        """
        **[Required]** Gets the installed_patches of this InventoryRecord.
        List of details on the patches currently installed on the target


        :return: The installed_patches of this InventoryRecord.
        :rtype: list[oci.fleet_apps_management.models.InventoryRecordPatchDetails]
        """
        return self._installed_patches

    @installed_patches.setter
    def installed_patches(self, installed_patches):
        """
        Sets the installed_patches of this InventoryRecord.
        List of details on the patches currently installed on the target


        :param installed_patches: The installed_patches of this InventoryRecord.
        :type: list[oci.fleet_apps_management.models.InventoryRecordPatchDetails]
        """
        self._installed_patches = installed_patches

    @property
    def time_created(self):
        """
        Gets the time_created of this InventoryRecord.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this InventoryRecord.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this InventoryRecord.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this InventoryRecord.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this InventoryRecord.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this InventoryRecord.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this InventoryRecord.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this InventoryRecord.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this InventoryRecord.
        The current state of the Inventory target.

        Allowed values for this property are: "ACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this InventoryRecord.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this InventoryRecord.
        The current state of the Inventory target.


        :param lifecycle_state: The lifecycle_state of this InventoryRecord.
        :type: str
        """
        allowed_values = ["ACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
