# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobExecutionDetails(object):
    """
    The Apply job output variable
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JobExecutionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param output_name:
            The value to assign to the output_name property of this JobExecutionDetails.
        :type output_name: str

        :param output_type:
            The value to assign to the output_type property of this JobExecutionDetails.
        :type output_type: str

        :param output_value:
            The value to assign to the output_value property of this JobExecutionDetails.
        :type output_value: str

        :param output_description:
            The value to assign to the output_description property of this JobExecutionDetails.
        :type output_description: str

        :param is_sensitive:
            The value to assign to the is_sensitive property of this JobExecutionDetails.
        :type is_sensitive: bool

        """
        self.swagger_types = {
            'output_name': 'str',
            'output_type': 'str',
            'output_value': 'str',
            'output_description': 'str',
            'is_sensitive': 'bool'
        }
        self.attribute_map = {
            'output_name': 'outputName',
            'output_type': 'outputType',
            'output_value': 'outputValue',
            'output_description': 'outputDescription',
            'is_sensitive': 'isSensitive'
        }
        self._output_name = None
        self._output_type = None
        self._output_value = None
        self._output_description = None
        self._is_sensitive = None

    @property
    def output_name(self):
        """
        **[Required]** Gets the output_name of this JobExecutionDetails.
        The output name


        :return: The output_name of this JobExecutionDetails.
        :rtype: str
        """
        return self._output_name

    @output_name.setter
    def output_name(self, output_name):
        """
        Sets the output_name of this JobExecutionDetails.
        The output name


        :param output_name: The output_name of this JobExecutionDetails.
        :type: str
        """
        self._output_name = output_name

    @property
    def output_type(self):
        """
        **[Required]** Gets the output_type of this JobExecutionDetails.
        The output type


        :return: The output_type of this JobExecutionDetails.
        :rtype: str
        """
        return self._output_type

    @output_type.setter
    def output_type(self, output_type):
        """
        Sets the output_type of this JobExecutionDetails.
        The output type


        :param output_type: The output_type of this JobExecutionDetails.
        :type: str
        """
        self._output_type = output_type

    @property
    def output_value(self):
        """
        **[Required]** Gets the output_value of this JobExecutionDetails.
        The output value


        :return: The output_value of this JobExecutionDetails.
        :rtype: str
        """
        return self._output_value

    @output_value.setter
    def output_value(self, output_value):
        """
        Sets the output_value of this JobExecutionDetails.
        The output value


        :param output_value: The output_value of this JobExecutionDetails.
        :type: str
        """
        self._output_value = output_value

    @property
    def output_description(self):
        """
        Gets the output_description of this JobExecutionDetails.
        The output description


        :return: The output_description of this JobExecutionDetails.
        :rtype: str
        """
        return self._output_description

    @output_description.setter
    def output_description(self, output_description):
        """
        Sets the output_description of this JobExecutionDetails.
        The output description


        :param output_description: The output_description of this JobExecutionDetails.
        :type: str
        """
        self._output_description = output_description

    @property
    def is_sensitive(self):
        """
        Gets the is_sensitive of this JobExecutionDetails.
        The indicator if the data for this parameter is sensitive (e.g. should the data be hidden in UI, encrypted if stored, etc.)


        :return: The is_sensitive of this JobExecutionDetails.
        :rtype: bool
        """
        return self._is_sensitive

    @is_sensitive.setter
    def is_sensitive(self, is_sensitive):
        """
        Sets the is_sensitive of this JobExecutionDetails.
        The indicator if the data for this parameter is sensitive (e.g. should the data be hidden in UI, encrypted if stored, etc.)


        :param is_sensitive: The is_sensitive of this JobExecutionDetails.
        :type: bool
        """
        self._is_sensitive = is_sensitive

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
