# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceWindowSummary(object):
    """
    Summary of the MaintenanceWindow.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceWindowSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this MaintenanceWindowSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this MaintenanceWindowSummary.
        :type compartment_id: str

        :param resource_region:
            The value to assign to the resource_region property of this MaintenanceWindowSummary.
        :type resource_region: str

        :param display_name:
            The value to assign to the display_name property of this MaintenanceWindowSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this MaintenanceWindowSummary.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this MaintenanceWindowSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this MaintenanceWindowSummary.
        :type time_updated: datetime

        :param is_outage:
            The value to assign to the is_outage property of this MaintenanceWindowSummary.
        :type is_outage: bool

        :param time_schedule_start:
            The value to assign to the time_schedule_start property of this MaintenanceWindowSummary.
        :type time_schedule_start: datetime

        :param duration:
            The value to assign to the duration property of this MaintenanceWindowSummary.
        :type duration: str

        :param is_recurring:
            The value to assign to the is_recurring property of this MaintenanceWindowSummary.
        :type is_recurring: bool

        :param recurrences:
            The value to assign to the recurrences property of this MaintenanceWindowSummary.
        :type recurrences: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this MaintenanceWindowSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this MaintenanceWindowSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this MaintenanceWindowSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this MaintenanceWindowSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this MaintenanceWindowSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'resource_region': 'str',
            'display_name': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'is_outage': 'bool',
            'time_schedule_start': 'datetime',
            'duration': 'str',
            'is_recurring': 'bool',
            'recurrences': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'resource_region': 'resourceRegion',
            'display_name': 'displayName',
            'description': 'description',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'is_outage': 'isOutage',
            'time_schedule_start': 'timeScheduleStart',
            'duration': 'duration',
            'is_recurring': 'isRecurring',
            'recurrences': 'recurrences',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._resource_region = None
        self._display_name = None
        self._description = None
        self._time_created = None
        self._time_updated = None
        self._is_outage = None
        self._time_schedule_start = None
        self._duration = None
        self._is_recurring = None
        self._recurrences = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this MaintenanceWindowSummary.
        The OCID of the resource.


        :return: The id of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this MaintenanceWindowSummary.
        The OCID of the resource.


        :param id: The id of this MaintenanceWindowSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this MaintenanceWindowSummary.
        Compartment OCID


        :return: The compartment_id of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this MaintenanceWindowSummary.
        Compartment OCID


        :param compartment_id: The compartment_id of this MaintenanceWindowSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_region(self):
        """
        Gets the resource_region of this MaintenanceWindowSummary.
        Associated region


        :return: The resource_region of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._resource_region

    @resource_region.setter
    def resource_region(self, resource_region):
        """
        Sets the resource_region of this MaintenanceWindowSummary.
        Associated region


        :param resource_region: The resource_region of this MaintenanceWindowSummary.
        :type: str
        """
        self._resource_region = resource_region

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this MaintenanceWindowSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this MaintenanceWindowSummary.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this MaintenanceWindowSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this MaintenanceWindowSummary.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The description of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this MaintenanceWindowSummary.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param description: The description of this MaintenanceWindowSummary.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this MaintenanceWindowSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :return: The time_created of this MaintenanceWindowSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this MaintenanceWindowSummary.
        The time this resource was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this MaintenanceWindowSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this MaintenanceWindowSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this MaintenanceWindowSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this MaintenanceWindowSummary.
        The time this resource was last updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this MaintenanceWindowSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def is_outage(self):
        """
        **[Required]** Gets the is_outage of this MaintenanceWindowSummary.
        Does the maintenenace window cause outage?
        An outage indicates whether a maintenance window can consider operations that require downtime.
        It means a period when the application is not accessible.


        :return: The is_outage of this MaintenanceWindowSummary.
        :rtype: bool
        """
        return self._is_outage

    @is_outage.setter
    def is_outage(self, is_outage):
        """
        Sets the is_outage of this MaintenanceWindowSummary.
        Does the maintenenace window cause outage?
        An outage indicates whether a maintenance window can consider operations that require downtime.
        It means a period when the application is not accessible.


        :param is_outage: The is_outage of this MaintenanceWindowSummary.
        :type: bool
        """
        self._is_outage = is_outage

    @property
    def time_schedule_start(self):
        """
        Gets the time_schedule_start of this MaintenanceWindowSummary.
        Specify the date and time of the day that the maintenance window starts.


        :return: The time_schedule_start of this MaintenanceWindowSummary.
        :rtype: datetime
        """
        return self._time_schedule_start

    @time_schedule_start.setter
    def time_schedule_start(self, time_schedule_start):
        """
        Sets the time_schedule_start of this MaintenanceWindowSummary.
        Specify the date and time of the day that the maintenance window starts.


        :param time_schedule_start: The time_schedule_start of this MaintenanceWindowSummary.
        :type: datetime
        """
        self._time_schedule_start = time_schedule_start

    @property
    def duration(self):
        """
        **[Required]** Gets the duration of this MaintenanceWindowSummary.
        Duration of the maintenance window.
        Specify how long the maintenance window remains open.


        :return: The duration of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """
        Sets the duration of this MaintenanceWindowSummary.
        Duration of the maintenance window.
        Specify how long the maintenance window remains open.


        :param duration: The duration of this MaintenanceWindowSummary.
        :type: str
        """
        self._duration = duration

    @property
    def is_recurring(self):
        """
        **[Required]** Gets the is_recurring of this MaintenanceWindowSummary.
        Is this a recurring maintenance window?


        :return: The is_recurring of this MaintenanceWindowSummary.
        :rtype: bool
        """
        return self._is_recurring

    @is_recurring.setter
    def is_recurring(self, is_recurring):
        """
        Sets the is_recurring of this MaintenanceWindowSummary.
        Is this a recurring maintenance window?


        :param is_recurring: The is_recurring of this MaintenanceWindowSummary.
        :type: bool
        """
        self._is_recurring = is_recurring

    @property
    def recurrences(self):
        """
        Gets the recurrences of this MaintenanceWindowSummary.
        Recurrence rule specification if maintenance window recurring.
        Specify the frequency of running the maintenance window.


        :return: The recurrences of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._recurrences

    @recurrences.setter
    def recurrences(self, recurrences):
        """
        Sets the recurrences of this MaintenanceWindowSummary.
        Recurrence rule specification if maintenance window recurring.
        Specify the frequency of running the maintenance window.


        :param recurrences: The recurrences of this MaintenanceWindowSummary.
        :type: str
        """
        self._recurrences = recurrences

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this MaintenanceWindowSummary.
        The current state of the MaintenanceWindow.


        :return: The lifecycle_state of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this MaintenanceWindowSummary.
        The current state of the MaintenanceWindow.


        :param lifecycle_state: The lifecycle_state of this MaintenanceWindowSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this MaintenanceWindowSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this MaintenanceWindowSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this MaintenanceWindowSummary.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this MaintenanceWindowSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this MaintenanceWindowSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this MaintenanceWindowSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this MaintenanceWindowSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this MaintenanceWindowSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this MaintenanceWindowSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this MaintenanceWindowSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this MaintenanceWindowSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this MaintenanceWindowSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this MaintenanceWindowSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this MaintenanceWindowSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this MaintenanceWindowSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this MaintenanceWindowSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
