# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManageJobExecutionDetails(object):
    """
    Details of the Job Execution actions.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManageJobExecutionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_details:
            The value to assign to the action_details property of this ManageJobExecutionDetails.
        :type action_details: oci.fleet_apps_management.models.UserActionDetails

        """
        self.swagger_types = {
            'action_details': 'UserActionDetails'
        }
        self.attribute_map = {
            'action_details': 'actionDetails'
        }
        self._action_details = None

    @property
    def action_details(self):
        """
        **[Required]** Gets the action_details of this ManageJobExecutionDetails.

        :return: The action_details of this ManageJobExecutionDetails.
        :rtype: oci.fleet_apps_management.models.UserActionDetails
        """
        return self._action_details

    @action_details.setter
    def action_details(self, action_details):
        """
        Sets the action_details of this ManageJobExecutionDetails.

        :param action_details: The action_details of this ManageJobExecutionDetails.
        :type: oci.fleet_apps_management.models.UserActionDetails
        """
        self._action_details = action_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
