# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Placeholder(object):
    """
    Place Holder.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Placeholder object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param step_name:
            The value to assign to the step_name property of this Placeholder.
        :type step_name: str

        :param key:
            The value to assign to the key property of this Placeholder.
        :type key: str

        :param placeholder:
            The value to assign to the placeholder property of this Placeholder.
        :type placeholder: str

        """
        self.swagger_types = {
            'step_name': 'str',
            'key': 'str',
            'placeholder': 'str'
        }
        self.attribute_map = {
            'step_name': 'stepName',
            'key': 'key',
            'placeholder': 'placeholder'
        }
        self._step_name = None
        self._key = None
        self._placeholder = None

    @property
    def step_name(self):
        """
        **[Required]** Gets the step_name of this Placeholder.
        Step name for placeholder.


        :return: The step_name of this Placeholder.
        :rtype: str
        """
        return self._step_name

    @step_name.setter
    def step_name(self, step_name):
        """
        Sets the step_name of this Placeholder.
        Step name for placeholder.


        :param step_name: The step_name of this Placeholder.
        :type: str
        """
        self._step_name = step_name

    @property
    def key(self):
        """
        Gets the key of this Placeholder.
        key for placeholder.


        :return: The key of this Placeholder.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this Placeholder.
        key for placeholder.


        :param key: The key of this Placeholder.
        :type: str
        """
        self._key = key

    @property
    def placeholder(self):
        """
        Gets the placeholder of this Placeholder.
        placeholder value .


        :return: The placeholder of this Placeholder.
        :rtype: str
        """
        return self._placeholder

    @placeholder.setter
    def placeholder(self, placeholder):
        """
        Sets the placeholder of this Placeholder.
        placeholder value .


        :param placeholder: The placeholder of this Placeholder.
        :type: str
        """
        self._placeholder = placeholder

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
