# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Prompt(object):
    """
    Prompt.
    """

    #: A constant which can be used with the acceptance_condition property of a Prompt.
    #: This constant has a value of "ANY"
    ACCEPTANCE_CONDITION_ANY = "ANY"

    #: A constant which can be used with the acceptance_condition property of a Prompt.
    #: This constant has a value of "ALL"
    ACCEPTANCE_CONDITION_ALL = "ALL"

    def __init__(self, **kwargs):
        """
        Initializes a new Prompt object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param acceptance_condition:
            The value to assign to the acceptance_condition property of this Prompt.
            Allowed values for this property are: "ANY", "ALL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type acceptance_condition: str

        :param choice_group:
            The value to assign to the choice_group property of this Prompt.
        :type choice_group: list[oci.fleet_apps_management.models.Choice]

        """
        self.swagger_types = {
            'acceptance_condition': 'str',
            'choice_group': 'list[Choice]'
        }
        self.attribute_map = {
            'acceptance_condition': 'acceptanceCondition',
            'choice_group': 'choiceGroup'
        }
        self._acceptance_condition = None
        self._choice_group = None

    @property
    def acceptance_condition(self):
        """
        **[Required]** Gets the acceptance_condition of this Prompt.
        acceptance condition.

        Allowed values for this property are: "ANY", "ALL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The acceptance_condition of this Prompt.
        :rtype: str
        """
        return self._acceptance_condition

    @acceptance_condition.setter
    def acceptance_condition(self, acceptance_condition):
        """
        Sets the acceptance_condition of this Prompt.
        acceptance condition.


        :param acceptance_condition: The acceptance_condition of this Prompt.
        :type: str
        """
        allowed_values = ["ANY", "ALL"]
        if not value_allowed_none_or_none_sentinel(acceptance_condition, allowed_values):
            acceptance_condition = 'UNKNOWN_ENUM_VALUE'
        self._acceptance_condition = acceptance_condition

    @property
    def choice_group(self):
        """
        Gets the choice_group of this Prompt.
        List of choice.


        :return: The choice_group of this Prompt.
        :rtype: list[oci.fleet_apps_management.models.Choice]
        """
        return self._choice_group

    @choice_group.setter
    def choice_group(self, choice_group):
        """
        Sets the choice_group of this Prompt.
        List of choice.


        :param choice_group: The choice_group of this Prompt.
        :type: list[oci.fleet_apps_management.models.Choice]
        """
        self._choice_group = choice_group

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
