# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Rule(object):
    """
    Rule for DYNAMIC selection.
    """

    #: A constant which can be used with the match_condition property of a Rule.
    #: This constant has a value of "MATCH_ALL"
    MATCH_CONDITION_MATCH_ALL = "MATCH_ALL"

    #: A constant which can be used with the match_condition property of a Rule.
    #: This constant has a value of "ANY"
    MATCH_CONDITION_ANY = "ANY"

    def __init__(self, **kwargs):
        """
        Initializes a new Rule object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param basis:
            The value to assign to the basis property of this Rule.
        :type basis: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Rule.
        :type compartment_id: str

        :param resource_compartment_id:
            The value to assign to the resource_compartment_id property of this Rule.
        :type resource_compartment_id: str

        :param conditions:
            The value to assign to the conditions property of this Rule.
        :type conditions: list[oci.fleet_apps_management.models.Condition]

        :param match_condition:
            The value to assign to the match_condition property of this Rule.
            Allowed values for this property are: "MATCH_ALL", "ANY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type match_condition: str

        :param compartment_id_in_subtree:
            The value to assign to the compartment_id_in_subtree property of this Rule.
        :type compartment_id_in_subtree: bool

        """
        self.swagger_types = {
            'basis': 'str',
            'compartment_id': 'str',
            'resource_compartment_id': 'str',
            'conditions': 'list[Condition]',
            'match_condition': 'str',
            'compartment_id_in_subtree': 'bool'
        }
        self.attribute_map = {
            'basis': 'basis',
            'compartment_id': 'compartmentId',
            'resource_compartment_id': 'resourceCompartmentId',
            'conditions': 'conditions',
            'match_condition': 'matchCondition',
            'compartment_id_in_subtree': 'compartmentIdInSubtree'
        }
        self._basis = None
        self._compartment_id = None
        self._resource_compartment_id = None
        self._conditions = None
        self._match_condition = None
        self._compartment_id_in_subtree = None

    @property
    def basis(self):
        """
        Gets the basis of this Rule.
        Based on what the rule is created.
        It can be based on a resourceProperty or a tag.
        If based on a tag, basis will be 'definedTagEquals'
        If based on a resource property, basis will be 'inventoryProperties'


        :return: The basis of this Rule.
        :rtype: str
        """
        return self._basis

    @basis.setter
    def basis(self, basis):
        """
        Sets the basis of this Rule.
        Based on what the rule is created.
        It can be based on a resourceProperty or a tag.
        If based on a tag, basis will be 'definedTagEquals'
        If based on a resource property, basis will be 'inventoryProperties'


        :param basis: The basis of this Rule.
        :type: str
        """
        self._basis = basis

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Rule.
        Compartment Id for which the rule is created.


        :return: The compartment_id of this Rule.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Rule.
        Compartment Id for which the rule is created.


        :param compartment_id: The compartment_id of this Rule.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_compartment_id(self):
        """
        **[Required]** Gets the resource_compartment_id of this Rule.
        The Compartment ID to dynamically search resources.
        Provide the compartment ID to which the rule is applicable.


        :return: The resource_compartment_id of this Rule.
        :rtype: str
        """
        return self._resource_compartment_id

    @resource_compartment_id.setter
    def resource_compartment_id(self, resource_compartment_id):
        """
        Sets the resource_compartment_id of this Rule.
        The Compartment ID to dynamically search resources.
        Provide the compartment ID to which the rule is applicable.


        :param resource_compartment_id: The resource_compartment_id of this Rule.
        :type: str
        """
        self._resource_compartment_id = resource_compartment_id

    @property
    def conditions(self):
        """
        **[Required]** Gets the conditions of this Rule.
        Rule Conditions


        :return: The conditions of this Rule.
        :rtype: list[oci.fleet_apps_management.models.Condition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """
        Sets the conditions of this Rule.
        Rule Conditions


        :param conditions: The conditions of this Rule.
        :type: list[oci.fleet_apps_management.models.Condition]
        """
        self._conditions = conditions

    @property
    def match_condition(self):
        """
        Gets the match_condition of this Rule.
        Match condition for the rule selection.
        Include resources that match all rules or any of the rules.
        Default value for `matchCondition` is ANY

        Allowed values for this property are: "MATCH_ALL", "ANY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The match_condition of this Rule.
        :rtype: str
        """
        return self._match_condition

    @match_condition.setter
    def match_condition(self, match_condition):
        """
        Sets the match_condition of this Rule.
        Match condition for the rule selection.
        Include resources that match all rules or any of the rules.
        Default value for `matchCondition` is ANY


        :param match_condition: The match_condition of this Rule.
        :type: str
        """
        allowed_values = ["MATCH_ALL", "ANY"]
        if not value_allowed_none_or_none_sentinel(match_condition, allowed_values):
            match_condition = 'UNKNOWN_ENUM_VALUE'
        self._match_condition = match_condition

    @property
    def compartment_id_in_subtree(self):
        """
        Gets the compartment_id_in_subtree of this Rule.
        If set to true, resources will be returned for not only the provided compartment, but all compartments which
        descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
        Default value for `compartmentIdInSubtree` is false


        :return: The compartment_id_in_subtree of this Rule.
        :rtype: bool
        """
        return self._compartment_id_in_subtree

    @compartment_id_in_subtree.setter
    def compartment_id_in_subtree(self, compartment_id_in_subtree):
        """
        Sets the compartment_id_in_subtree of this Rule.
        If set to true, resources will be returned for not only the provided compartment, but all compartments which
        descend from it. Which resources are returned and their field contents depends on the value of accessLevel.
        Default value for `compartmentIdInSubtree` is false


        :param compartment_id_in_subtree: The compartment_id_in_subtree of this Rule.
        :type: bool
        """
        self._compartment_id_in_subtree = compartment_id_in_subtree

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
