# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .filter import Filter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SingleValueFilter(Filter):
    """
    Content Source details.
    """

    #: A constant which can be used with the expression property of a SingleValueFilter.
    #: This constant has a value of "EQUAL"
    EXPRESSION_EQUAL = "EQUAL"

    #: A constant which can be used with the expression property of a SingleValueFilter.
    #: This constant has a value of "NOT_EQUAL"
    EXPRESSION_NOT_EQUAL = "NOT_EQUAL"

    #: A constant which can be used with the expression property of a SingleValueFilter.
    #: This constant has a value of "LESS_THAN"
    EXPRESSION_LESS_THAN = "LESS_THAN"

    #: A constant which can be used with the expression property of a SingleValueFilter.
    #: This constant has a value of "GREATER_THAN"
    EXPRESSION_GREATER_THAN = "GREATER_THAN"

    #: A constant which can be used with the expression property of a SingleValueFilter.
    #: This constant has a value of "LESS_THAN_OR_EQUAL_TO"
    EXPRESSION_LESS_THAN_OR_EQUAL_TO = "LESS_THAN_OR_EQUAL_TO"

    #: A constant which can be used with the expression property of a SingleValueFilter.
    #: This constant has a value of "GREATER_THAN_OR_EQUAL_TO"
    EXPRESSION_GREATER_THAN_OR_EQUAL_TO = "GREATER_THAN_OR_EQUAL_TO"

    def __init__(self, **kwargs):
        """
        Initializes a new SingleValueFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.SingleValueFilter.filter_type` attribute
        of this class is ``SINGLE_VALUE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param field_name:
            The value to assign to the field_name property of this SingleValueFilter.
        :type field_name: str

        :param filter_type:
            The value to assign to the filter_type property of this SingleValueFilter.
            Allowed values for this property are: "SINGLE_VALUE", "MULTI_VALUE"
        :type filter_type: str

        :param expression:
            The value to assign to the expression property of this SingleValueFilter.
            Allowed values for this property are: "EQUAL", "NOT_EQUAL", "LESS_THAN", "GREATER_THAN", "LESS_THAN_OR_EQUAL_TO", "GREATER_THAN_OR_EQUAL_TO"
        :type expression: str

        :param value:
            The value to assign to the value property of this SingleValueFilter.
        :type value: str

        """
        self.swagger_types = {
            'field_name': 'str',
            'filter_type': 'str',
            'expression': 'str',
            'value': 'str'
        }
        self.attribute_map = {
            'field_name': 'fieldName',
            'filter_type': 'filterType',
            'expression': 'expression',
            'value': 'value'
        }
        self._field_name = None
        self._filter_type = None
        self._expression = None
        self._value = None
        self._filter_type = 'SINGLE_VALUE'

    @property
    def expression(self):
        """
        **[Required]** Gets the expression of this SingleValueFilter.
        Expression for Filter

        Allowed values for this property are: "EQUAL", "NOT_EQUAL", "LESS_THAN", "GREATER_THAN", "LESS_THAN_OR_EQUAL_TO", "GREATER_THAN_OR_EQUAL_TO"


        :return: The expression of this SingleValueFilter.
        :rtype: str
        """
        return self._expression

    @expression.setter
    def expression(self, expression):
        """
        Sets the expression of this SingleValueFilter.
        Expression for Filter


        :param expression: The expression of this SingleValueFilter.
        :type: str
        """
        allowed_values = ["EQUAL", "NOT_EQUAL", "LESS_THAN", "GREATER_THAN", "LESS_THAN_OR_EQUAL_TO", "GREATER_THAN_OR_EQUAL_TO"]
        if not value_allowed_none_or_none_sentinel(expression, allowed_values):
            raise ValueError(
                f"Invalid value for `expression`, must be None or one of {allowed_values}"
            )
        self._expression = expression

    @property
    def value(self):
        """
        **[Required]** Gets the value of this SingleValueFilter.
        Value.


        :return: The value of this SingleValueFilter.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this SingleValueFilter.
        Value.


        :param value: The value of this SingleValueFilter.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
