# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StepSummary(object):
    """
    Task associated with the Job.
    """

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "ACCEPTED"
    STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "WAITING"
    STATUS_WAITING = "WAITING"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "SKIPPED"
    STATUS_SKIPPED = "SKIPPED"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "IGNORED"
    STATUS_IGNORED = "IGNORED"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "NOT_APPLICABLE"
    STATUS_NOT_APPLICABLE = "NOT_APPLICABLE"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "ABORTED"
    STATUS_ABORTED = "ABORTED"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "TIMED_OUT"
    STATUS_TIMED_OUT = "TIMED_OUT"

    #: A constant which can be used with the status property of a StepSummary.
    #: This constant has a value of "PAUSED"
    STATUS_PAUSED = "PAUSED"

    def __init__(self, **kwargs):
        """
        Initializes a new StepSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param task_record_id:
            The value to assign to the task_record_id property of this StepSummary.
        :type task_record_id: str

        :param step_name:
            The value to assign to the step_name property of this StepSummary.
        :type step_name: str

        :param sequence:
            The value to assign to the sequence property of this StepSummary.
        :type sequence: str

        :param status:
            The value to assign to the status property of this StepSummary.
            Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_started:
            The value to assign to the time_started property of this StepSummary.
        :type time_started: datetime

        :param time_ended:
            The value to assign to the time_ended property of this StepSummary.
        :type time_ended: datetime

        :param is_rollback_task:
            The value to assign to the is_rollback_task property of this StepSummary.
        :type is_rollback_task: bool

        :param description:
            The value to assign to the description property of this StepSummary.
        :type description: str

        :param system_tags:
            The value to assign to the system_tags property of this StepSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'task_record_id': 'str',
            'step_name': 'str',
            'sequence': 'str',
            'status': 'str',
            'time_started': 'datetime',
            'time_ended': 'datetime',
            'is_rollback_task': 'bool',
            'description': 'str',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'task_record_id': 'taskRecordId',
            'step_name': 'stepName',
            'sequence': 'sequence',
            'status': 'status',
            'time_started': 'timeStarted',
            'time_ended': 'timeEnded',
            'is_rollback_task': 'isRollbackTask',
            'description': 'description',
            'system_tags': 'systemTags'
        }
        self._task_record_id = None
        self._step_name = None
        self._sequence = None
        self._status = None
        self._time_started = None
        self._time_ended = None
        self._is_rollback_task = None
        self._description = None
        self._system_tags = None

    @property
    def task_record_id(self):
        """
        Gets the task_record_id of this StepSummary.
        The OCID of taskRecord assocaited with the step.


        :return: The task_record_id of this StepSummary.
        :rtype: str
        """
        return self._task_record_id

    @task_record_id.setter
    def task_record_id(self, task_record_id):
        """
        Sets the task_record_id of this StepSummary.
        The OCID of taskRecord assocaited with the step.


        :param task_record_id: The task_record_id of this StepSummary.
        :type: str
        """
        self._task_record_id = task_record_id

    @property
    def step_name(self):
        """
        **[Required]** Gets the step_name of this StepSummary.
        Name of the Step.


        :return: The step_name of this StepSummary.
        :rtype: str
        """
        return self._step_name

    @step_name.setter
    def step_name(self, step_name):
        """
        Sets the step_name of this StepSummary.
        Name of the Step.


        :param step_name: The step_name of this StepSummary.
        :type: str
        """
        self._step_name = step_name

    @property
    def sequence(self):
        """
        Gets the sequence of this StepSummary.
        The sequence of the step.


        :return: The sequence of this StepSummary.
        :rtype: str
        """
        return self._sequence

    @sequence.setter
    def sequence(self, sequence):
        """
        Sets the sequence of this StepSummary.
        The sequence of the step.


        :param sequence: The sequence of this StepSummary.
        :type: str
        """
        self._sequence = sequence

    @property
    def status(self):
        """
        **[Required]** Gets the status of this StepSummary.
        Status of the Task.

        Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this StepSummary.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this StepSummary.
        Status of the Task.


        :param status: The status of this StepSummary.
        :type: str
        """
        allowed_values = ["ACCEPTED", "WAITING", "IN_PROGRESS", "FAILED", "SUCCEEDED", "CANCELED", "SKIPPED", "IGNORED", "NOT_APPLICABLE", "ABORTED", "TIMED_OUT", "PAUSED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_started(self):
        """
        Gets the time_started of this StepSummary.
        The time the task started. An RFC3339 formatted datetime string


        :return: The time_started of this StepSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this StepSummary.
        The time the task started. An RFC3339 formatted datetime string


        :param time_started: The time_started of this StepSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_ended(self):
        """
        Gets the time_ended of this StepSummary.
        The time the task ended. An RFC3339 formatted datetime string


        :return: The time_ended of this StepSummary.
        :rtype: datetime
        """
        return self._time_ended

    @time_ended.setter
    def time_ended(self, time_ended):
        """
        Sets the time_ended of this StepSummary.
        The time the task ended. An RFC3339 formatted datetime string


        :param time_ended: The time_ended of this StepSummary.
        :type: datetime
        """
        self._time_ended = time_ended

    @property
    def is_rollback_task(self):
        """
        Gets the is_rollback_task of this StepSummary.
        Is this a rollback task?


        :return: The is_rollback_task of this StepSummary.
        :rtype: bool
        """
        return self._is_rollback_task

    @is_rollback_task.setter
    def is_rollback_task(self, is_rollback_task):
        """
        Sets the is_rollback_task of this StepSummary.
        Is this a rollback task?


        :param is_rollback_task: The is_rollback_task of this StepSummary.
        :type: bool
        """
        self._is_rollback_task = is_rollback_task

    @property
    def description(self):
        """
        Gets the description of this StepSummary.
        Description of the step Execution.


        :return: The description of this StepSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this StepSummary.
        Description of the step Execution.


        :param description: The description of this StepSummary.
        :type: str
        """
        self._description = description

    @property
    def system_tags(self):
        """
        Gets the system_tags of this StepSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this StepSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this StepSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this StepSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
