# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetComponentSummary(object):
    """
    Summary information about an target component.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TargetComponentSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this TargetComponentSummary.
        :type name: str

        :param version:
            The value to assign to the version property of this TargetComponentSummary.
        :type version: str

        :param path:
            The value to assign to the path property of this TargetComponentSummary.
        :type path: str

        :param properties:
            The value to assign to the properties property of this TargetComponentSummary.
        :type properties: list[oci.fleet_apps_management.models.TargetPropertySummary]

        """
        self.swagger_types = {
            'name': 'str',
            'version': 'str',
            'path': 'str',
            'properties': 'list[TargetPropertySummary]'
        }
        self.attribute_map = {
            'name': 'name',
            'version': 'version',
            'path': 'path',
            'properties': 'properties'
        }
        self._name = None
        self._version = None
        self._path = None
        self._properties = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this TargetComponentSummary.
        Name of the component


        :return: The name of this TargetComponentSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this TargetComponentSummary.
        Name of the component


        :param name: The name of this TargetComponentSummary.
        :type: str
        """
        self._name = name

    @property
    def version(self):
        """
        **[Required]** Gets the version of this TargetComponentSummary.
        Version of the component


        :return: The version of this TargetComponentSummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this TargetComponentSummary.
        Version of the component


        :param version: The version of this TargetComponentSummary.
        :type: str
        """
        self._version = version

    @property
    def path(self):
        """
        **[Required]** Gets the path of this TargetComponentSummary.
        Path of the component


        :return: The path of this TargetComponentSummary.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Sets the path of this TargetComponentSummary.
        Path of the component


        :param path: The path of this TargetComponentSummary.
        :type: str
        """
        self._path = path

    @property
    def properties(self):
        """
        Gets the properties of this TargetComponentSummary.
        List of properties.


        :return: The properties of this TargetComponentSummary.
        :rtype: list[oci.fleet_apps_management.models.TargetPropertySummary]
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this TargetComponentSummary.
        List of properties.


        :param properties: The properties of this TargetComponentSummary.
        :type: list[oci.fleet_apps_management.models.TargetPropertySummary]
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
