# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VariableGroup(object):
    """
    An organizational grouping of related variables within the schema.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VariableGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param title:
            The value to assign to the title property of this VariableGroup.
        :type title: str

        :param variables:
            The value to assign to the variables property of this VariableGroup.
        :type variables: list[str]

        :param visible:
            The value to assign to the visible property of this VariableGroup.
        :type visible: str

        """
        self.swagger_types = {
            'title': 'str',
            'variables': 'list[str]',
            'visible': 'str'
        }
        self.attribute_map = {
            'title': 'title',
            'variables': 'variables',
            'visible': 'visible'
        }
        self._title = None
        self._variables = None
        self._visible = None

    @property
    def title(self):
        """
        **[Required]** Gets the title of this VariableGroup.
        Display title for the group of variables.


        :return: The title of this VariableGroup.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this VariableGroup.
        Display title for the group of variables.


        :param title: The title of this VariableGroup.
        :type: str
        """
        self._title = title

    @property
    def variables(self):
        """
        **[Required]** Gets the variables of this VariableGroup.
        Array of variable references assigned to this group.


        :return: The variables of this VariableGroup.
        :rtype: list[str]
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """
        Sets the variables of this VariableGroup.
        Array of variable references assigned to this group.


        :param variables: The variables of this VariableGroup.
        :type: list[str]
        """
        self._variables = variables

    @property
    def visible(self):
        """
        Gets the visible of this VariableGroup.
        Hint controlling the group's visibility.


        :return: The visible of this VariableGroup.
        :rtype: str
        """
        return self._visible

    @visible.setter
    def visible(self, visible):
        """
        Sets the visible of this VariableGroup.
        Hint controlling the group's visibility.


        :param visible: The visible of this VariableGroup.
        :type: str
        """
        self._visible = visible

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
