# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Version(object):
    """
    Version for the runbook.
    Versioning runbooks in Fleet Application Management involve assigning unique identifiers or version numbers to different iterations of the runbook to track changes, improvements, and updates over time.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Version object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tasks:
            The value to assign to the tasks property of this Version.
        :type tasks: list[oci.fleet_apps_management.models.Task]

        :param groups:
            The value to assign to the groups property of this Version.
        :type groups: list[oci.fleet_apps_management.models.Group]

        :param execution_workflow_details:
            The value to assign to the execution_workflow_details property of this Version.
        :type execution_workflow_details: oci.fleet_apps_management.models.ExecutionWorkflowDetails

        :param rollback_workflow_details:
            The value to assign to the rollback_workflow_details property of this Version.
        :type rollback_workflow_details: oci.fleet_apps_management.models.RollbackWorkflowDetails

        :param version:
            The value to assign to the version property of this Version.
        :type version: str

        :param is_latest:
            The value to assign to the is_latest property of this Version.
        :type is_latest: bool

        """
        self.swagger_types = {
            'tasks': 'list[Task]',
            'groups': 'list[Group]',
            'execution_workflow_details': 'ExecutionWorkflowDetails',
            'rollback_workflow_details': 'RollbackWorkflowDetails',
            'version': 'str',
            'is_latest': 'bool'
        }
        self.attribute_map = {
            'tasks': 'tasks',
            'groups': 'groups',
            'execution_workflow_details': 'executionWorkflowDetails',
            'rollback_workflow_details': 'rollbackWorkflowDetails',
            'version': 'version',
            'is_latest': 'isLatest'
        }
        self._tasks = None
        self._groups = None
        self._execution_workflow_details = None
        self._rollback_workflow_details = None
        self._version = None
        self._is_latest = None

    @property
    def tasks(self):
        """
        **[Required]** Gets the tasks of this Version.
        A set of tasks to execute in the runbook.


        :return: The tasks of this Version.
        :rtype: list[oci.fleet_apps_management.models.Task]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """
        Sets the tasks of this Version.
        A set of tasks to execute in the runbook.


        :param tasks: The tasks of this Version.
        :type: list[oci.fleet_apps_management.models.Task]
        """
        self._tasks = tasks

    @property
    def groups(self):
        """
        **[Required]** Gets the groups of this Version.
        The groups of the runbook.


        :return: The groups of this Version.
        :rtype: list[oci.fleet_apps_management.models.Group]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this Version.
        The groups of the runbook.


        :param groups: The groups of this Version.
        :type: list[oci.fleet_apps_management.models.Group]
        """
        self._groups = groups

    @property
    def execution_workflow_details(self):
        """
        **[Required]** Gets the execution_workflow_details of this Version.

        :return: The execution_workflow_details of this Version.
        :rtype: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        return self._execution_workflow_details

    @execution_workflow_details.setter
    def execution_workflow_details(self, execution_workflow_details):
        """
        Sets the execution_workflow_details of this Version.

        :param execution_workflow_details: The execution_workflow_details of this Version.
        :type: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        self._execution_workflow_details = execution_workflow_details

    @property
    def rollback_workflow_details(self):
        """
        Gets the rollback_workflow_details of this Version.

        :return: The rollback_workflow_details of this Version.
        :rtype: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        return self._rollback_workflow_details

    @rollback_workflow_details.setter
    def rollback_workflow_details(self, rollback_workflow_details):
        """
        Sets the rollback_workflow_details of this Version.

        :param rollback_workflow_details: The rollback_workflow_details of this Version.
        :type: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        self._rollback_workflow_details = rollback_workflow_details

    @property
    def version(self):
        """
        Gets the version of this Version.
        The version of the runbook.


        :return: The version of this Version.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this Version.
        The version of the runbook.


        :param version: The version of this Version.
        :type: str
        """
        self._version = version

    @property
    def is_latest(self):
        """
        Gets the is_latest of this Version.
        Is this version the latest?


        :return: The is_latest of this Version.
        :rtype: bool
        """
        return self._is_latest

    @is_latest.setter
    def is_latest(self, is_latest):
        """
        Sets the is_latest of this Version.
        Is this version the latest?


        :param is_latest: The is_latest of this Version.
        :type: bool
        """
        self._is_latest = is_latest

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
